/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IVideoProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.LuminanceProducer;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.TextureHelper;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class LuminanceProducerImplementation
extends HandlerBase
implements IVideoProducer {
    private LuminanceProducer lumParams;
    private Framebuffer fbo;
    private static int shaderID = -1;

    @Override
    public boolean parseParameters(Object params) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (params == null || !(params instanceof LuminanceProducer)) {
            return false;
        }
        this.lumParams = (LuminanceProducer)params;
        if (shaderID == -1) {
            shaderID = TextureHelper.createProgram("lum");
        }
        return true;
    }

    @Override
    public IVideoProducer.VideoType getVideoType() {
        return IVideoProducer.VideoType.LUMINANCE;
    }

    @Override
    public int getWidth() {
        return this.lumParams.getWidth();
    }

    @Override
    public int getHeight() {
        return this.lumParams.getHeight();
    }

    @Override
    public int getRequiredBufferSize() {
        return this.getWidth() * this.getHeight();
    }

    @Override
    public void getFrame(MissionInit missionInit, ByteBuffer buffer) {
        int width = this.getWidth();
        int height = this.getHeight();
        OpenGlHelper.glUseProgram((int)shaderID);
        this.fbo.bindFramebuffer(true);
        Minecraft.getMinecraft().getFramebuffer().framebufferRenderExt(width, height, true);
        GlStateManager.bindTexture((int)this.fbo.framebufferTexture);
        GL11.glGetTexImage((int)3553, (int)0, (int)6403, (int)5121, (ByteBuffer)buffer);
        this.fbo.unbindFramebuffer();
        OpenGlHelper.glUseProgram((int)0);
    }

    @Override
    public void prepare(MissionInit missionInit) {
        this.fbo = new Framebuffer(this.getWidth(), this.getHeight(), true);
    }

    @Override
    public void cleanup() {
        this.fbo.deleteFramebuffer();
    }
}

