/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.MissionQuitCommand;
import com.microsoft.Malmo.Schemas.MissionQuitCommands;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;

public class MissionQuitCommandsImplementation
extends CommandBase
implements ICommandHandler {
    private boolean isOverriding;
    private boolean iWantToQuit;
    protected MissionQuitCommands quitcomParams;

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player == null) {
            return false;
        }
        if (!verb.equalsIgnoreCase(MissionQuitCommand.QUIT.value())) {
            return false;
        }
        player.sendChatMessage("Quitting mission");
        this.iWantToQuit = true;
        return true;
    }

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof MissionQuitCommands)) {
            return false;
        }
        this.quitcomParams = (MissionQuitCommands)params;
        this.setUpAllowAndDenyLists(this.quitcomParams.getModifierList());
        return true;
    }

    @Override
    public void install(MissionInit missionInit) {
        MissionBehaviour mb = this.parentBehaviour();
        mb.addQuitProducer(new IWantToQuit(){

            @Override
            public void prepare(MissionInit missionInit) {
            }

            @Override
            public String getOutcome() {
                return MissionQuitCommandsImplementation.this.quitcomParams.getQuitDescription();
            }

            @Override
            public boolean doIWantToQuit(MissionInit missionInit) {
                return MissionQuitCommandsImplementation.this.iWantToQuit;
            }

            @Override
            public void cleanup() {
            }
        });
    }

    @Override
    public void deinstall(MissionInit missionInit) {
    }

    @Override
    public boolean isOverriding() {
        return this.isOverriding;
    }

    @Override
    public void setOverriding(boolean b) {
        this.isOverriding = b;
    }
}

