/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.Schemas.Reward;
import com.microsoft.Malmo.Utils.SchemaHelper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class MultidimensionalReward {
    private Map<Integer, Float> map = new HashMap<Integer, Float>();
    private boolean isFinalReward = false;

    public MultidimensionalReward() {
    }

    public MultidimensionalReward(boolean isFinalReward) {
        this.isFinalReward = isFinalReward;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean isFinalReward() {
        return this.isFinalReward;
    }

    public void add(int dimension, float value) {
        if (this.map.containsKey(dimension)) {
            this.map.put(dimension, Float.valueOf(this.map.get(dimension).floatValue() + value));
        } else {
            this.map.put(dimension, Float.valueOf(value));
        }
    }

    public void add(MultidimensionalReward other) {
        for (Map.Entry<Integer, Float> entry : other.map.entrySet()) {
            Integer dimension = entry.getKey();
            Float reward_value = entry.getValue();
            this.add(dimension, reward_value.floatValue());
        }
    }

    public Reward getAsReward() {
        Reward reward = new Reward();
        for (Map.Entry<Integer, Float> entry : this.map.entrySet()) {
            Integer dimension = entry.getKey();
            Float reward_value = entry.getValue();
            Reward.Value reward_entry = new Reward.Value();
            reward_entry.setDimension(dimension);
            reward_entry.setValue(new BigDecimal(reward_value.floatValue()));
            reward.getValue().add(reward_entry);
        }
        return reward;
    }

    public String getAsXMLString() {
        String rewardString = null;
        try {
            rewardString = SchemaHelper.serialiseObject(this.getAsReward(), Reward.class);
        }
        catch (JAXBException e) {
            System.out.println("Caught reward serialization exception: " + (Object)((Object)e));
        }
        return rewardString;
    }

    public String getAsSimpleString() {
        String rewardString = "";
        for (Map.Entry<Integer, Float> entry : this.map.entrySet()) {
            Integer dimension = entry.getKey();
            Float reward_value = entry.getValue();
            if (!rewardString.isEmpty()) {
                rewardString = rewardString + ",";
            }
            rewardString = rewardString + dimension + ":" + reward_value;
        }
        return rewardString;
    }

    public double getRewardTotal() {
        double rewards = 0.0;
        for (Map.Entry<Integer, Float> entry : this.map.entrySet()) {
            rewards += (double)entry.getValue().floatValue();
        }
        return rewards;
    }

    public void clear() {
        this.map.clear();
    }
}

