/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.ScreenHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ObservationFromChatImplementation
extends HandlerBase
implements IObservationProducer {
    private static final String TITLE_TYPE = "Title";
    private static final String SUBTITLE_TYPE = "Subtitle";
    private static final String CHAT_TYPE = "Chat";
    private ArrayList<ChatMessage> chatMessagesReceived = new ArrayList();

    @Override
    public void writeObservationsToJSON(JsonObject json, MissionInit missionInit) {
        if (!this.chatMessagesReceived.isEmpty()) {
            HashMap<String, ArrayList<String>> lists = new HashMap<String, ArrayList<String>>();
            for (ChatMessage message : this.chatMessagesReceived) {
                ArrayList<String> arr = (ArrayList<String>)lists.get(message.messageType);
                if (arr == null) {
                    arr = new ArrayList<String>();
                    lists.put(message.messageType, arr);
                }
                arr.add(message.messageContent);
            }
            for (String key : lists.keySet()) {
                JsonArray jarr = new JsonArray();
                for (String message : (ArrayList)lists.get(key)) {
                    jarr.add((JsonElement)new JsonPrimitive(message));
                }
                json.add(key, (JsonElement)jarr);
            }
            this.chatMessagesReceived.clear();
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void cleanup() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onTitleChange(ScreenHelper.TitleChangeEvent event) {
        if (event.title != null) {
            this.chatMessagesReceived.add(new ChatMessage(TITLE_TYPE, TextFormatting.getTextWithoutFormattingCodes((String)event.title)));
        }
        if (event.subtitle != null) {
            this.chatMessagesReceived.add(new ChatMessage(SUBTITLE_TYPE, TextFormatting.getTextWithoutFormattingCodes((String)event.subtitle)));
        }
    }

    @SubscribeEvent
    public void onEvent(ClientChatReceivedEvent event) {
        this.chatMessagesReceived.add(new ChatMessage(CHAT_TYPE, event.getMessage().getUnformattedText()));
    }

    private class ChatMessage {
        public String messageType;
        public String messageContent;

        public ChatMessage(String messageType, String messageContent) {
            this.messageType = messageType;
            this.messageContent = messageContent;
        }
    }
}

