/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonObject;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemCompass;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ObservationFromCompassImplementation
extends HandlerBase
implements IObservationProducer {
    @Override
    public void writeObservationsToJSON(JsonObject compassJson, MissionInit missionInit) {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player == null) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        Object compassStack = null;
        boolean hasCompass = false;
        boolean hasHotbarCompass = false;
        boolean hasMainHandCompass = false;
        boolean hasOffHandCompass = false;
        for (Object itemStack : mc.player.inventory.offHandInventory) {
            if (!(itemStack.getItem() instanceof ItemCompass)) continue;
            compassStack = itemStack;
            hasCompass = true;
            hasOffHandCompass = true;
            break;
        }
        int invSlot = 0;
        for (ItemStack itemStack : mc.player.inventory.mainInventory) {
            if (!(itemStack.getItem() instanceof ItemCompass)) continue;
            compassStack = compassStack == null ? itemStack : compassStack;
            hasCompass = true;
            if (invSlot < InventoryPlayer.getHotbarSize()) {
                hasHotbarCompass = true;
            }
            if (invSlot == mc.player.inventory.currentItem) {
                hasMainHandCompass = true;
                compassStack = itemStack;
            }
            ++invSlot;
        }
        if (!hasCompass) {
            compassStack = new ItemStack((Item)new ItemCompass());
        }
        IItemPropertyGetter angleGetter = compassStack.getItem().getPropertyGetter(new ResourceLocation("angle"));
        float angle = angleGetter.apply((ItemStack)compassStack, (World)mc.world, (EntityLivingBase)mc.player);
        angle = (angle * 360.0f + 180.0f) % 360.0f - 180.0f;
        compassJson.addProperty("compassAngle", (Number)Float.valueOf(angle));
        compassJson.addProperty("hasCompass", Boolean.valueOf(hasCompass));
        compassJson.addProperty("hasHotbarCompass", Boolean.valueOf(hasHotbarCompass));
        compassJson.addProperty("hasActiveCompass", Boolean.valueOf(hasMainHandCompass || hasOffHandCompass));
        compassJson.addProperty("hasMainHandCompass", Boolean.valueOf(hasMainHandCompass));
        compassJson.addProperty("hasOffHandCompass", Boolean.valueOf(hasOffHandCompass));
        BlockPos spawn = mc.player.world.getSpawnPoint();
        compassJson.addProperty("distanceToCompassTarget", (Number)mc.player.getPosition().getDistance(spawn.getX(), spawn.getY(), spawn.getZ()));
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }
}

