/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonObject;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.NamedPoint;
import com.microsoft.Malmo.Schemas.ObservationFromDistance;
import com.microsoft.Malmo.Utils.PositionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;

public class ObservationFromDistanceImplementation
extends HandlerBase
implements IObservationProducer {
    private ObservationFromDistance odparams;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof ObservationFromDistance)) {
            return false;
        }
        this.odparams = (ObservationFromDistance)params;
        return true;
    }

    @Override
    public void writeObservationsToJSON(JsonObject json, MissionInit missionInit) {
        for (NamedPoint marker : this.odparams.getMarker()) {
            EntityPlayerSP player = Minecraft.getMinecraft().player;
            json.addProperty("distanceFrom" + this.makeSafe(marker.getName()), (Number)Float.valueOf(PositionHelper.calcDistanceFromPlayerToPosition(player, marker)));
        }
    }

    private String makeSafe(String raw) {
        return raw.trim();
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }
}

