/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.DrawItem;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;

public class ObservationFromEquippedItemImplementation
extends HandlerBase
implements IObservationProducer {
    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void writeObservationsToJSON(JsonObject json, MissionInit missionInit) {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        JsonObject equippedItems = new JsonObject();
        ItemStack mainItem = player.getHeldItemMainhand();
        ItemStack offhandItem = player.getHeldItemOffhand();
        equippedItems.add("mainhand", (JsonElement)ObservationFromEquippedItemImplementation.getInventoryJson(mainItem));
        equippedItems.add("offhand", (JsonElement)ObservationFromEquippedItemImplementation.getInventoryJson(offhandItem));
        json.add("equipped_items", (JsonElement)equippedItems);
    }

    public static JsonObject getInventoryJson(ItemStack itemToAdd) {
        JsonObject jobj = new JsonObject();
        if (itemToAdd != null && !itemToAdd.isEmpty()) {
            DrawItem di = MinecraftTypeHelper.getDrawItemFromItemStack(itemToAdd);
            String name = di.getType();
            if (di.getColour() != null) {
                jobj.addProperty("colour", di.getColour().value());
            }
            if (di.getVariant() != null) {
                jobj.addProperty("variant", di.getVariant().getValue());
            }
            jobj.addProperty("type", name);
            jobj.addProperty("quantity", (Number)itemToAdd.getCount());
            if (itemToAdd.isItemStackDamageable()) {
                jobj.addProperty("currentDamage", (Number)itemToAdd.getItemDamage());
                jobj.addProperty("maxDamage", (Number)itemToAdd.getMaxDamage());
            } else {
                jobj.addProperty("currentDamage", (Number)-1);
                jobj.addProperty("maxDamage", (Number)-1);
            }
        }
        return jobj;
    }
}

