/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.Malmo.MissionHandlers.ObservationFromServer;
import com.microsoft.Malmo.Schemas.DrawItem;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.ObservationFromFullInventory;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ObservationFromFullInventoryImplementation
extends ObservationFromServer {
    private boolean flat;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof ObservationFromFullInventory)) {
            return false;
        }
        this.flat = ((ObservationFromFullInventory)params).isFlat();
        return true;
    }

    public static String getInventoryName(IInventory inv) {
        String prefix;
        String invName = inv.getName();
        if (invName.startsWith(prefix = "container.")) {
            invName = invName.substring(prefix.length());
        }
        return invName;
    }

    public static void getInventoryJSON(JsonArray arr, IInventory inventory) {
        String invName = ObservationFromFullInventoryImplementation.getInventoryName(inventory);
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack is = inventory.getStackInSlot(i);
            if (is == null || is.isEmpty()) continue;
            JsonObject jobj = new JsonObject();
            DrawItem di = MinecraftTypeHelper.getDrawItemFromItemStack(is);
            String name = di.getType();
            if (di.getColour() != null) {
                jobj.addProperty("colour", di.getColour().value());
            }
            if (di.getVariant() != null) {
                jobj.addProperty("variant", di.getVariant().getValue());
            }
            jobj.addProperty("type", name);
            jobj.addProperty("index", (Number)i);
            jobj.addProperty("quantity", (Number)is.getCount());
            jobj.addProperty("inventory", invName);
            arr.add((JsonElement)jobj);
        }
    }

    public static void getInventoryJSON(JsonObject json, String prefix, IInventory inventory, int maxSlot) {
        int nSlots = Math.min(inventory.getSizeInventory(), maxSlot);
        for (int i = 0; i < nSlots; ++i) {
            ItemStack is = inventory.getStackInSlot(i);
            if (is == null) continue;
            json.addProperty(prefix + i + "_size", (Number)is.getCount());
            DrawItem di = MinecraftTypeHelper.getDrawItemFromItemStack(is);
            String name = di.getType();
            if (di.getColour() != null) {
                json.addProperty(prefix + i + "_colour", di.getColour().value());
            }
            if (di.getVariant() != null) {
                json.addProperty(prefix + i + "_variant", di.getVariant().getValue());
            }
            json.addProperty(prefix + i + "_item", name);
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    public ObservationFromServer.ObservationRequestMessage createObservationRequestMessage() {
        RayTraceResult rtr = Minecraft.getMinecraft().objectMouseOver;
        BlockPos pos = null;
        if (rtr != null && rtr.typeOfHit == RayTraceResult.Type.BLOCK) {
            pos = rtr.getBlockPos();
        }
        return new InventoryRequestMessage(this.flat, pos);
    }

    public static class InventoryRequestMessageHandler
    extends ObservationFromServer.ObservationRequestMessageHandler
    implements IMessageHandler<InventoryRequestMessage, IMessage> {
        @Override
        void buildJson(JsonObject json, EntityPlayerMP player, ObservationFromServer.ObservationRequestMessage message) {
            InventoryRequestMessage irm = (InventoryRequestMessage)message;
            TileEntityLockableLoot foreignInv = null;
            if (irm.pos() != null) {
                TileEntity te = player.world.getTileEntity(irm.pos());
                if (te instanceof TileEntityLockableLoot) {
                    foreignInv = (TileEntityLockableLoot)te;
                } else if (te instanceof TileEntityEnderChest) {
                    foreignInv = player.getInventoryEnderChest();
                }
            }
            if (irm.isFlat()) {
                ObservationFromFullInventoryImplementation.getInventoryJSON(json, "InventorySlot_", (IInventory)player.inventory, player.inventory.getSizeInventory());
                if (foreignInv != null) {
                    ObservationFromFullInventoryImplementation.getInventoryJSON(json, foreignInv.getName() + "Slot_", (IInventory)foreignInv, foreignInv.getSizeInventory());
                }
            } else {
                JsonArray arr = new JsonArray();
                ObservationFromFullInventoryImplementation.getInventoryJSON(arr, (IInventory)player.inventory);
                if (foreignInv != null) {
                    ObservationFromFullInventoryImplementation.getInventoryJSON(arr, (IInventory)foreignInv);
                }
                json.add("inventory", (JsonElement)arr);
            }
            JsonArray arrInvs = new JsonArray();
            JsonObject jobjPlayer = new JsonObject();
            jobjPlayer.addProperty("name", ObservationFromFullInventoryImplementation.getInventoryName((IInventory)player.inventory));
            jobjPlayer.addProperty("size", (Number)player.inventory.getSizeInventory());
            arrInvs.add((JsonElement)jobjPlayer);
            if (foreignInv != null) {
                JsonObject jobjTell = new JsonObject();
                jobjTell.addProperty("name", ObservationFromFullInventoryImplementation.getInventoryName((IInventory)foreignInv));
                jobjTell.addProperty("size", (Number)foreignInv.getSizeInventory());
                arrInvs.add((JsonElement)jobjTell);
            }
            json.add("inventoriesAvailable", (JsonElement)arrInvs);
            json.addProperty("currentItemIndex", (Number)player.inventory.currentItem);
        }

        public IMessage onMessage(InventoryRequestMessage message, MessageContext ctx) {
            return this.processMessage(message, ctx);
        }
    }

    public static class InventoryRequestMessage
    extends ObservationFromServer.ObservationRequestMessage {
        private boolean flat;
        private BlockPos pos;

        public InventoryRequestMessage() {
            this.flat = true;
            this.pos = null;
        }

        InventoryRequestMessage(boolean flat, BlockPos pos) {
            this.flat = flat;
            this.pos = pos;
        }

        @Override
        void restoreState(ByteBuf buf) {
            this.flat = buf.readBoolean();
            boolean readPos = buf.readBoolean();
            this.pos = readPos ? new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()) : null;
        }

        @Override
        void persistState(ByteBuf buf) {
            buf.writeBoolean(this.flat);
            buf.writeBoolean(this.pos != null);
            if (this.pos != null) {
                buf.writeInt(this.pos.getX());
                buf.writeInt(this.pos.getY());
                buf.writeInt(this.pos.getZ());
            }
        }

        public boolean isFlat() {
            return this.flat;
        }

        public BlockPos pos() {
            return this.pos;
        }
    }
}

