/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonObject;
import com.microsoft.Malmo.MissionHandlers.ObservationFromServer;
import com.microsoft.Malmo.Schemas.GridDefinition;
import com.microsoft.Malmo.Schemas.ObservationFromGrid;
import com.microsoft.Malmo.Utils.JSONWorldDataHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ObservationFromGridImplementation
extends ObservationFromServer {
    private List<SimpleGridDef> environs = null;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof ObservationFromGrid)) {
            return false;
        }
        ObservationFromGrid ogparams = (ObservationFromGrid)params;
        this.environs = new ArrayList<SimpleGridDef>();
        for (GridDefinition gd : ogparams.getGrid()) {
            SimpleGridDef sgd = new SimpleGridDef(gd.getMin().getX().intValue(), gd.getMin().getY().intValue(), gd.getMin().getZ().intValue(), gd.getMax().getX().intValue(), gd.getMax().getY().intValue(), gd.getMax().getZ().intValue(), gd.getName(), gd.isAbsoluteCoords());
            this.environs.add(sgd);
        }
        return true;
    }

    @Override
    public ObservationFromServer.ObservationRequestMessage createObservationRequestMessage() {
        return new GridRequestMessage(this.environs);
    }

    public static class GridRequestMessageHandler
    extends ObservationFromServer.ObservationRequestMessageHandler
    implements IMessageHandler<GridRequestMessage, IMessage> {
        @Override
        void buildJson(JsonObject json, EntityPlayerMP player, ObservationFromServer.ObservationRequestMessage message) {
            List<SimpleGridDef> environs;
            if (message instanceof GridRequestMessage && (environs = ((GridRequestMessage)message).getEnvirons()) != null) {
                for (SimpleGridDef sgd : environs) {
                    JSONWorldDataHelper.buildGridData(json, sgd.getEnvirons(), player, sgd.name);
                }
            }
        }

        public IMessage onMessage(GridRequestMessage message, MessageContext ctx) {
            return this.processMessage(message, ctx);
        }
    }

    public static class GridRequestMessage
    extends ObservationFromServer.ObservationRequestMessage {
        private List<SimpleGridDef> environs = null;

        public GridRequestMessage() {
        }

        public GridRequestMessage(List<SimpleGridDef> environs) {
            this.environs = environs;
        }

        @Override
        void restoreState(ByteBuf buf) {
            int numGrids = buf.readInt();
            this.environs = new ArrayList<SimpleGridDef>();
            for (int i = 0; i < numGrids; ++i) {
                SimpleGridDef sgd = new SimpleGridDef(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readBoolean());
                this.environs.add(sgd);
            }
        }

        @Override
        void persistState(ByteBuf buf) {
            buf.writeInt(this.environs.size());
            for (SimpleGridDef sgd : this.environs) {
                buf.writeInt(sgd.xMin);
                buf.writeInt(sgd.yMin);
                buf.writeInt(sgd.zMin);
                buf.writeInt(sgd.xMax);
                buf.writeInt(sgd.yMax);
                buf.writeInt(sgd.zMax);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)sgd.name);
                buf.writeBoolean(sgd.absoluteCoords);
            }
        }

        List<SimpleGridDef> getEnvirons() {
            return this.environs;
        }
    }

    public static class SimpleGridDef {
        int xMin;
        int yMin;
        int zMin;
        int xMax;
        int yMax;
        int zMax;
        String name;
        boolean absoluteCoords;

        SimpleGridDef(int xmin, int ymin, int zmin, int xmax, int ymax, int zmax, String name, boolean absoluteCoords) {
            this.xMin = xmin;
            this.yMin = ymin;
            this.zMin = zmin;
            this.xMax = xmax;
            this.yMax = ymax;
            this.zMax = zmax;
            this.name = name;
            this.absoluteCoords = absoluteCoords;
        }

        JSONWorldDataHelper.GridDimensions getEnvirons() {
            JSONWorldDataHelper.GridDimensions env = new JSONWorldDataHelper.GridDimensions();
            env.xMax = this.xMax;
            env.yMax = this.yMax;
            env.zMax = this.zMax;
            env.xMin = this.xMin;
            env.yMin = this.yMin;
            env.zMin = this.zMin;
            env.absoluteCoords = this.absoluteCoords;
            return env;
        }
    }
}

