/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.DrawItem;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.ObservationFromNearbyEntities;
import com.microsoft.Malmo.Schemas.RangeDefinition;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;

public class ObservationFromNearbyEntitiesImplementation
extends HandlerBase
implements IObservationProducer {
    private ObservationFromNearbyEntities oneparams;
    private int[] lastFiringTimes;
    private int tickCount = 0;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof ObservationFromNearbyEntities)) {
            return false;
        }
        this.oneparams = (ObservationFromNearbyEntities)params;
        this.lastFiringTimes = new int[this.oneparams.getRange().size()];
        return true;
    }

    @Override
    public void writeObservationsToJSON(JsonObject json, MissionInit missionInit) {
        ++this.tickCount;
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        List entities = Minecraft.getMinecraft().world.getLoadedEntityList();
        ArrayList<RangeDefinition> rangesToFire = new ArrayList<RangeDefinition>();
        int index = 0;
        for (RangeDefinition rd : this.oneparams.getRange()) {
            if (this.tickCount - this.lastFiringTimes[index] >= rd.getUpdateFrequency()) {
                rangesToFire.add(rd);
                this.lastFiringTimes[index] = this.tickCount;
            }
            ++index;
        }
        ArrayList entitiesInRange = new ArrayList();
        for (int i = 0; i < rangesToFire.size(); ++i) {
            entitiesInRange.add(new ArrayList());
        }
        for (Object e : entities) {
            if (!(e instanceof Entity)) continue;
            Entity e2 = (Entity)e;
            index = 0;
            for (RangeDefinition rd : rangesToFire) {
                if (Math.abs(e2.posX - player.posX) < rd.getXrange().doubleValue() && Math.abs(e2.posY - player.posY) < rd.getYrange().doubleValue() && Math.abs(e2.posZ - player.posZ) < rd.getZrange().doubleValue()) {
                    ((List)entitiesInRange.get(index)).add(e2);
                }
                ++index;
            }
        }
        index = 0;
        for (List list : entitiesInRange) {
            if (entitiesInRange.isEmpty()) continue;
            JsonArray arr = new JsonArray();
            for (Entity e : list) {
                JsonObject jsent = new JsonObject();
                jsent.addProperty("yaw", (Number)Float.valueOf(e.rotationYaw));
                jsent.addProperty("x", (Number)e.posX);
                jsent.addProperty("y", (Number)e.posY);
                jsent.addProperty("z", (Number)e.posZ);
                jsent.addProperty("pitch", (Number)Float.valueOf(e.rotationPitch));
                jsent.addProperty("id", e.getCachedUniqueIdString());
                jsent.addProperty("motionX", (Number)e.motionX);
                jsent.addProperty("motionY", (Number)e.motionY);
                jsent.addProperty("motionZ", (Number)e.motionZ);
                String name = MinecraftTypeHelper.getUnlocalisedEntityName(e);
                if (e instanceof EntityItem) {
                    ItemStack is = ((EntityItem)e).getEntityItem();
                    DrawItem di = MinecraftTypeHelper.getDrawItemFromItemStack(is);
                    if (di != null) {
                        name = di.getType();
                        if (di.getColour() != null) {
                            jsent.addProperty("colour", di.getColour().value());
                        }
                        if (di.getVariant() != null) {
                            jsent.addProperty("variation", di.getVariant().getValue());
                        }
                    }
                    jsent.addProperty("quantity", (Number)is.getCount());
                } else if (e instanceof EntityLivingBase) {
                    EntityLivingBase el = (EntityLivingBase)e;
                    jsent.addProperty("life", (Number)Float.valueOf(el.getHealth()));
                }
                jsent.addProperty("name", name);
                arr.add((JsonElement)jsent);
            }
            json.add(this.oneparams.getRange().get(index).getName(), (JsonElement)arr);
            ++index;
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }
}

