/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public abstract class ObservationFromServer
extends HandlerBase
implements MalmoMod.IMalmoMessageListener,
IObservationProducer {
    private String latestJsonStats = "";
    private boolean missionIsRunning = false;

    ObservationFromServer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent ev) {
        if (this.missionIsRunning) {
            ObservationRequestMessage message = this.createObservationRequestMessage();
            message.id = System.identityHashCode(this);
            MalmoMod.network.sendToServer((IMessage)message);
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        this.missionIsRunning = true;
        MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_OBSERVATIONSREADY);
    }

    @Override
    public void cleanup() {
        this.missionIsRunning = false;
        MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_OBSERVATIONSREADY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObservationsToJSON(JsonObject json, MissionInit missionInit) {
        JsonParser parser;
        JsonElement root;
        String jsonstring = "";
        String string = this.latestJsonStats;
        synchronized (string) {
            jsonstring = this.latestJsonStats;
        }
        if (jsonstring.length() > 2 && (root = (parser = new JsonParser()).parse(jsonstring)).isJsonObject()) {
            JsonObject rootObj = root.getAsJsonObject();
            for (Map.Entry entry : rootObj.entrySet()) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
        if (data != null) {
            String string = this.latestJsonStats;
            synchronized (string) {
                this.latestJsonStats = data.get("json");
                if (this.latestJsonStats == null) {
                    this.latestJsonStats = "";
                }
                this.onReturnedData(data);
            }
        }
    }

    protected void onReturnedData(Map<String, String> data) {
    }

    public abstract ObservationRequestMessage createObservationRequestMessage();

    public static abstract class ObservationRequestMessageHandler {
        public IMessage processMessage(ObservationRequestMessage message, MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().playerEntity.world;
            final EntityPlayerMP player = ctx.getServerHandler().playerEntity;
            final ObservationRequestMessage mess = message;
            mainThread.addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    JsonObject json = new JsonObject();
                    ObservationRequestMessageHandler.this.buildJson(json, player, mess);
                    HashMap<String, String> returnData = new HashMap<String, String>();
                    returnData.put("json", json.toString());
                    mess.addReturnData(returnData);
                    MalmoMod.network.sendTo((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.SERVER_OBSERVATIONSREADY, mess.id, returnData), player);
                }
            });
            return null;
        }

        abstract void buildJson(JsonObject var1, EntityPlayerMP var2, ObservationRequestMessage var3);
    }

    public static abstract class ObservationRequestMessage
    implements IMessage {
        private int id = 0;

        public ObservationRequestMessage() {
        }

        public ObservationRequestMessage(int id) {
            this.id = id;
        }

        public final void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.restoreState(buf);
        }

        public final void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            this.persistState(buf);
        }

        abstract void restoreState(ByteBuf var1);

        abstract void persistState(ByteBuf var1);

        public void addReturnData(Map<String, String> returnData) {
        }
    }
}

