/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.PlaceCommands;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PlaceCommandsImplementation
extends CommandBase
implements ICommandHandler {
    private boolean isOverriding;

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (!verb.equalsIgnoreCase("place")) {
            return false;
        }
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player == null) {
            return false;
        }
        Item item = Item.getByNameOrId((String)parameter);
        Block block = Block.getBlockFromItem((Item)item);
        if (item == null || item.getRegistryName() == null || block.getRegistryName() == null) {
            return false;
        }
        InventoryPlayer inv = player.inventory;
        boolean blockInInventory = false;
        ItemStack stackInInventory = null;
        int stackIndex = -1;
        for (int i = 0; !blockInInventory && i < inv.getSizeInventory(); ++i) {
            Item stack = inv.getStackInSlot(i).getItem();
            if (stack.getRegistryName() == null || !stack.getRegistryName().equals((Object)item.getRegistryName())) continue;
            stackInInventory = inv.getStackInSlot(i);
            stackIndex = i;
            blockInInventory = true;
        }
        if (!blockInInventory) {
            return true;
        }
        RayTraceResult mop = Minecraft.getMinecraft().objectMouseOver;
        if (mop.typeOfHit == RayTraceResult.Type.BLOCK) {
            BlockPos pos = mop.getBlockPos().add(mop.sideHit.getDirectionVec());
            AxisAlignedBB axisalignedbb = block.getDefaultState().getCollisionBoundingBox((IBlockAccess)player.world, pos);
            if (axisalignedbb == null || player.world.checkNoEntityCollision(axisalignedbb.offset(pos), null)) {
                MalmoMod.network.sendToServer((IMessage)new PlaceMessage(mop.getBlockPos(), new ItemStack(block), stackIndex, mop.sideHit, mop.hitVec));
            }
        }
        return true;
    }

    @Override
    public boolean parseParameters(Object params) {
        if (!(params instanceof PlaceCommands)) {
            return false;
        }
        PlaceCommands pParams = (PlaceCommands)params;
        this.setUpAllowAndDenyLists(pParams.getModifierList());
        return true;
    }

    @Override
    public void install(MissionInit missionInit) {
    }

    @Override
    public void deinstall(MissionInit missionInit) {
    }

    @Override
    public boolean isOverriding() {
        return this.isOverriding;
    }

    @Override
    public void setOverriding(boolean b) {
        this.isOverriding = b;
    }

    public static class PlaceMessageHandler
    implements IMessageHandler<PlaceMessage, IMessage> {
        public IMessage onMessage(PlaceMessage message, MessageContext ctx) {
            IBlockState blockType;
            System.out.println("Place message recieved");
            EntityPlayerMP player = ctx.getServerHandler().playerEntity;
            if (player == null) {
                return null;
            }
            BlockPos pos = message.pos.add(message.face.getDirectionVec());
            Block b = Block.getBlockFromItem((Item)message.itemStack.getItem());
            if (b != null && player.world.setBlockState(pos, blockType = b.getStateFromMeta(message.itemStack.getMetadata()))) {
                BlockSnapshot snapshot = new BlockSnapshot(player.world, pos, blockType);
                BlockEvent.PlaceEvent placeevent = new BlockEvent.PlaceEvent(snapshot, player.world.getBlockState(message.pos), (EntityPlayer)player);
                MinecraftForge.EVENT_BUS.post((Event)placeevent);
                if (!player.isCreative()) {
                    if (((ItemStack)player.inventory.mainInventory.get(message.itemSlot.intValue())).getCount() > 1) {
                        ((ItemStack)player.inventory.mainInventory.get(message.itemSlot.intValue())).setCount(((ItemStack)player.inventory.mainInventory.get(message.itemSlot.intValue())).getCount() - 1);
                    } else {
                        ((ItemStack)player.inventory.mainInventory.get(message.itemSlot.intValue())).setCount(0);
                    }
                }
            }
            return null;
        }
    }

    public static class PlaceMessage
    implements IMessage {
        public BlockPos pos;
        public ItemStack itemStack;
        public Integer itemSlot;
        public EnumFacing face;
        public Vec3d hitVec;

        public PlaceMessage() {
        }

        public PlaceMessage(BlockPos pos, ItemStack itemStack, int itemSlot, EnumFacing face, Vec3d hitVec) {
            this.pos = pos;
            this.itemStack = itemStack;
            this.itemSlot = itemSlot;
            this.face = face;
            this.hitVec = hitVec;
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.itemSlot = buf.readInt();
            this.face = EnumFacing.values()[buf.readInt()];
            this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.pos.getX());
            buf.writeInt(this.pos.getY());
            buf.writeInt(this.pos.getZ());
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
            buf.writeInt(this.itemSlot.intValue());
            buf.writeInt(this.face.ordinal());
            buf.writeDouble(this.hitVec.xCoord);
            buf.writeDouble(this.hitVec.yCoord);
            buf.writeDouble(this.hitVec.zCoord);
        }
    }
}

