/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.ArrayList;
import java.util.HashMap;

public class QuitFromComposite
extends HandlerBase
implements IWantToQuit {
    String quitCode = "";
    private ArrayList<IWantToQuit> quitters;
    private CombineMode mode = CombineMode.Combine_OR;

    public void addQuitter(IWantToQuit quitter) {
        if (this.quitters == null) {
            this.quitters = new ArrayList();
        }
        this.quitters.add(quitter);
    }

    public void setCombineMode(CombineMode mode) {
        this.mode = mode;
    }

    @Override
    public boolean doIWantToQuit(MissionInit missionInit) {
        if (this.quitters == null) {
            return false;
        }
        boolean result = this.mode == CombineMode.Combine_AND;
        for (IWantToQuit quitter : this.quitters) {
            boolean wantsToQuit = quitter.doIWantToQuit(missionInit);
            if (wantsToQuit) {
                this.addQuitCode(quitter.getOutcome());
            }
            if (this.mode == CombineMode.Combine_AND) {
                result &= wantsToQuit;
                continue;
            }
            result |= wantsToQuit;
        }
        return result;
    }

    private void addQuitCode(String qc) {
        if (qc == null || qc.isEmpty()) {
            return;
        }
        this.quitCode = this.quitCode == null || this.quitCode.isEmpty() ? qc : this.quitCode + ";" + qc;
    }

    @Override
    public void prepare(MissionInit missionInit) {
        for (IWantToQuit quitter : this.quitters) {
            quitter.prepare(missionInit);
        }
    }

    @Override
    public void cleanup() {
        for (IWantToQuit quitter : this.quitters) {
            quitter.cleanup();
        }
    }

    @Override
    public void appendExtraServerInformation(HashMap<String, String> map) {
        for (IWantToQuit quitter : this.quitters) {
            if (!(quitter instanceof HandlerBase)) continue;
            ((HandlerBase)((Object)quitter)).appendExtraServerInformation(map);
        }
    }

    @Override
    public String getOutcome() {
        return this.quitCode;
    }

    public boolean isFixed() {
        return false;
    }

    public static enum CombineMode {
        Combine_AND,
        Combine_OR;

    }
}

