/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RewardBase
extends HandlerBase
implements IRewardProducer {
    private String agentName;
    protected MultidimensionalReward cachedRewards = new MultidimensionalReward();

    public String getAgentName() {
        return this.agentName;
    }

    protected float adjustAndDistributeReward(float reward, int dimension, String distribution) {
        float scaled_reward = reward;
        if (distribution == null || distribution.isEmpty()) {
            return reward;
        }
        List<String> parties = Arrays.asList(distribution.split(" "));
        int ind = 0;
        for (String party : parties) {
            if (party.startsWith(this.agentName + ":")) break;
            ++ind;
        }
        if (ind == parties.size()) {
            ind = 0;
            for (String party : parties) {
                if (party.startsWith("me:")) break;
                ++ind;
            }
        }
        if (ind != parties.size()) {
            String us = parties.get(ind);
            String[] parts = us.split(":");
            if (parts.length != 2) {
                System.out.println("ERROR: malformed argument for distribution of reward - " + us);
                System.out.println("Entire reward going to " + this.agentName);
                return reward;
            }
            Float f = Float.valueOf(parts[1]);
            if (f != null) {
                scaled_reward = reward * f.floatValue();
            }
        } else {
            scaled_reward = 0.0f;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        for (String agent : parties) {
            String[] parts = agent.split(":");
            if (parts.length == 2 && ind != 0) {
                data.put(parts[0], parts[1]);
            }
            --ind;
        }
        data.put("original_reward", Float.valueOf(reward).toString());
        data.put("dimension", Integer.valueOf(dimension).toString());
        MalmoMod.network.sendToServer((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.CLIENT_SHARE_REWARD, 0, data));
        return scaled_reward;
    }

    @Override
    public void prepare(MissionInit missionInit) {
        this.agentName = missionInit.getMission().getAgentSection().get(missionInit.getClientRole()).getName();
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        reward.add(this.cachedRewards);
        this.cachedRewards.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCachedReward(int dimension, float reward) {
        MultidimensionalReward multidimensionalReward = this.cachedRewards;
        synchronized (multidimensionalReward) {
            this.cachedRewards.add(dimension, reward);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCachedReward(MultidimensionalReward reward) {
        MultidimensionalReward multidimensionalReward = this.cachedRewards;
        synchronized (multidimensionalReward) {
            this.cachedRewards.add(reward);
        }
    }

    protected void addAndShareCachedReward(int dimension, float reward, String distribution) {
        float adjusted_reward = this.adjustAndDistributeReward(reward, dimension, distribution);
        this.addCachedReward(dimension, adjusted_reward);
    }

    @Override
    public void cleanup() {
    }
}

