/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.EntityTypes;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.MobWithDescriptionAndReward;
import com.microsoft.Malmo.Schemas.RewardForCatchingMob;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RewardForCatchingMobImplementation
extends RewardBase {
    RewardForCatchingMob rcmparams;
    List<Entity> caughtEntities = new ArrayList<Entity>();

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof RewardForCatchingMob)) {
            return false;
        }
        this.rcmparams = (RewardForCatchingMob)params;
        return true;
    }

    static List<Entity> getCaughtEntities() {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        World world = player.world;
        List entities = Minecraft.getMinecraft().world.getLoadedEntityList();
        ArrayList<BlockPos> entityPositions = new ArrayList<BlockPos>();
        for (Object obj : entities) {
            if (!(obj instanceof EntityPlayer)) continue;
            EntityPlayer ep = (EntityPlayer)obj;
            entityPositions.add(new BlockPos(ep.posX, ep.posY, ep.posZ));
        }
        ArrayList<Entity> trappedEntities = new ArrayList<Entity>();
        BlockPos playerPos = new BlockPos((int)player.posX, (int)player.posY, (int)player.posZ);
        for (Object obj : entities) {
            if (obj instanceof EntityPlayer || !(obj instanceof Entity)) continue;
            Entity e = (Entity)obj;
            BlockPos entityPos = new BlockPos((int)e.posX, (int)e.posY, (int)e.posZ);
            if (entityPos.getY() != playerPos.getY()) continue;
            boolean canEscape = false;
            for (int x = -1; x <= 1 && !canEscape; ++x) {
                for (int z = -1; z <= 1 && !canEscape; ++z) {
                    BlockPos square;
                    if (Math.abs(x) == Math.abs(z) || !world.isAirBlock(square = new BlockPos(entityPos.getX() + x, entityPos.getY(), entityPos.getZ() + z)) || entityPositions.contains(square)) continue;
                    canEscape = true;
                }
            }
            if (canEscape) continue;
            trappedEntities.add(e);
        }
        return trappedEntities;
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
        List<Entity> trappedEntities = RewardForCatchingMobImplementation.getCaughtEntities();
        for (MobWithDescriptionAndReward mob : this.rcmparams.getMob()) {
            for (EntityTypes et : mob.getType()) {
                String mobName = et.value();
                for (Entity e : trappedEntities) {
                    if (!e.getName().equals(mobName)) continue;
                    if (!mob.isGlobal()) {
                        BlockPos entityPos = new BlockPos(e.posX, e.posY, e.posZ);
                        EntityPlayerSP player = Minecraft.getMinecraft().player;
                        BlockPos playerPos = new BlockPos(player.posX, player.posY, player.posZ);
                        if (Math.abs(entityPos.getX() - playerPos.getX()) + Math.abs(entityPos.getZ() - playerPos.getZ()) > 1) continue;
                    }
                    if (mob.isOneshot() && this.caughtEntities.contains(e)) continue;
                    float adjusted_reward = this.adjustAndDistributeReward(mob.getReward().floatValue(), this.rcmparams.getDimension(), mob.getDistribution());
                    reward.add(this.rcmparams.getDimension(), adjusted_reward);
                }
            }
        }
    }
}

