/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardForCollectingItemImplementation;
import com.microsoft.Malmo.MissionHandlers.RewardForItemBase;
import com.microsoft.Malmo.Schemas.BlockOrItemSpecWithReward;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.RewardForCollectingItemQuantity;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class RewardForCollectingItemQuantityImplementation
extends RewardForItemBase
implements IRewardProducer {
    private RewardForCollectingItemQuantity params;
    private ArrayList<RewardForItemBase.ItemMatcher> matchers;
    private HashMap<String, Integer> collectedItems;

    @SubscribeEvent
    public void onGainItem(RewardForCollectingItemImplementation.GainItemEvent event) {
        if (event.stack != null && event.cause == 0) {
            this.checkForMatch(event.stack);
        }
    }

    @SubscribeEvent
    public void onPickupItem(EntityItemPickupEvent event) {
        if (event.getItem() != null && event.getEntityPlayer() instanceof EntityPlayerMP) {
            this.checkForMatch(event.getItem().getEntityItem());
        }
    }

    @SubscribeEvent
    public void onItemCraft(PlayerEvent.ItemCraftedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.crafting.isEmpty()) {
            this.checkForMatch(event.crafting);
        }
    }

    @SubscribeEvent
    public void onItemSmelt(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.smelting.isEmpty()) {
            this.checkForMatch(event.smelting);
        }
    }

    private boolean getVariant(ItemStack is) {
        for (RewardForItemBase.ItemMatcher matcher : this.matchers) {
            if (!matcher.allowedItemTypes.contains(is.getItem().getUnlocalizedName())) continue;
            if (matcher.matchSpec.getColour() != null && matcher.matchSpec.getColour().size() > 0) {
                return true;
            }
            if (matcher.matchSpec.getVariant() == null || matcher.matchSpec.getVariant().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private int getCollectedItemCount(ItemStack is) {
        boolean variant = this.getVariant(is);
        if (variant) {
            return this.collectedItems.get(is.getUnlocalizedName()) == null ? 0 : this.collectedItems.get(is.getUnlocalizedName());
        }
        return this.collectedItems.get(is.getItem().getUnlocalizedName()) == null ? 0 : this.collectedItems.get(is.getItem().getUnlocalizedName());
    }

    private void addCollectedItemCount(ItemStack is) {
        boolean variant = this.getVariant(is);
        if (variant) {
            int prev = this.collectedItems.get(is.getUnlocalizedName()) == null ? 0 : this.collectedItems.get(is.getUnlocalizedName());
            this.collectedItems.put(is.getUnlocalizedName(), prev + is.getCount());
        } else {
            int prev = this.collectedItems.get(is.getItem().getUnlocalizedName()) == null ? 0 : this.collectedItems.get(is.getItem().getUnlocalizedName());
            this.collectedItems.put(is.getItem().getUnlocalizedName(), prev + is.getCount());
        }
    }

    private void checkForMatch(ItemStack is) {
        if (is != null) {
            for (RewardForItemBase.ItemMatcher matcher : this.matchers) {
                int savedCollected = this.params.isOnce() ? this.getCollectedItemCount(is) : this.getCollectedItemCount(is) % matcher.matchSpec.getAmount();
                if (!matcher.matches(is)) continue;
                if (!this.params.isSparse()) {
                    float adjusted_reward;
                    int i;
                    if (savedCollected != 0 && savedCollected < matcher.matchSpec.getAmount()) {
                        for (i = savedCollected; i < matcher.matchSpec.getAmount() && i - savedCollected < is.getCount(); ++i) {
                            int dimension = this.params.getDimension();
                            adjusted_reward = this.adjustAndDistributeReward(((BlockOrItemSpecWithReward)matcher.matchSpec).getReward().floatValue(), this.params.getDimension(), ((BlockOrItemSpecWithReward)matcher.matchSpec).getDistribution());
                            this.addCachedReward(dimension, adjusted_reward);
                        }
                        continue;
                    }
                    for (i = 0; i < is.getCount() && i < matcher.matchSpec.getAmount(); ++i) {
                        int dimension = this.params.getDimension();
                        adjusted_reward = this.adjustAndDistributeReward(((BlockOrItemSpecWithReward)matcher.matchSpec).getReward().floatValue(), this.params.getDimension(), ((BlockOrItemSpecWithReward)matcher.matchSpec).getDistribution());
                        this.addCachedReward(dimension, adjusted_reward);
                    }
                    continue;
                }
                if (savedCollected >= matcher.matchSpec.getAmount() || savedCollected + is.getCount() < matcher.matchSpec.getAmount()) continue;
                int dimension = this.params.getDimension();
                float adjusted_reward = this.adjustAndDistributeReward(((BlockOrItemSpecWithReward)matcher.matchSpec).getReward().floatValue(), this.params.getDimension(), ((BlockOrItemSpecWithReward)matcher.matchSpec).getDistribution());
                this.addCachedReward(dimension, adjusted_reward);
            }
            this.addCollectedItemCount(is);
        }
    }

    @Override
    public boolean parseParameters(Object params) {
        if (!(params instanceof RewardForCollectingItemQuantity)) {
            return false;
        }
        this.matchers = new ArrayList();
        this.params = (RewardForCollectingItemQuantity)params;
        for (BlockOrItemSpecWithReward spec : this.params.getItem()) {
            this.matchers.add(new RewardForItemBase.ItemMatcher(spec));
        }
        return true;
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.collectedItems = new HashMap();
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

