/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.RewardForDistanceTraveledToCompassTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class RewardForDistanceTraveledToCompassTargetImplementation
extends RewardBase {
    RewardForDistanceTraveledToCompassTarget params;
    double previousDistance;
    float totalReward;
    boolean positionInitialized;
    BlockPos prevSpawn;

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof RewardForDistanceTraveledToCompassTarget)) {
            return false;
        }
        this.params = (RewardForDistanceTraveledToCompassTarget)params;
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player != null && player.world != null) {
            this.prevSpawn = player.world.getSpawnPoint();
            BlockPos playerLoc = player.getPosition();
            this.previousDistance = playerLoc.getDistance(this.prevSpawn.getX(), this.prevSpawn.getY(), this.prevSpawn.getZ());
        } else {
            this.prevSpawn = new BlockPos(0, 0, 0);
            this.previousDistance = 0.0;
        }
        this.totalReward = 0.0f;
        this.positionInitialized = false;
        return true;
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        boolean sendReward = false;
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        BlockPos spawn = player.world.getSpawnPoint();
        Vec3d playerLoc = player.getPositionVector();
        Vec3d spawnPos = new Vec3d((double)spawn.getX(), (double)spawn.getY(), (double)spawn.getZ());
        double currentDistance = playerLoc.distanceTo(spawnPos);
        float delta = (float)(this.previousDistance - currentDistance);
        switch (this.params.getDensity()) {
            case MISSION_END: {
                this.totalReward += this.params.getRewardPerBlock().floatValue() * delta;
                sendReward = reward.isFinalReward();
                break;
            }
            case PER_TICK: {
                this.totalReward = this.params.getRewardPerBlock().floatValue() * delta;
                sendReward = true;
                break;
            }
            case PER_TICK_ACCUMULATED: {
                this.totalReward += this.params.getRewardPerBlock().floatValue() * delta;
                sendReward = true;
                break;
            }
        }
        if (this.prevSpawn.getX() != spawn.getX() || this.prevSpawn.getY() != spawn.getY() || this.prevSpawn.getZ() != spawn.getZ()) {
            this.totalReward = 0.0f;
        }
        this.previousDistance = currentDistance;
        this.prevSpawn = spawn;
        super.getReward(missionInit, reward);
        if (sendReward) {
            float adjusted_reward = this.adjustAndDistributeReward(this.totalReward, this.params.getDimension(), this.params.getRewardDistribution());
            reward.add(this.params.getDimension(), adjusted_reward);
        }
    }
}

