/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.BlockOrItemSpec;
import com.microsoft.Malmo.Schemas.BlockOrItemSpecWithReward;
import com.microsoft.Malmo.Schemas.DrawItem;
import com.microsoft.Malmo.Schemas.Variation;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class RewardForItemBase
extends RewardBase {
    List<ItemRewardMatcher> rewardMatchers = new ArrayList<ItemRewardMatcher>();

    protected void addItemSpecToRewardStructure(BlockOrItemSpecWithReward is) {
        this.rewardMatchers.add(new ItemRewardMatcher(is));
    }

    protected void accumulateReward(int dimension, ItemStack stack) {
        for (ItemRewardMatcher matcher : this.rewardMatchers) {
            if (!matcher.matches(stack)) continue;
            this.addAndShareCachedReward(dimension, (float)stack.getCount() * matcher.reward(), matcher.distribution());
        }
    }

    protected static void sendItemStackToClient(EntityPlayerMP player, MalmoMod.MalmoMessageType message, ItemStack is) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)is);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.getBytes(0, bytes);
        String data = DatatypeConverter.printBase64Binary((byte[])bytes);
        MalmoMod.MalmoMessage msg = new MalmoMod.MalmoMessage(message, data);
        MalmoMod.network.sendTo((IMessage)msg, player);
    }

    public class ItemRewardMatcher
    extends ItemMatcher {
        float reward;
        String distribution;

        ItemRewardMatcher(BlockOrItemSpecWithReward spec) {
            super(spec);
            this.reward = spec.getReward().floatValue();
            this.distribution = spec.getDistribution();
        }

        float reward() {
            return this.reward;
        }

        String distribution() {
            return this.distribution;
        }
    }

    public static class ItemMatcher {
        List<String> allowedItemTypes = new ArrayList<String>();
        BlockOrItemSpec matchSpec;

        ItemMatcher(BlockOrItemSpec spec) {
            this.matchSpec = spec;
            for (String itemType : spec.getType()) {
                Item item = MinecraftTypeHelper.ParseItemType(itemType, true);
                if (item == null) continue;
                this.allowedItemTypes.add(item.getUnlocalizedName());
            }
        }

        boolean matches(ItemStack stack) {
            String item = stack.getItem().getUnlocalizedName();
            if (!this.allowedItemTypes.contains(item)) {
                return false;
            }
            DrawItem di = MinecraftTypeHelper.getDrawItemFromItemStack(stack);
            if (this.matchSpec.getColour() != null && !this.matchSpec.getColour().isEmpty()) {
                if (di.getColour() == null) {
                    return false;
                }
                if (!this.matchSpec.getColour().contains((Object)di.getColour())) {
                    return false;
                }
            }
            if (this.matchSpec.getVariant() != null && !this.matchSpec.getVariant().isEmpty()) {
                if (di.getVariant() == null) {
                    return false;
                }
                for (Variation v : this.matchSpec.getVariant()) {
                    if (!v.getValue().equals(di.getVariant().getValue())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

