/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.CommandGroup;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.ChatCommand;
import com.microsoft.Malmo.Schemas.ChatMatchSpec;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.RewardForSendingMatchingChatMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RewardForSendingMatchingChatMessageImplementation
extends RewardBase
implements IRewardProducer {
    private RewardForSendingMatchingChatMessage params;
    private HashMap<Pattern, Float> patternMap = new HashMap();
    private HashMap<Pattern, String> distributionMap = new HashMap();

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof RewardForSendingMatchingChatMessage)) {
            return false;
        }
        this.params = (RewardForSendingMatchingChatMessage)params;
        for (ChatMatchSpec cm : this.params.getChatMatch()) {
            this.addChatMatchSpecToRewardStructure(cm);
        }
        return true;
    }

    private void addChatMatchSpecToRewardStructure(ChatMatchSpec c) {
        Float reward = Float.valueOf(c.getReward().floatValue());
        Pattern pattern = Pattern.compile(c.getRegex(), 2);
        this.patternMap.put(pattern, reward);
        this.distributionMap.put(pattern, c.getDistribution());
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
        MissionBehaviour mb = this.parentBehaviour();
        ICommandHandler oldch = mb.commandHandler;
        CommandGroup newch = new CommandGroup(){

            @Override
            protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
                boolean handled = super.onExecute(verb, parameter, missionInit);
                if (handled && verb.equalsIgnoreCase(ChatCommand.CHAT.value())) {
                    for (Map.Entry entry : RewardForSendingMatchingChatMessageImplementation.this.patternMap.entrySet()) {
                        Matcher m = ((Pattern)entry.getKey()).matcher(parameter);
                        if (!m.matches()) continue;
                        String distribution = (String)RewardForSendingMatchingChatMessageImplementation.this.distributionMap.get(entry.getKey());
                        RewardForSendingMatchingChatMessageImplementation.this.addAndShareCachedReward(RewardForSendingMatchingChatMessageImplementation.this.params.getDimension(), ((Float)entry.getValue()).floatValue(), distribution);
                    }
                }
                return handled;
            }
        };
        newch.setOverriding(oldch != null ? oldch.isOverriding() : true);
        if (oldch != null) {
            newch.addCommandHandler(oldch);
        }
        mb.commandHandler = newch;
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }
}

