/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardForItemBase;
import com.microsoft.Malmo.Schemas.BlockOrItemSpecWithReward;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.RewardForSmeltingItem;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class RewardForSmeltingItemImplementation
extends RewardForItemBase
implements IRewardProducer {
    private RewardForSmeltingItem params;
    private ArrayList<RewardForItemBase.ItemMatcher> matchers;
    private HashMap<String, Integer> smeltedItems;

    @SubscribeEvent
    public void onItemSmelt(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.smelting.isEmpty()) {
            this.checkForMatch(event.smelting);
        }
    }

    private boolean getVariant(ItemStack is) {
        for (RewardForItemBase.ItemMatcher matcher : this.matchers) {
            if (!matcher.allowedItemTypes.contains(is.getItem().getUnlocalizedName())) continue;
            if (matcher.matchSpec.getColour() != null && matcher.matchSpec.getColour().size() > 0) {
                return true;
            }
            if (matcher.matchSpec.getVariant() == null || matcher.matchSpec.getVariant().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private int getSmeltedItemCount(ItemStack is) {
        boolean variant = this.getVariant(is);
        if (variant) {
            return this.smeltedItems.get(is.getUnlocalizedName()) == null ? 0 : this.smeltedItems.get(is.getUnlocalizedName());
        }
        return this.smeltedItems.get(is.getItem().getUnlocalizedName()) == null ? 0 : this.smeltedItems.get(is.getItem().getUnlocalizedName());
    }

    private void addSmeltedItemCount(ItemStack is) {
        boolean variant = this.getVariant(is);
        if (variant) {
            int prev = this.smeltedItems.get(is.getUnlocalizedName()) == null ? 0 : this.smeltedItems.get(is.getUnlocalizedName());
            this.smeltedItems.put(is.getUnlocalizedName(), prev + is.getCount());
        } else {
            int prev = this.smeltedItems.get(is.getItem().getUnlocalizedName()) == null ? 0 : this.smeltedItems.get(is.getItem().getUnlocalizedName());
            this.smeltedItems.put(is.getItem().getUnlocalizedName(), prev + is.getCount());
        }
    }

    private void checkForMatch(ItemStack is) {
        int savedSmelted = this.getSmeltedItemCount(is);
        for (RewardForItemBase.ItemMatcher matcher : this.matchers) {
            if (!matcher.matches(is)) continue;
            if (!this.params.isSparse()) {
                float adjusted_reward;
                int i;
                if (savedSmelted != 0 && savedSmelted < matcher.matchSpec.getAmount()) {
                    for (i = savedSmelted; i < matcher.matchSpec.getAmount() && i - savedSmelted < is.getCount(); ++i) {
                        int dimension = this.params.getDimension();
                        adjusted_reward = this.adjustAndDistributeReward(((BlockOrItemSpecWithReward)matcher.matchSpec).getReward().floatValue(), this.params.getDimension(), ((BlockOrItemSpecWithReward)matcher.matchSpec).getDistribution());
                        this.addCachedReward(dimension, adjusted_reward);
                    }
                    continue;
                }
                if (savedSmelted != 0) continue;
                for (i = 0; i < is.getCount() && i < matcher.matchSpec.getAmount(); ++i) {
                    int dimension = this.params.getDimension();
                    adjusted_reward = this.adjustAndDistributeReward(((BlockOrItemSpecWithReward)matcher.matchSpec).getReward().floatValue(), this.params.getDimension(), ((BlockOrItemSpecWithReward)matcher.matchSpec).getDistribution());
                    this.addCachedReward(dimension, adjusted_reward);
                }
                continue;
            }
            if (savedSmelted >= matcher.matchSpec.getAmount() || savedSmelted + is.getCount() < matcher.matchSpec.getAmount()) continue;
            int dimension = this.params.getDimension();
            float adjusted_reward = this.adjustAndDistributeReward(((BlockOrItemSpecWithReward)matcher.matchSpec).getReward().floatValue(), this.params.getDimension(), ((BlockOrItemSpecWithReward)matcher.matchSpec).getDistribution());
            this.addCachedReward(dimension, adjusted_reward);
        }
        this.addSmeltedItemCount(is);
    }

    @Override
    public boolean parseParameters(Object params) {
        if (!(params instanceof RewardForSmeltingItem)) {
            return false;
        }
        this.matchers = new ArrayList();
        this.params = (RewardForSmeltingItem)params;
        for (BlockOrItemSpecWithReward spec : this.params.getItem()) {
            this.matchers.add(new RewardForItemBase.ItemMatcher(spec));
        }
        return true;
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.smeltedItems = new HashMap();
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

