/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.RewardDensityForBuildAndBreak;
import com.microsoft.Malmo.Schemas.RewardForStructureCopying;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;

public class RewardForStructureCopyingImplementation
extends RewardBase
implements IRewardProducer,
MalmoMod.IMalmoMessageListener {
    private RewardForStructureCopying rscparams;
    private RewardDensityForBuildAndBreak rewardDensity;
    private float reward = 0.0f;
    private int dimension;
    private boolean structureHasBeenCompleted = false;

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof RewardForStructureCopying)) {
            return false;
        }
        this.rscparams = (RewardForStructureCopying)params;
        this.rewardDensity = this.rscparams.getRewardDensity();
        this.dimension = this.rscparams.getDimension();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward multidimReward) {
        super.getReward(missionInit, multidimReward);
        if (this.rewardDensity == RewardDensityForBuildAndBreak.MISSION_END) {
            if (multidimReward.isFinalReward() && this.reward != 0.0f) {
                float adjusted_reward = this.adjustAndDistributeReward(this.reward, this.dimension, this.rscparams.getRewardDistribution());
                multidimReward.add(this.dimension, adjusted_reward);
            }
        } else if (this.reward != 0.0f) {
            RewardForStructureCopyingImplementation rewardForStructureCopyingImplementation = this;
            synchronized (rewardForStructureCopyingImplementation) {
                float adjusted_reward = this.adjustAndDistributeReward(this.reward, this.dimension, this.rscparams.getRewardDistribution());
                multidimReward.add(this.dimension, adjusted_reward);
                this.reward = 0.0f;
            }
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_BUILDBATTLEREWARD);
        if (this.rscparams.getAddQuitProducer() != null) {
            MissionBehaviour mb = this.parentBehaviour();
            final String quitDescription = this.rscparams.getAddQuitProducer().getDescription();
            mb.addQuitProducer(new IWantToQuit(){

                @Override
                public void prepare(MissionInit missionInit) {
                }

                @Override
                public String getOutcome() {
                    return quitDescription;
                }

                @Override
                public boolean doIWantToQuit(MissionInit missionInit) {
                    return RewardForStructureCopyingImplementation.this.structureHasBeenCompleted;
                }

                @Override
                public void cleanup() {
                }
            });
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.structureHasBeenCompleted = false;
        MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_MISSIONOVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
        if (messageType == MalmoMod.MalmoMessageType.SERVER_BUILDBATTLEREWARD && data != null) {
            String strCompleted = data.get("completed");
            String strReward = data.get("reward");
            Boolean completed = strCompleted != null ? Boolean.valueOf(strCompleted) : Boolean.FALSE;
            Integer reward = strReward != null ? Integer.valueOf(strReward) : 0;
            RewardForStructureCopyingImplementation rewardForStructureCopyingImplementation = this;
            synchronized (rewardForStructureCopyingImplementation) {
                if (completed == Boolean.TRUE) {
                    this.structureHasBeenCompleted = true;
                    this.reward += this.rscparams.getRewardForCompletion().floatValue();
                }
                if (reward != null) {
                    this.reward += (float)reward.intValue() * this.rscparams.getRewardScale().floatValue();
                }
            }
        }
    }
}

