/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.DiscreteMovementCommandsImplementation;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.Behaviour;
import com.microsoft.Malmo.Schemas.BlockSpecWithRewardAndBehaviour;
import com.microsoft.Malmo.Schemas.BlockType;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.RewardForTouchingBlockType;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import com.microsoft.Malmo.Utils.PositionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RewardForTouchingBlockTypeImplementation
extends RewardBase
implements IRewardProducer {
    ArrayList<BlockMatcher> matchers = new ArrayList();
    private RewardForTouchingBlockType params;

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof RewardForTouchingBlockType)) {
            return false;
        }
        this.params = (RewardForTouchingBlockType)params;
        for (BlockSpecWithRewardAndBehaviour spec : this.params.getBlock()) {
            this.matchers.add(new BlockMatcher(spec));
        }
        return true;
    }

    @SubscribeEvent
    public void onDiscretePartialMoveEvent(DiscreteMovementCommandsImplementation.DiscretePartialMoveEvent event) {
        MultidimensionalReward reward = new MultidimensionalReward();
        this.calculateReward(reward);
        this.addCachedReward(reward);
    }

    private void calculateReward(MultidimensionalReward reward) {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        List<BlockPos> touchingBlocks = PositionHelper.getTouchingBlocks(player);
        for (BlockPos pos : touchingBlocks) {
            IBlockState iblockstate = player.world.getBlockState(pos);
            for (BlockMatcher bm : this.matchers) {
                if (!bm.applies(pos) || !bm.matches(pos, iblockstate)) continue;
                float reward_value = bm.reward();
                float adjusted_reward = this.adjustAndDistributeReward(reward_value, this.params.getDimension(), bm.spec.getDistribution());
                reward.add(this.params.getDimension(), adjusted_reward);
            }
        }
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
        this.calculateReward(reward);
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    private class BlockMatcher {
        boolean hasFired = false;
        BlockSpecWithRewardAndBehaviour spec;
        ArrayList<String> allowedBlockNames;
        ArrayList<BlockPos> firedBlocks = new ArrayList();
        long lastFired;

        BlockMatcher(BlockSpecWithRewardAndBehaviour spec) {
            this.spec = spec;
            this.allowedBlockNames = new ArrayList();
            List<BlockType> allowedTypes = spec.getType();
            if (allowedTypes != null) {
                for (BlockType bt : allowedTypes) {
                    Block b = Block.getBlockFromName((String)bt.value());
                    this.allowedBlockNames.add(b.getUnlocalizedName());
                }
            }
        }

        boolean applies(BlockPos bp) {
            switch (this.spec.getBehaviour()) {
                case ONCE_ONLY: {
                    return !this.hasFired;
                }
                case ONCE_PER_BLOCK: {
                    return !this.firedBlocks.contains(bp);
                }
                case ONCE_PER_TIME_SPAN: {
                    return this.spec.getCooldownInMs().floatValue() < (float)(System.currentTimeMillis() - this.lastFired);
                }
                case CONSTANT: {
                    return true;
                }
            }
            return true;
        }

        boolean matches(BlockPos bp, IBlockState bs) {
            boolean match = false;
            for (String allowedbs : this.allowedBlockNames) {
                if (!allowedbs.equals(bs.getBlock().getUnlocalizedName())) continue;
                match = true;
            }
            if (match && this.spec.getColour() != null && !this.spec.getColour().isEmpty()) {
                match = MinecraftTypeHelper.blockColourMatches(bs, this.spec.getColour());
            }
            if (match && this.spec.getVariant() != null && !this.spec.getVariant().isEmpty()) {
                match = MinecraftTypeHelper.blockVariantMatches(bs, this.spec.getVariant());
            }
            if (match) {
                this.hasFired = true;
                this.lastFired = System.currentTimeMillis();
                if (this.spec.getBehaviour() == Behaviour.ONCE_PER_BLOCK) {
                    this.firedBlocks.add(bp);
                }
            }
            return match;
        }

        float reward() {
            return this.spec.getReward().floatValue();
        }
    }
}

