/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.ArrayList;
import java.util.HashMap;

public class RewardGroup
extends RewardBase
implements IRewardProducer {
    private ArrayList<IRewardProducer> producers;

    public void addRewardProducer(IRewardProducer producer) {
        if (this.producers == null) {
            this.producers = new ArrayList();
        }
        this.producers.add(producer);
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        if (this.producers != null) {
            for (IRewardProducer rp : this.producers) {
                rp.getReward(missionInit, reward);
            }
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        if (this.producers != null) {
            for (IRewardProducer rp : this.producers) {
                rp.prepare(missionInit);
            }
        }
    }

    @Override
    public void cleanup() {
        if (this.producers != null) {
            for (IRewardProducer rp : this.producers) {
                rp.cleanup();
            }
        }
    }

    @Override
    public void appendExtraServerInformation(HashMap<String, String> map) {
        for (IRewardProducer rp : this.producers) {
            if (!(rp instanceof HandlerBase)) continue;
            ((HandlerBase)((Object)rp)).appendExtraServerInformation(map);
        }
    }

    public boolean isFixed() {
        return false;
    }
}

