/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlers.QuitFromTimeUpBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.ServerQuitFromTimeUp;
import java.util.HashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ServerQuitFromTimeUpImplementation
extends QuitFromTimeUpBase {
    private String quitCode = "";

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof ServerQuitFromTimeUp)) {
            return false;
        }
        ServerQuitFromTimeUp qtuparams = (ServerQuitFromTimeUp)params;
        this.setTimeLimitMs(qtuparams.getTimeLimitMs().intValue());
        this.quitCode = qtuparams.getDescription();
        return true;
    }

    @Override
    protected long getWorldTime() {
        World world = null;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        world = server.getEntityWorld();
        return world != null ? world.getTotalWorldTime() : 0L;
    }

    @Override
    protected void drawCountDown(int secondsRemaining) {
        HashMap<String, String> data = new HashMap<String, String>();
        String text = TextFormatting.BOLD + "" + secondsRemaining + "...";
        if (secondsRemaining <= 5) {
            text = TextFormatting.RED + text;
        }
        data.put("chat", text);
        MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_TEXT, data);
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getOutcome() {
        return this.quitCode;
    }
}

