/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.SimpleCraftCommand;
import com.microsoft.Malmo.Schemas.SimpleCraftCommands;
import com.microsoft.Malmo.Utils.CraftingHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SimpleCraftCommandsImplementation
extends CommandBase {
    private boolean isOverriding;

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (verb.equalsIgnoreCase(SimpleCraftCommand.CRAFT.value())) {
            MalmoMod.network.sendToServer((IMessage)new CraftMessage(parameter));
            return true;
        }
        return false;
    }

    @Override
    public boolean parseParameters(Object params) {
        if (!(params instanceof SimpleCraftCommands)) {
            return false;
        }
        SimpleCraftCommands cparams = (SimpleCraftCommands)params;
        this.setUpAllowAndDenyLists(cparams.getModifierList());
        return true;
    }

    @Override
    public void install(MissionInit missionInit) {
        CraftingHelper.reset();
    }

    @Override
    public void deinstall(MissionInit missionInit) {
    }

    @Override
    public boolean isOverriding() {
        return this.isOverriding;
    }

    @Override
    public void setOverriding(boolean b) {
        this.isOverriding = b;
    }

    public static class CraftMessageHandler
    implements IMessageHandler<CraftMessage, IMessage> {
        public IMessage onMessage(CraftMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().playerEntity;
            String[] split = message.parameters.split(" ");
            List<IRecipe> matching_recipes = CraftingHelper.getRecipesForRequestedOutput(message.parameters, split.length > 1);
            for (IRecipe recipe : matching_recipes) {
                if (!CraftingHelper.attemptCrafting(player, recipe)) continue;
                return null;
            }
            ItemStack input = CraftingHelper.getSmeltingRecipeForRequestedOutput(message.parameters);
            if (input != null && CraftingHelper.attemptSmelting(player, input)) {
                return null;
            }
            return null;
        }
    }

    public static class CraftMessage
    implements IMessage {
        String parameters;

        public CraftMessage() {
        }

        public CraftMessage(String parameters) {
            this.parameters = parameters;
        }

        public void fromBytes(ByteBuf buf) {
            this.parameters = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.parameters);
        }
    }
}

