/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlers.CommandGroup;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.MissionHandlers.ObservationFromTurnSchedulerImplementation;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.TurnBasedCommands;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TurnBasedCommandsImplementation
extends CommandGroup
implements MalmoMod.IMalmoMessageListener {
    private ObservationFromTurnSchedulerImplementation observationProducer;
    private int requestedPosition;
    private Random rng = new Random();
    String agentName;

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params instanceof TurnBasedCommands) {
            TurnBasedCommands tbcparams = (TurnBasedCommands)params;
            this.requestedPosition = tbcparams.getRequestedPosition().intValue();
            this.observationProducer = new ObservationFromTurnSchedulerImplementation();
            List<Object> handlers = tbcparams.getTurnBasedApplicableCommandHandlers();
            if (!handlers.isEmpty()) {
                MissionBehaviour subHandlers = new MissionBehaviour();
                subHandlers.addExtraHandlers(handlers);
                if (subHandlers.commandHandler != null) {
                    if (subHandlers.commandHandler instanceof HandlerBase) {
                        ((HandlerBase)((Object)subHandlers.commandHandler)).setParentBehaviour(this.parentBehaviour());
                    }
                    this.addCommandHandler(subHandlers.commandHandler);
                }
            }
        }
        return true;
    }

    @Override
    public void install(MissionInit missionInit) {
        super.install(missionInit);
        this.parentBehaviour().addObservationProducer(this.observationProducer);
        this.agentName = missionInit.getMission().getAgentSection().get(missionInit.getClientRole()).getName();
        MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_YOUR_TURN);
    }

    @Override
    public void deinstall(MissionInit missionInit) {
        super.deinstall(missionInit);
        MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_YOUR_TURN);
    }

    @Override
    public boolean isOverriding() {
        return super.isOverriding();
    }

    @Override
    public void setOverriding(boolean b) {
        super.setOverriding(b);
    }

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (!this.observationProducer.matchesKey(verb)) {
            return false;
        }
        boolean processed = super.onExecute(parameter, "", missionInit);
        if (processed) {
            this.observationProducer.turnUsed();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("agentname", this.agentName);
            MalmoMod.network.sendToServer((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.CLIENT_TURN_TAKEN, 0, data));
        }
        return processed;
    }

    @Override
    public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
        if (messageType == MalmoMod.MalmoMessageType.SERVER_YOUR_TURN) {
            String newkey = this.generateKey();
            this.observationProducer.setKeyAndIncrement(newkey);
        }
    }

    public String generateKey() {
        String letters = "abcdefghijklmnopqrstuvwxyz";
        String key = "";
        for (int i = 0; i < 5; ++i) {
            int pos = this.rng.nextInt(26);
            key = key + letters.subSequence(pos, pos + 1);
        }
        return key;
    }

    @Override
    public void appendExtraServerInformation(HashMap<String, String> map) {
        super.appendExtraServerInformation(map);
        map.put("turnPosition", String.valueOf(this.requestedPosition));
    }
}

