/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class OverclockingClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean isObfuscated;
        if (transformedName.startsWith("net.minecraft.client.entity")) {
            System.out.println("Transformed Name: " + transformedName);
        }
        boolean bl = isObfuscated = !name.equals(transformedName);
        if (transformedName.equals("net.minecraft.client.Minecraft")) {
            return OverclockingClassTransformer.transform(basicClass, isObfuscated, transformType.RENDERER);
        }
        if (transformedName.equals("net.minecraft.client.entity.EntityOtherPlayerMP")) {
            return OverclockingClassTransformer.transform(basicClass, isObfuscated, transformType.OTHERPLAYER);
        }
        if (transformedName.equals("net.minecraft.client.renderer.GlStateManager")) {
            return OverclockingClassTransformer.transform(basicClass, isObfuscated, transformType.TEXTURES);
        }
        return basicClass;
    }

    private static byte[] transform(byte[] serverClass, boolean isObfuscated, transformType type) {
        System.out.println("MALMO: Attempting to transform MinecraftServer");
        try {
            ClassNode cnode = new ClassNode();
            ClassReader creader = new ClassReader(serverClass);
            creader.accept((ClassVisitor)cnode, 0);
            switch (type) {
                case RENDERER: {
                    OverclockingClassTransformer.overclockRenderer(cnode, isObfuscated);
                    break;
                }
                case OTHERPLAYER: {
                    OverclockingClassTransformer.removeInterpolation(cnode, isObfuscated);
                    break;
                }
                case TEXTURES: {
                    OverclockingClassTransformer.insertTextureHandler(cnode, isObfuscated);
                }
            }
            ClassWriter cwriter = new ClassWriter(3);
            cnode.accept((ClassVisitor)cwriter);
            return cwriter.toByteArray();
        }
        catch (Exception e) {
            System.out.println("MALMO FAILED to transform MinecraftServer - overclocking not available!");
            return serverClass;
        }
    }

    private static void removeInterpolation(ClassNode node, boolean isObfuscated) {
        String methodName = "func_180426_a";
        String methodDescriptor = "(DDDFFIZ)V";
        System.out.println("MALMO: Found EntityOtherPlayerMP, attempting to transform it");
        for (MethodNode method : node.methods) {
            if (!method.name.equals("func_180426_a") || !method.desc.equals("(DDDFFIZ)V")) continue;
            System.out.println("MALMO: Found EntityOtherPlayerMP.func_180426_a() method, attempting to transform it");
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 21) continue;
                LdcInsnNode newNode = new LdcInsnNode((Object)new Integer(1));
                method.instructions.insert(instruction, (AbstractInsnNode)newNode);
                method.instructions.remove(instruction);
                return;
            }
        }
    }

    private static void overclockRenderer(ClassNode node, boolean isObfuscated) {
        String methodName = isObfuscated ? "as" : "runGameLoop";
        String methodDescriptor = "()V";
        System.out.println("MALMO: Found Minecraft, attempting to transform it");
        for (MethodNode method : node.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals("()V")) continue;
            System.out.println("MALMO: Found Minecraft.runGameLoop() method, attempting to transform it");
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 182) continue;
                MethodInsnNode visitMethodNode = (MethodInsnNode)instruction;
                if (!visitMethodNode.name.equals(isObfuscated ? "h" : "updateDisplay")) continue;
                visitMethodNode.owner = "com/microsoft/Malmo/Utils/TimeHelper";
                if (isObfuscated) {
                    visitMethodNode.name = "updateDisplay";
                }
                visitMethodNode.setOpcode(184);
                method.instructions.remove(visitMethodNode.getPrevious());
                System.out.println("MALMO: Hooked into call to Minecraft.updateDisplay()");
            }
        }
    }

    private static void insertTextureHandler(ClassNode node, boolean isObfuscated) {
        String methodName = isObfuscated ? "func_179144_i" : "bindTexture";
        String methodDescriptor = "(I)V";
        System.out.println("MALMO: Found GlStateManager, attempting to transform it");
        for (MethodNode method : node.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals("(I)V")) continue;
            System.out.println("MALMO: Found GlStateManager.bindTexture() method, attempting to transform it");
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 184) continue;
                MethodInsnNode visitMethodNode = (MethodInsnNode)instruction;
                if (!visitMethodNode.name.equals("glBindTexture")) continue;
                visitMethodNode.owner = "com/microsoft/Malmo/Utils/TextureHelper";
                if (isObfuscated) {
                    visitMethodNode.name = "bindTexture";
                }
                System.out.println("MALMO: Hooked into call to GlStateManager.bindTexture()");
            }
        }
    }

    static enum transformType {
        SERVER,
        RENDERER,
        OTHERPLAYER,
        TEXTURES;

    }
}

