/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo;

import com.microsoft.Malmo.IState;
import com.microsoft.Malmo.StateMachine;
import com.microsoft.Malmo.Utils.TimeHelper;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class StateEpisode {
    private boolean isLive = false;
    protected StateMachine machine = null;

    protected StateEpisode(StateMachine machine) {
        this.machine = machine;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void start() {
        this.isLive = true;
        try {
            this.execute();
        }
        catch (Exception e) {
            System.out.println("State start - exception: " + e);
            e.printStackTrace();
        }
    }

    public void cleanup() {
    }

    protected void episodeHasCompleted(IState nextState) {
        this.isLive = false;
        this.machine.queueStateChange(nextState);
    }

    protected void episodeHasCompletedWithErrors(IState nextState, String error) {
        this.machine.saveErrorDetails(error);
        this.episodeHasCompleted(nextState);
    }

    protected abstract void execute() throws Exception;

    protected void onClientTick(TickEvent.ClientTickEvent ev) throws Exception {
    }

    protected void onServerTick(TickEvent.ServerTickEvent ev) {
    }

    protected void onPlayerTick(TickEvent.PlayerTickEvent ev) {
    }

    protected void onRenderTick(TickEvent.RenderTickEvent ev) {
    }

    protected void onChunkLoad(ChunkEvent.Load cev) {
    }

    protected void onPlayerDies(LivingDeathEvent event) {
    }

    protected void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
    }

    protected void onPlayerJoinedServer(PlayerEvent.PlayerLoggedInEvent event) {
    }

    protected void onSyncTick(TimeHelper.SyncTickEvent ev) {
    }
}

