/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo;

import com.microsoft.Malmo.EpisodeEventWrapper;
import com.microsoft.Malmo.IState;
import com.microsoft.Malmo.StateEpisode;
import com.microsoft.Malmo.Utils.TCPUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minecraftforge.common.MinecraftForge;

public abstract class StateMachine {
    private IState state;
    private EpisodeEventWrapper eventWrapper = null;
    private String errorDetails = "";
    private Thread homeThread;
    private ArrayList<IState> stateQueue = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearErrorDetails() {
        String string = this.errorDetails;
        synchronized (string) {
            this.errorDetails = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveErrorDetails(String error) {
        String string = this.errorDetails;
        synchronized (string) {
            this.errorDetails = this.errorDetails + error + "\n";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorDetails() {
        String ret = "";
        String string = this.errorDetails;
        synchronized (string) {
            ret = this.errorDetails;
        }
        return ret;
    }

    public StateMachine(IState initialState) {
        this.eventWrapper = new EpisodeEventWrapper();
        this.setState(initialState);
        this.homeThread = Thread.currentThread();
        MinecraftForge.EVENT_BUS.register((Object)this.eventWrapper);
    }

    private void setState(IState toState) {
        if (Thread.currentThread() == this.homeThread) {
            if (this.state != toState) {
                System.out.println(this.getName() + " enter state: " + toState);
                TCPUtils.Log(Level.INFO, "======== " + this.getName() + " enter state: " + toState + " ========");
                this.state = toState;
                this.onPreStateChange(toState);
                this.onStateChange();
            }
        } else {
            this.queueStateChange(toState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IState getStableState() {
        ArrayList<IState> arrayList = this.stateQueue;
        synchronized (arrayList) {
            if (this.stateQueue.size() == 0) {
                return this.state;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueStateChange(IState state) {
        ArrayList<IState> arrayList = this.stateQueue;
        synchronized (arrayList) {
            if (this.stateQueue.size() != 0) {
                System.out.println("STATE ERROR - multiple states in the queue.");
            }
            this.stateQueue.add(state);
            System.out.println(this.getName() + " request state: " + state);
            TCPUtils.Log(Level.INFO, "-------- " + this.getName() + " request state: " + state + " --------");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState() {
        if (Thread.currentThread() == this.homeThread) {
            IState state = null;
            ArrayList<IState> arrayList = this.stateQueue;
            synchronized (arrayList) {
                if (this.stateQueue.size() > 0) {
                    state = this.stateQueue.remove(0);
                }
            }
            if (state != null) {
                this.setState(state);
            }
        }
    }

    protected abstract String getName();

    protected abstract void onPreStateChange(IState var1);

    private void onStateChange() {
        StateEpisode stateEpisode = this.getStateEpisodeForState(this.state);
        StateEpisode lastEpisode = this.eventWrapper.setStateEpisode(stateEpisode);
        if (lastEpisode != null) {
            lastEpisode.cleanup();
        }
        if (stateEpisode != null) {
            stateEpisode.start();
        }
    }

    protected abstract StateEpisode getStateEpisodeForState(IState var1);
}

