/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import java.util.Random;

public class Discrete {
    private Random rand;
    private double[] likelihoods;
    private double sum;

    public Discrete(Random rand, int[] counts) {
        this.likelihoods = new double[counts.length];
        this.rand = rand;
        this.sum = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            this.sum += (double)counts[i];
            this.likelihoods[i] = counts[i];
        }
        if (this.sum == 0.0) {
            this.likelihoods[0] = 1.0;
            this.sum = 1.0;
        }
    }

    public Discrete(Random rand, int count, double complexity) {
        double weight = (1.0 - complexity) / (double)count + complexity;
        this.rand = rand;
        this.likelihoods = new double[count];
        this.sum = weight;
        double part = 1.0 / (double)count;
        for (int i = 0; i < count; ++i) {
            double likelihood;
            this.likelihoods[i] = likelihood = Math.min(part, weight);
            weight -= likelihood;
        }
    }

    public int sample() {
        double val = this.rand.nextDouble() * this.sum;
        for (int sample = 0; sample < this.likelihoods.length; ++sample) {
            if (!((val -= this.likelihoods[sample]) < 0.0)) continue;
            return sample;
        }
        return this.rand.nextInt(this.likelihoods.length);
    }

    public int take() {
        int result = this.sample();
        if (this.likelihoods[result] >= 1.0) {
            int n = result;
            this.likelihoods[n] = this.likelihoods[n] - 1.0;
            this.sum -= 1.0;
        }
        return result;
    }
}

