/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.microsoft.Malmo.Schemas.BlockType;
import com.microsoft.Malmo.Schemas.Colour;
import com.microsoft.Malmo.Schemas.DrawBlock;
import com.microsoft.Malmo.Schemas.DrawItem;
import com.microsoft.Malmo.Schemas.EntityTypes;
import com.microsoft.Malmo.Schemas.Facing;
import com.microsoft.Malmo.Schemas.FlowerTypes;
import com.microsoft.Malmo.Schemas.HalfTypes;
import com.microsoft.Malmo.Schemas.MonsterEggTypes;
import com.microsoft.Malmo.Schemas.ShapeTypes;
import com.microsoft.Malmo.Schemas.StoneTypes;
import com.microsoft.Malmo.Schemas.Variation;
import com.microsoft.Malmo.Schemas.WoodTypes;
import com.microsoft.Malmo.Utils.BlockDrawingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class MinecraftTypeHelper {
    public static IBlockState ParseBlockType(String s) {
        if (s == null) {
            return null;
        }
        Block block = (Block)Block.REGISTRY.getObject((Object)new ResourceLocation(s));
        if (block instanceof BlockAir && !s.equals("air")) {
            return null;
        }
        return block.getDefaultState();
    }

    public static Item ParseItemType(String s, boolean checkBlocks) {
        if (s == null) {
            return null;
        }
        Item item = (Item)Item.REGISTRY.getObject((Object)new ResourceLocation(s));
        if (item == null && checkBlocks) {
            IBlockState block = MinecraftTypeHelper.ParseBlockType(s);
            item = block != null && block.getBlock() != null ? Item.getItemFromBlock((Block)block.getBlock()) : null;
        }
        return item;
    }

    public static boolean blockColourMatches(IBlockState bs, List<Colour> allowedColours) {
        for (IProperty prop : bs.getProperties().keySet()) {
            if (!prop.getName().equals("color") || prop.getValueClass() != EnumDyeColor.class) continue;
            EnumDyeColor current = (EnumDyeColor)bs.getValue(prop);
            for (Colour col : allowedColours) {
                if (!current.getName().equalsIgnoreCase(col.name())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean blockVariantMatches(IBlockState bs, List<Variation> allowedVariants) {
        for (IProperty prop : bs.getProperties().keySet()) {
            Comparable current;
            if (!prop.getName().equals("variant") || !prop.getValueClass().isEnum() || (current = bs.getValue(prop)) == null) continue;
            for (Variation var : allowedVariants) {
                if (!var.getValue().equalsIgnoreCase(current.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static Colour attemptToGetAsColour(String part) {
        String target = part.toUpperCase();
        for (int i = 0; i < Colour.values().length; ++i) {
            String col = Colour.values()[i].name().replace("_", "");
            if (!col.equals(target)) continue;
            return Colour.values()[i];
        }
        return null;
    }

    public static Facing attemptToGetAsFacing(String part) {
        Facing face = null;
        try {
            face = Facing.valueOf(part);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return face;
    }

    public static Variation attemptToGetAsVariant(String part, ItemStack is) {
        if (is.getItem() instanceof ItemBlock) {
            ItemBlock ib = (ItemBlock)is.getItem();
            IBlockState bs = ib.block.getStateFromMeta(is.getMetadata());
            for (IProperty prop : bs.getProperties().keySet()) {
                Comparable comp = bs.getValue(prop);
                Variation var = MinecraftTypeHelper.attemptToGetAsVariant(comp.toString());
                if (var == null) continue;
                return var;
            }
            return null;
        }
        return MinecraftTypeHelper.attemptToGetAsVariant(part);
    }

    public static Variation attemptToGetAsVariant(String part) {
        Enum var2;
        try {
            var2 = StoneTypes.valueOf(part.toUpperCase());
            if (var2 != null) {
                Variation bv = new Variation();
                bv.setValue(((StoneTypes)var2).value());
                return bv;
            }
        }
        catch (Exception var2) {
            // empty catch block
        }
        try {
            var2 = WoodTypes.valueOf(part.toUpperCase());
            if (var2 != null) {
                Variation bv = new Variation();
                bv.setValue(((WoodTypes)var2).value());
                return bv;
            }
        }
        catch (Exception var3) {
            // empty catch block
        }
        try {
            var2 = FlowerTypes.fromValue(part);
            if (var2 != null) {
                Variation bv = new Variation();
                bv.setValue(((FlowerTypes)var2).value());
                return bv;
            }
        }
        catch (Exception var4) {
            // empty catch block
        }
        try {
            var2 = EntityTypes.fromValue(part);
            if (var2 != null) {
                Variation bv = new Variation();
                bv.setValue(((EntityTypes)var2).value());
                return bv;
            }
        }
        catch (Exception var5) {
            // empty catch block
        }
        try {
            var2 = MonsterEggTypes.fromValue(part);
            if (var2 != null) {
                Variation bv = new Variation();
                bv.setValue(((MonsterEggTypes)var2).value());
                return bv;
            }
        }
        catch (Exception var6) {
            // empty catch block
        }
        try {
            var2 = ShapeTypes.fromValue(part);
            if (var2 != null) {
                Variation bv = new Variation();
                bv.setValue(((ShapeTypes)var2).value());
                return bv;
            }
        }
        catch (Exception var7) {
            // empty catch block
        }
        try {
            var2 = HalfTypes.fromValue(part);
            if (var2 != null) {
                Variation bv = new Variation();
                bv.setValue(((HalfTypes)var2).value());
                return bv;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static DrawBlock getDrawBlockFromBlockState(IBlockState state, List<IProperty> extraProperties) {
        if (state == null) {
            return null;
        }
        DrawBlock block = new DrawBlock();
        Object blockName = Block.REGISTRY.getNameForObject((Object)state.getBlock());
        if (blockName instanceof ResourceLocation) {
            String name = ((ResourceLocation)blockName).getResourcePath();
            BlockType type = BlockType.fromValue(name);
            block.setType(type);
        }
        Colour col = null;
        Variation var = null;
        Facing face = null;
        for (IProperty prop : state.getProperties().keySet()) {
            String propVal = state.getValue(prop).toString();
            boolean matched = false;
            if (col == null && (col = MinecraftTypeHelper.attemptToGetAsColour(propVal)) != null) {
                matched = true;
            }
            if (!matched && var == null && (var = MinecraftTypeHelper.attemptToGetAsVariant(propVal)) != null) {
                matched = true;
            }
            if (!matched && face == null && (face = MinecraftTypeHelper.attemptToGetAsFacing(propVal)) != null) {
                matched = true;
            }
            if (matched || extraProperties == null) continue;
            extraProperties.add(prop);
        }
        if (col != null) {
            block.setColour(col);
        }
        if (var != null) {
            block.setVariant(var);
        }
        if (face != null) {
            block.setFace(face);
        }
        return block;
    }

    public static DrawItem getDrawItemFromItemStack(ItemStack is) {
        Object obj;
        if (is == null) {
            return null;
        }
        DrawItem di = new DrawItem();
        String name = is.getUnlocalizedName();
        if (is.getHasSubtypes()) {
            ArrayList<String> itemParts = new ArrayList<String>(Arrays.asList(name.split("\\.")));
            if (is.getItem() instanceof ItemMonsterPlacer) {
                itemParts.add(ItemMonsterPlacer.getNamedIdFrom((ItemStack)is).toString());
            }
            Colour col = null;
            Variation var = null;
            for (int part = 2; part < itemParts.size(); ++part) {
                String section = (String)itemParts.get(part);
                if (col == null) {
                    col = MinecraftTypeHelper.attemptToGetAsColour(section);
                    if (col != null || var != null) continue;
                    var = MinecraftTypeHelper.attemptToGetAsVariant(section, is);
                    continue;
                }
                if (var != null) continue;
                var = MinecraftTypeHelper.attemptToGetAsVariant(section, is);
            }
            di.setColour(col);
            di.setVariant(var);
        }
        String publicName = (obj = Item.REGISTRY.getNameForObject((Object)is.getItem())) instanceof ResourceLocation ? ((ResourceLocation)obj).getResourcePath() : obj.toString();
        di.setType(publicName);
        return di;
    }

    public static ItemStack getItemStackFromParameterString(String parameters) {
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(parameters.split(" ")));
        Colour col = null;
        Variation var = null;
        Iterator it = params.iterator();
        while (it.hasNext() && col == null) {
            col = MinecraftTypeHelper.attemptToGetAsColour((String)it.next());
            if (col == null) continue;
            it.remove();
        }
        it = params.iterator();
        while (it.hasNext() && var == null) {
            var = MinecraftTypeHelper.attemptToGetAsVariant((String)it.next());
            if (var == null) continue;
            it.remove();
        }
        if (params.size() == 0) {
            return null;
        }
        String itemName = (String)params.get(0);
        DrawItem di = new DrawItem();
        di.setColour(col);
        di.setVariant(var);
        di.setType(itemName);
        return MinecraftTypeHelper.getItemStackFromDrawItem(di);
    }

    public static ItemStack getItemStackFromDrawItem(DrawItem i) {
        ItemStack itemStack = null;
        Item item = MinecraftTypeHelper.ParseItemType(i.getType(), false);
        if (item == null) {
            IBlockState block = MinecraftTypeHelper.ParseBlockType(i.getType());
            if (block != null && (block = BlockDrawingHelper.applyModifications(block, i.getColour(), i.getFace(), i.getVariant())) != null && block.getBlock() != null && Item.getItemFromBlock((Block)block.getBlock()) != null) {
                itemStack = new ItemStack(block.getBlock(), 1, block.getBlock().getMetaFromState(block));
            }
        } else {
            if (item.getHasSubtypes() && (i.getColour() != null || i.getVariant() != null)) {
                NonNullList subItems = NonNullList.create();
                item.getSubItems(item, null, subItems);
                for (ItemStack is : subItems) {
                    String fullName = is.getUnlocalizedName();
                    if (is.getItem() instanceof ItemMonsterPlacer) {
                        fullName = fullName + "." + ItemMonsterPlacer.getNamedIdFrom((ItemStack)is).toString();
                    }
                    String[] parts = fullName.split("\\.");
                    for (int p = 0; p < parts.length; ++p) {
                        Variation v = MinecraftTypeHelper.attemptToGetAsVariant(parts[p], is);
                        Colour c = MinecraftTypeHelper.attemptToGetAsColour(parts[p]);
                        if ((v == null || i.getVariant() == null || !v.getValue().equals(i.getVariant().getValue())) && (c == null || i.getColour() == null || c != i.getColour())) continue;
                        return is;
                    }
                }
            }
            itemStack = new ItemStack(item);
        }
        return itemStack;
    }

    static IBlockState applyVariant(IBlockState state, Variation variant) {
        boolean relaxRequirements = false;
        for (int i = 0; i < 2; ++i) {
            for (IProperty prop : state.getProperties().keySet()) {
                T[] values;
                if (!prop.getName().equals("variant") && !relaxRequirements || !prop.getValueClass().isEnum()) continue;
                for (Object obj : values = prop.getValueClass().getEnumConstants()) {
                    if (obj == null || !obj.toString().equalsIgnoreCase(variant.getValue())) continue;
                    return state.withProperty(prop, (Comparable)obj);
                }
            }
            relaxRequirements = true;
        }
        return state;
    }

    static IBlockState applyColour(IBlockState state, Colour colour) {
        for (IProperty prop : state.getProperties().keySet()) {
            EnumDyeColor current;
            if (!prop.getName().equals("color") || prop.getValueClass() != EnumDyeColor.class || (current = (EnumDyeColor)state.getValue(prop)).getName().equalsIgnoreCase(colour.name())) continue;
            return state.withProperty(prop, (Comparable)EnumDyeColor.valueOf((String)colour.name()));
        }
        return state;
    }

    static IBlockState applyFacing(IBlockState state, Facing facing) {
        for (IProperty prop : state.getProperties().keySet()) {
            EnumFacing current;
            if (!prop.getName().equals("facing")) continue;
            if (prop.getValueClass() == EnumFacing.class) {
                current = (EnumFacing)state.getValue(prop);
                if (current.getName().equalsIgnoreCase(facing.name())) continue;
                return state.withProperty(prop, (Comparable)EnumFacing.valueOf((String)facing.name()));
            }
            if (prop.getValueClass() != BlockLever.EnumOrientation.class || (current = (BlockLever.EnumOrientation)state.getValue(prop)).getName().equalsIgnoreCase(facing.name())) continue;
            return state.withProperty(prop, (Comparable)BlockLever.EnumOrientation.valueOf((String)facing.name()));
        }
        return state;
    }

    public static String getUnlocalisedEntityName(Entity e) {
        String name;
        if (e.hasCustomName()) {
            name = e.getCustomNameTag();
        } else if (e instanceof EntityPlayer) {
            name = e.getName();
        } else {
            name = EntityList.getEntityString((Entity)e);
            if (name == null) {
                name = "unknown";
            }
        }
        return name;
    }
}

