/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.microsoft.Malmo.MalmoMod;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaHelper {
    private static HashMap<String, JAXBContext> jaxbContentCache = new HashMap();

    private static JAXBContext getJAXBContext(Class<?> objclass) throws JAXBException {
        JAXBContext jaxbContext;
        if (jaxbContentCache.containsKey(objclass.getName())) {
            jaxbContext = jaxbContentCache.get(objclass.getName());
        } else {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{objclass});
            jaxbContentCache.put(objclass.getName(), jaxbContext);
        }
        return jaxbContext;
    }

    public static String serialiseObject(Object obj, Class<?> objclass) throws JAXBException {
        JAXBContext jaxbContext = SchemaHelper.getJAXBContext(objclass);
        Marshaller m = jaxbContext.createMarshaller();
        StringWriter w = new StringWriter();
        m.marshal(obj, (Writer)w);
        String xmlString = w.toString();
        return xmlString;
    }

    public static Object deserialiseObject(String xml, String xsdFile, Class<?> objclass) throws JAXBException, SAXException, XMLStreamException {
        Object obj = null;
        JAXBContext jaxbContext = SchemaHelper.getJAXBContext(objclass);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String schemaResourceFilename = new String(xsdFile);
        URL schemaURL = MalmoMod.class.getClassLoader().getResource(schemaResourceFilename);
        Schema schema = schemaFactory.newSchema(schemaURL);
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        jaxbUnmarshaller.setSchema(schema);
        StringReader stringReader = new StringReader(xml);
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader XMLreader = xif.createXMLStreamReader(stringReader);
        obj = jaxbUnmarshaller.unmarshal(XMLreader);
        return obj;
    }

    public static String getRootNodeName(String xml) {
        String rootNodeName = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setExpandEntityReferences(false);
            DocumentBuilder dBuilder = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(xml));
            Document doc = dBuilder.parse(inputSource);
            doc.getDocumentElement().normalize();
            rootNodeName = doc.getDocumentElement().getNodeName();
        }
        catch (SAXException e) {
            System.out.println("SAX exception: " + e);
        }
        catch (IOException e) {
            System.out.println("IO exception: " + e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfiguration exception: " + e);
        }
        return rootNodeName;
    }

    public static boolean testSchemaVersionNumbers(String modVersion) {
        String[] parts = modVersion.split("\\.");
        if (parts.length != 3) {
            System.out.println("Malformed mod version number: " + modVersion + " - should be of form x.y.z. Has CMake been run?");
            return false;
        }
        String requiredVersion = parts[0] + "." + parts[1];
        System.out.println("Testing schemas against internal version number: " + requiredVersion);
        InputStream stream = MalmoMod.class.getClassLoader().getResourceAsStream("schemas.index");
        if (stream == null) {
            System.out.println("Cannot find index of schema files in resources - try rebuilding.");
            return false;
        }
        Scanner scanner = new Scanner(stream);
        while (scanner.hasNextLine()) {
            String xsdFile = scanner.nextLine();
            String version = SchemaHelper.getVersionNumber(xsdFile);
            if (version != null && version.equals(requiredVersion)) continue;
            scanner.close();
            System.out.println("Version error: schema file " + xsdFile + " has the wrong version number - should be " + requiredVersion + ", actually " + version);
            return false;
        }
        scanner.close();
        return true;
    }

    private static String getVersionNumber(String url) {
        InputStream stream = MalmoMod.class.getClassLoader().getResourceAsStream(url);
        Scanner scanner = new Scanner(stream, "UTF-8");
        scanner.useDelimiter("\\A");
        String xml = scanner.next();
        scanner.close();
        try {
            Node node;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setExpandEntityReferences(false);
            DocumentBuilder dBuilder = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(xml));
            Document doc = dBuilder.parse(inputSource);
            doc.getDocumentElement().normalize();
            NamedNodeMap atts = doc.getDocumentElement().getAttributes();
            if (atts != null && (node = atts.getNamedItem("version")) != null) {
                return node.getNodeValue();
            }
        }
        catch (SAXException e) {
            System.out.println("SAX exception: " + e);
        }
        catch (IOException e) {
            System.out.println("IO exception: " + e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfiguration exception: " + e);
        }
        return null;
    }

    public static String getNodeValue(List<Element> elements, String nodeName, String defaultValue) {
        if (elements != null) {
            for (Element el : elements) {
                if (!el.getNodeName().equals(nodeName) || el.getFirstChild() == null) continue;
                return el.getFirstChild().getTextContent();
            }
        }
        return defaultValue;
    }
}

