/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.microsoft.Malmo.Utils.TCPUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.logging.Level;

public class TCPInputPoller
extends Thread {
    private boolean keepRunning = true;
    private ArrayList<CommandAndIPAddress> commandQueue;
    private int requestedPortNumber;
    private int portRangeMin = -1;
    private int portRangeMax = -1;
    private boolean choosePortRandomly = false;
    private ServerSocket serverSocket;
    private boolean failedToCreate = false;
    private String logname;
    private int connection_count = 0;
    private boolean singleRequestReply = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(String s) {
        TCPInputPoller tCPInputPoller = this;
        synchronized (tCPInputPoller) {
            this.commandQueue.add(new CommandAndIPAddress(s, ""));
        }
    }

    private void Log(Level level, String message) {
        TCPUtils.Log(level, "->" + this.logname + "(" + this.requestedPortNumber + ") " + message);
    }

    private void SysLog(Level level, String message) {
        TCPUtils.SysLog(level, "->" + this.logname + "(" + this.requestedPortNumber + ") " + message);
    }

    public TCPInputPoller(int port, String logname) {
        this.requestedPortNumber = port;
        this.commandQueue = new ArrayList();
        this.logname = logname;
    }

    public TCPInputPoller(int portmin, int portmax, boolean choosePortRandomly, String logname) {
        this.requestedPortNumber = 0;
        this.portRangeMax = portmax;
        this.portRangeMin = portmin;
        this.choosePortRandomly = choosePortRandomly;
        this.commandQueue = new ArrayList();
        this.logname = logname;
    }

    public TCPInputPoller(int requestedPort, int portmin, int portmax, String logname) {
        this.requestedPortNumber = requestedPort;
        this.portRangeMax = Math.max(portmin, portmax);
        this.portRangeMin = Math.min(portmin, portmax);
        this.commandQueue = new ArrayList();
        this.logname = logname;
    }

    public TCPInputPoller(int requestedPort, int portmin, int portmax, boolean singleRequestReply, String logname) {
        this(requestedPort, portmin, portmax, logname);
        this.singleRequestReply = singleRequestReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommand() {
        String command = "";
        TCPInputPoller tCPInputPoller = this;
        synchronized (tCPInputPoller) {
            if (this.commandQueue.size() > 0) {
                command = this.commandQueue.remove((int)0).command;
            }
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCommands() {
        TCPInputPoller tCPInputPoller = this;
        synchronized (tCPInputPoller) {
            System.out.println("JETTISONING " + this.commandQueue.size() + " COMMANDS");
            this.commandQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandAndIPAddress getCommandAndIPAddress() {
        CommandAndIPAddress command = null;
        TCPInputPoller tCPInputPoller = this;
        synchronized (tCPInputPoller) {
            if (this.commandQueue.size() > 0) {
                command = this.commandQueue.remove(0);
            }
        }
        return command;
    }

    public void stopServer() {
        this.Log(Level.INFO, "Attempting to stop SocketServer");
        this.keepRunning = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                this.Log(Level.WARNING, "Something happened when closing SocketServer: " + e);
            }
            this.serverSocket = null;
        }
    }

    @Override
    public void run() {
        this.serverSocket = null;
        try {
            this.Log(Level.INFO, "Attempting to create SocketServer...");
            if (this.requestedPortNumber == 0 && this.portRangeMax != -1 && this.portRangeMin != -1) {
                this.serverSocket = TCPUtils.getSocketInRange(this.portRangeMin, this.portRangeMax, this.choosePortRandomly);
                if (this.serverSocket == null) {
                    throw new Exception("Could not allocate port from range.");
                }
            } else {
                this.serverSocket = new ServerSocket(this.requestedPortNumber);
            }
        }
        catch (Exception e) {
            this.SysLog(Level.SEVERE, "Failed to create SocketServer: " + e);
            this.failedToCreate = true;
            return;
        }
        this.SysLog(Level.INFO, "Listening for messages on port " + this.serverSocket.getLocalPort());
        while (this.keepRunning) {
            Socket socket = null;
            try {
                this.Log(Level.INFO, "Waiting for incoming message...");
                socket = this.serverSocket.accept();
                if (socket != null) {
                    this.Log(Level.INFO, "Connected to: " + socket.getLocalAddress() + "(local), " + socket.getRemoteSocketAddress() + "(remote)");
                } else {
                    this.Log(Level.WARNING, "Accept() returns a null socket!?");
                }
            }
            catch (SocketException e) {
                this.SysLog(Level.INFO, "Socket exception - usually caused by ServerSocket being closed under our feet (normal for stopping polling): " + e);
            }
            catch (IOException e) {
                this.SysLog(Level.SEVERE, "Failed to accept socket request: " + e);
            }
            if (socket == null) continue;
            ++this.connection_count;
            TCPConnectionHandler connectionHandler = new TCPConnectionHandler(socket, this, this.logname + ":S#" + this.connection_count);
            new Thread(connectionHandler).start();
        }
        if (this.serverSocket != null) {
            try {
                this.Log(Level.INFO, "Closing server socket...");
                this.serverSocket.close();
                this.Log(Level.INFO, "...closed okay.");
            }
            catch (IOException e) {
                this.Log(Level.SEVERE, "Something went wrong closing server socket: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandReceived(String command, String ipOriginator, DataOutputStream dos) {
        TCPInputPoller tCPInputPoller = this;
        synchronized (tCPInputPoller) {
            if (this.onCommand(command, ipOriginator, dos)) {
                this.commandQueue.add(new CommandAndIPAddress(command, ipOriginator));
            }
        }
    }

    public boolean onCommand(String command, String ipFrom, DataOutputStream dos) {
        return true;
    }

    public void onError(String error, DataOutputStream dos) {
    }

    public int getPort() {
        if (this.serverSocket == null) {
            return -1;
        }
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPortBlocking() {
        TCPInputPoller tCPInputPoller = this;
        synchronized (tCPInputPoller) {
            while (this.getPort() == -1) {
                if (this.failedToCreate) {
                    return -1;
                }
                try {
                    this.wait(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.getPort();
    }

    public class TCPConnectionHandler
    extends Thread {
        private Socket socket;
        private TCPInputPoller poller;
        private String logname;

        public TCPConnectionHandler(Socket socket, TCPInputPoller poller, String logname) {
            this.socket = socket;
            this.poller = poller;
            this.logname = logname;
        }

        private void Log(Level level, String message) {
            TCPUtils.Log(level, "->" + this.logname + " " + message);
        }

        @Override
        public void run() {
            int MAX_STR_LEN = 10000000;
            try {
                int intC;
                this.Log(Level.INFO, "About to try reading inputstream...");
                BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                StringBuffer sb = new StringBuffer();
                while ((intC = br.read()) != -1) {
                    char c = (char)intC;
                    if (c == '\n') {
                        String command = sb.toString();
                        this.Log(Level.FINE, "Received this: " + command);
                        InetAddress address = this.socket.getInetAddress();
                        this.Log(Level.INFO, "Read line from " + this.socket.getRemoteSocketAddress() + "(remote), " + address.getHostName() + "(hostname) " + address.getHostAddress() + "(hostaddress)");
                        String originator = address.getHostName();
                        DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
                        this.poller.commandReceived(command, originator, dos);
                        if (TCPInputPoller.this.singleRequestReply) {
                            this.socket.close();
                            return;
                        }
                        sb.setLength(0);
                    } else {
                        sb.append(c);
                    }
                    if (sb.length() < 10000000) continue;
                    DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
                    this.poller.onError("MALMOERROR Input too long", dos);
                    this.Log(Level.WARNING, "Input too long (greater than 10000000) - discarding.");
                    break;
                }
            }
            catch (IOException e) {
                this.Log(Level.SEVERE, "Socket stream error: " + e);
            }
        }
    }

    public class CommandAndIPAddress {
        public String command;
        public String ipAddress;

        CommandAndIPAddress(String command, String ipAddress) {
            this.command = command;
            this.ipAddress = ipAddress;
        }
    }
}

