/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class TCPUtils {
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 30000;
    private static Logger logger = Logger.getLogger("com.microsoft.Malmo.TCPUtils");
    private static FileHandler filehandler = null;
    private static boolean logging = false;
    private static int currentIndentation = 0;
    private static SeverityLevel loggingSeverityLevel = SeverityLevel.LOG_NONE;

    public static void setLogging(SeverityLevel slevel) {
        boolean bl = logging = slevel != SeverityLevel.LOG_NONE;
        if (logging && filehandler == null) {
            try {
                Date d = new Date();
                String filename = "TCP" + DateFormatUtils.format((Date)d, (String)"yyyy-MM-dd HH-mm-ss") + ".log";
                filehandler = new FileHandler("logs" + File.separator + filename);
                filehandler.setFormatter(new UTCFormatter());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            logger.setUseParentHandlers(false);
            logger.addHandler(filehandler);
        }
        logger.setLevel(slevel.getLevel());
        loggingSeverityLevel = slevel;
    }

    public static boolean isLogging() {
        return logging;
    }

    public static void Log(Level level, String message) {
        if (logging) {
            logger.log(level, TCPUtils.getIndented(message));
        }
    }

    public static void SysLog(Level level, String message) {
        if (logging) {
            logger.log(level, TCPUtils.getIndented(message));
        }
        System.out.println(level + ": " + message);
    }

    private static String getIndented(String message) {
        return currentIndentation == 0 ? message : StringUtils.repeat((String)"    ", (int)currentIndentation) + message;
    }

    public static void update(Configuration config) {
        String[] values = new String[SeverityLevel.values().length];
        for (SeverityLevel level : SeverityLevel.values()) {
            values[level.ordinal()] = level.getDisplayName();
        }
        String severityLevel = config.getString("loggingSeverityLevel", "malmodiags", loggingSeverityLevel.getDisplayName(), "Set the level of socket debugging information to be logged.", values);
        for (SeverityLevel level : SeverityLevel.values()) {
            if (!level.getDisplayName().equals(severityLevel)) continue;
            TCPUtils.setLogging(level);
        }
    }

    private static void indent() {
        ++currentIndentation;
    }

    private static void unindent() {
        --currentIndentation;
    }

    public static ServerSocket getSocketInRange(int minPort, int maxPort, boolean random) {
        TCPUtils.Log(Level.INFO, "Attempting to create a ServerSocket in range (" + minPort + "-" + maxPort + (random ? ") at random..." : ") sequentially..."));
        ServerSocket s = null;
        int port = minPort - 1;
        Random r = new Random(System.currentTimeMillis());
        while (s == null && port <= maxPort) {
            port = random ? minPort + r.nextInt(maxPort - minPort) : ++port;
            try {
                TCPUtils.Log(Level.INFO, "    - trying " + port + "...");
                s = new ServerSocket(port);
                TCPUtils.Log(Level.INFO, "Succeeded!");
                return s;
            }
            catch (IOException e) {
                TCPUtils.Log(Level.INFO, "    - failed: " + e);
            }
        }
        TCPUtils.Log(Level.SEVERE, "Could find no available port!");
        return null;
    }

    public static class LogSection {
        public LogSection(String header) {
            TCPUtils.Log(Level.INFO, header);
            TCPUtils.Log(Level.INFO, "{");
            TCPUtils.indent();
        }

        public void close() {
            TCPUtils.unindent();
            TCPUtils.Log(Level.INFO, "}");
        }
    }

    static class UTCFormatter
    extends Formatter {
        private static final String dateformat = "yyyy-MMM-dd HH:mm:ss.S";
        private static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MMM-dd HH:mm:ss.S", (TimeZone)TimeZone.getTimeZone("UTC"));
        private static final String padding = "yyyy-MMM-dd HH:mm:ss.S00000";

        UTCFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder(1000);
            String timestamp = DATE_FORMATTER.format(new Date(record.getMillis()));
            timestamp = timestamp + padding.substring(timestamp.length());
            builder.append(timestamp).append(" M ").append(String.format("%1$-7s", record.getLevel())).append(this.formatMessage(record)).append("\n");
            return builder.toString();
        }

        @Override
        public String getHead(Handler h) {
            return super.getHead(h);
        }

        @Override
        public String getTail(Handler h) {
            return super.getTail(h);
        }
    }

    public static enum SeverityLevel {
        LOG_NONE("Logging off", Level.OFF),
        LOG_SEVERE("Log errors only", Level.SEVERE),
        LOG_WARNINGS("Log warnings", Level.WARNING),
        LOG_INFO("Log basic info", Level.INFO),
        LOG_DETAILED("Detailed logging", Level.FINE),
        LOG_ALL("Log everything", Level.ALL);

        private final String displayName;
        private final Level level;

        private SeverityLevel(String displayName, Level level) {
            this.displayName = displayName;
            this.level = level;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final Level getLevel() {
            return this.level;
        }
    }
}

