/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.microsoft.Malmo.Utils.PauseTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Timer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class TimeHelper {
    public static final float MillisecondsPerWorldTick = 50.0f;
    public static final float MillisecondsPerSecond = 1000.0f;
    private static Boolean paused = false;
    public static long serverTickLength = 50L;
    public static long displayGranularityMs = 0L;
    private static long lastUpdateTimeMs;
    private static float currentTicksPerSecond;

    public static boolean setMinecraftClientClockSpeed(float ticksPerSecond) {
        Minecraft.getMinecraft().timer = new PauseTimer(new Timer(ticksPerSecond));
        return false;
    }

    public static void pause() {
        System.out.println("Pausing");
        paused = true;
    }

    @SubscribeEvent
    public static void pauseClientTickHander(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            Minecraft.getMinecraft().isGamePaused = paused != false || Minecraft.getMinecraft().isGamePaused();
        }
    }

    @SubscribeEvent
    public static void unpauseOnShutdown(WorldEvent.Unload e) {
        SyncManager.setSynchronous(false);
        TimeHelper.unpause();
    }

    public static void unpause() {
        System.out.println("Unpausing");
        paused = false;
    }

    public static Boolean isPaused() {
        return paused;
    }

    public static void updateDisplay() {
        long timeNow = System.currentTimeMillis();
        if (timeNow - lastUpdateTimeMs > displayGranularityMs) {
            Minecraft.getMinecraft().updateDisplay();
            lastUpdateTimeMs = timeNow;
        }
    }

    static {
        currentTicksPerSecond = 0.0f;
    }

    public static class WorldTimer {
        private World world;
        private long startTime = 0L;
        private long stopTime = 0L;

        public WorldTimer(World world) {
            this.world = world;
        }

        public void start() {
            this.startTime = this.world.getTotalWorldTime();
            this.stopTime = 0L;
        }

        public void stop() {
            this.stopTime = this.world.getTotalWorldTime();
        }

        public float getDurationInMs() {
            long duration = this.stopTime != 0L ? this.stopTime - this.startTime : this.world.getTotalWorldTime() - this.startTime;
            return (float)duration * 50.0f;
        }
    }

    public static class TickRateMonitor {
        long[] eventTimestamps;
        int eventIndex = 0;
        float eventsPerSecond = 0.0f;
        int windowSize = 10;

        public TickRateMonitor() {
            this.init(10);
        }

        public TickRateMonitor(int windowSize) {
            this.init(windowSize);
        }

        void init(int windowSize) {
            this.windowSize = windowSize;
            this.eventTimestamps = new long[this.windowSize];
        }

        public float getEventsPerSecond() {
            return this.eventsPerSecond;
        }

        public void beat() {
            long now;
            this.eventIndex = (this.eventIndex + 1) % this.windowSize;
            long then = this.eventTimestamps[this.eventIndex];
            this.eventTimestamps[this.eventIndex] = now = System.currentTimeMillis();
            if (then == now) {
                System.out.println("Warning: window too narrow for timing events - increase window, or call beat() less often.");
            }
            this.eventsPerSecond = 1000.0f * (float)this.windowSize / (float)(now - then);
        }
    }

    public static class SyncTickEvent
    extends Event {
        public TickEvent.Phase pos;

        public SyncTickEvent(TickEvent.Phase phaseIn) {
            this.pos = phaseIn;
        }
    }

    public static class SyncManager {
        static Boolean synchronous = false;
        static Boolean shouldClientTick = false;
        static Boolean clientTickCompleted = false;
        static Boolean serverTickCompleted = false;
        static Boolean serverRunning = false;
        static Boolean tickCompleted = false;
        static Boolean shouldFlush = false;
        static Boolean serverPistolFired = false;
        public static long numTicks = 0L;
        static final Boolean verbose = false;
        static Boolean isTicking = false;

        public static synchronized Boolean isSynchronous() {
            return synchronous;
        }

        public static synchronized Boolean shouldFlush() {
            return shouldFlush;
        }

        public static synchronized void setSynchronous(Boolean value) {
            if (value.booleanValue()) {
                synchronous = value;
                shouldFlush = false;
            } else if (!value.booleanValue() && synchronous.booleanValue()) {
                shouldFlush = true;
            }
        }

        public static synchronized Boolean requestTick() {
            if (!isTicking.booleanValue()) {
                SyncManager.debugLog("============ SYNC TICK STARTED ===========");
                shouldClientTick = true;
                isTicking = true;
                clientTickCompleted = false;
                serverTickCompleted = false;
                tickCompleted = false;
                return true;
            }
            return false;
        }

        public static synchronized void setPistolFired(Boolean hasIt) {
            if (hasIt.booleanValue() && !serverPistolFired.booleanValue()) {
                SyncManager.debugLog("Server pistol has started firing.");
            }
            serverPistolFired = hasIt;
        }

        public static synchronized Boolean shouldClientTick() {
            return shouldClientTick != false && isTicking != false || shouldFlush != false;
        }

        public static synchronized Boolean shouldServerTick() {
            return isTicking != false && clientTickCompleted != false && serverTickCompleted == false && tickCompleted == false || shouldFlush != false;
        }

        public static synchronized Boolean shouldRenderTick() {
            return isTicking != false && (serverTickCompleted != false || serverRunning == false) && clientTickCompleted != false || shouldFlush != false;
        }

        public static void debugLog(String logger) {
            if (verbose.booleanValue()) {
                System.out.println("SYNCMANAGER DEBUG: " + logger);
            }
        }

        public static synchronized void setServerRunning() {
            serverRunning = true;
        }

        public static synchronized Boolean isServerRunning() {
            return serverRunning;
        }

        public static synchronized void serverFinished() {
            serverRunning = false;
        }

        public static synchronized void completeClientTick() {
            clientTickCompleted = true;
            shouldClientTick = false;
        }

        public static synchronized void completeServerTick() {
            serverTickCompleted = true;
        }

        public static synchronized void completeTick() {
            if (shouldFlush.booleanValue()) {
                synchronous = false;
            }
            shouldFlush = false;
            isTicking = false;
            shouldClientTick = false;
            serverTickCompleted = false;
            clientTickCompleted = false;
            tickCompleted = true;
        }

        public static synchronized Boolean isTicking() {
            return isTicking;
        }

        public static synchronized Boolean isTickCompleted() {
            return tickCompleted;
        }

        public static synchronized Boolean hasServerFiredPistol() {
            return serverPistolFired;
        }
    }
}

