/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBarrier;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockBone;
import net.minecraft.block.BlockBookshelf;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockButtonStone;
import net.minecraft.block.BlockButtonWood;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockChorusPlant;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockCompressedPowered;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDoubleStoneSlab;
import net.minecraft.block.BlockDoubleStoneSlabNew;
import net.minecraft.block.BlockDoubleWoodSlab;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockEmptyDrops;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockEndGateway;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFrostedIce;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockHalfStoneSlab;
import net.minecraft.block.BlockHalfStoneSlabNew;
import net.minecraft.block.BlockHalfWoodSlab;
import net.minecraft.block.BlockHardenedClay;
import net.minecraft.block.BlockHay;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockNetherBrick;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockObsidian;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPackedIce;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockPressurePlateWeighted;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockPurpurSlab;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRedFlower;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSeaLantern;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowBlock;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.BlockStructureVoid;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.BlockYellowFlower;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Block
extends IForgeRegistryEntry.Impl<Block> {
    private static final ResourceLocation AIR_ID = new ResourceLocation("air");
    public static final RegistryNamespacedDefaultedByKey<ResourceLocation, Block> REGISTRY = GameData.getBlockRegistry();
    @Deprecated
    public static final ObjectIntIdentityMap<IBlockState> BLOCK_STATE_IDS = GameData.getBlockStateIDMap();
    public static final AxisAlignedBB FULL_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    @Nullable
    public static final AxisAlignedBB NULL_AABB = null;
    private CreativeTabs displayOnCreativeTab;
    protected boolean fullBlock;
    protected int lightOpacity;
    protected boolean translucent;
    protected int lightValue;
    protected boolean useNeighborBrightness;
    protected float blockHardness;
    protected float blockResistance;
    protected boolean enableStats = true;
    protected boolean needsRandomTick;
    protected boolean isBlockContainer;
    protected SoundType blockSoundType;
    public float blockParticleGravity = 1.0f;
    protected final Material blockMaterial;
    protected final MapColor blockMapColor;
    public float slipperiness = 0.6f;
    protected final BlockStateContainer blockState;
    private IBlockState defaultBlockState;
    private String unlocalizedName;
    protected ThreadLocal<EntityPlayer> harvesters = new ThreadLocal();
    private ThreadLocal<IBlockState> silk_check_state = new ThreadLocal();
    protected static Random RANDOM = new Random();
    private boolean isTileProvider = this instanceof ITileEntityProvider;
    private String[] harvestTool = new String[16];
    private int[] harvestLevel = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    protected static ThreadLocal<Boolean> captureDrops = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    protected static ThreadLocal<List<ItemStack>> capturedDrops = new ThreadLocal<List<ItemStack>>(){

        @Override
        protected List<ItemStack> initialValue() {
            return new ArrayList<ItemStack>();
        }
    };

    public static int getIdFromBlock(Block p_getIdFromBlock_0_) {
        return REGISTRY.getIDForObject(p_getIdFromBlock_0_);
    }

    public static int getStateId(IBlockState p_getStateId_0_) {
        Block block = p_getStateId_0_.getBlock();
        return Block.getIdFromBlock(block) + (block.getMetaFromState(p_getStateId_0_) << 12);
    }

    public static Block getBlockById(int p_getBlockById_0_) {
        return REGISTRY.getObjectById(p_getBlockById_0_);
    }

    public static IBlockState getStateById(int p_getStateById_0_) {
        int i = p_getStateById_0_ & 0xFFF;
        int j = p_getStateById_0_ >> 12 & 0xF;
        return Block.getBlockById(i).getStateFromMeta(j);
    }

    public static Block getBlockFromItem(Item p_getBlockFromItem_0_) {
        return p_getBlockFromItem_0_ instanceof ItemBlock ? ((ItemBlock)p_getBlockFromItem_0_).getBlock() : Blocks.AIR;
    }

    @Nullable
    public static Block getBlockFromName(String p_getBlockFromName_0_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_getBlockFromName_0_);
        if (REGISTRY.containsKey(resourcelocation)) {
            return REGISTRY.getObject(resourcelocation);
        }
        try {
            return REGISTRY.getObjectById(Integer.parseInt(p_getBlockFromName_0_));
        }
        catch (NumberFormatException var3) {
            return null;
        }
    }

    @Deprecated
    public boolean isFullyOpaque(IBlockState p_isFullyOpaque_1_) {
        return p_isFullyOpaque_1_.getMaterial().isOpaque() && p_isFullyOpaque_1_.isFullCube();
    }

    @Deprecated
    public boolean isFullBlock(IBlockState p_isFullBlock_1_) {
        return this.fullBlock;
    }

    @Deprecated
    public boolean canEntitySpawn(IBlockState p_canEntitySpawn_1_, Entity p_canEntitySpawn_2_) {
        return true;
    }

    @Deprecated
    public int getLightOpacity(IBlockState p_getLightOpacity_1_) {
        return this.lightOpacity;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean isTranslucent(IBlockState p_isTranslucent_1_) {
        return this.translucent;
    }

    @Deprecated
    public int getLightValue(IBlockState p_getLightValue_1_) {
        return this.lightValue;
    }

    @Deprecated
    public boolean getUseNeighborBrightness(IBlockState p_getUseNeighborBrightness_1_) {
        return this.useNeighborBrightness;
    }

    @Deprecated
    public Material getMaterial(IBlockState p_getMaterial_1_) {
        return this.blockMaterial;
    }

    @Deprecated
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return this.blockMapColor;
    }

    @Deprecated
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState();
    }

    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        if (p_getMetaFromState_1_.getPropertyKeys().isEmpty()) {
            return 0;
        }
        throw new IllegalArgumentException("Don't know how to convert " + p_getMetaFromState_1_ + " back into data...");
    }

    @Deprecated
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        return p_getActualState_1_;
    }

    @Deprecated
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_;
    }

    @Deprecated
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_;
    }

    public Block(Material p_i46399_1_, MapColor p_i46399_2_) {
        this.blockSoundType = SoundType.STONE;
        this.blockMaterial = p_i46399_1_;
        this.blockMapColor = p_i46399_2_;
        this.blockState = this.createBlockState();
        this.setDefaultState(this.blockState.getBaseState());
        this.fullBlock = this.getDefaultState().isOpaqueCube();
        this.lightOpacity = this.fullBlock ? 255 : 0;
        this.translucent = !p_i46399_1_.blocksLight();
    }

    public Block(Material p_i45394_1_) {
        this(p_i45394_1_, p_i45394_1_.getMaterialMapColor());
    }

    protected Block setSoundType(SoundType p_setSoundType_1_) {
        this.blockSoundType = p_setSoundType_1_;
        return this;
    }

    public Block setLightOpacity(int p_setLightOpacity_1_) {
        this.lightOpacity = p_setLightOpacity_1_;
        return this;
    }

    public Block setLightLevel(float p_setLightLevel_1_) {
        this.lightValue = (int)(15.0f * p_setLightLevel_1_);
        return this;
    }

    public Block setResistance(float p_setResistance_1_) {
        this.blockResistance = p_setResistance_1_ * 3.0f;
        return this;
    }

    @Deprecated
    public boolean isBlockNormalCube(IBlockState p_isBlockNormalCube_1_) {
        return p_isBlockNormalCube_1_.getMaterial().blocksMovement() && p_isBlockNormalCube_1_.isFullCube();
    }

    @Deprecated
    public boolean isNormalCube(IBlockState p_isNormalCube_1_) {
        return p_isNormalCube_1_.getMaterial().isOpaque() && p_isNormalCube_1_.isFullCube() && !p_isNormalCube_1_.canProvidePower();
    }

    @Deprecated
    public boolean causesSuffocation(IBlockState p_causesSuffocation_1_) {
        return this.blockMaterial.blocksMovement() && this.getDefaultState().isFullCube();
    }

    @Deprecated
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return true;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomBreakingProgress(IBlockState p_hasCustomBreakingProgress_1_) {
        return false;
    }

    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return !this.blockMaterial.blocksMovement();
    }

    @Deprecated
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isReplaceable(IBlockAccess p_isReplaceable_1_, BlockPos p_isReplaceable_2_) {
        return p_isReplaceable_1_.getBlockState(p_isReplaceable_2_).getMaterial().isReplaceable();
    }

    public Block setHardness(float p_setHardness_1_) {
        this.blockHardness = p_setHardness_1_;
        if (this.blockResistance < p_setHardness_1_ * 5.0f) {
            this.blockResistance = p_setHardness_1_ * 5.0f;
        }
        return this;
    }

    public Block setBlockUnbreakable() {
        this.setHardness(-1.0f);
        return this;
    }

    @Deprecated
    public float getBlockHardness(IBlockState p_getBlockHardness_1_, World p_getBlockHardness_2_, BlockPos p_getBlockHardness_3_) {
        return this.blockHardness;
    }

    public Block setTickRandomly(boolean p_setTickRandomly_1_) {
        this.needsRandomTick = p_setTickRandomly_1_;
        return this;
    }

    public boolean getTickRandomly() {
        return this.needsRandomTick;
    }

    @Deprecated
    public boolean hasTileEntity() {
        return this.hasTileEntity(this.getDefaultState());
    }

    @Deprecated
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return FULL_BLOCK_AABB;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public int getPackedLightmapCoords(IBlockState p_getPackedLightmapCoords_1_, IBlockAccess p_getPackedLightmapCoords_2_, BlockPos p_getPackedLightmapCoords_3_) {
        int i = p_getPackedLightmapCoords_2_.getCombinedLight(p_getPackedLightmapCoords_3_, p_getPackedLightmapCoords_1_.getLightValue(p_getPackedLightmapCoords_2_, p_getPackedLightmapCoords_3_));
        if (i == 0 && p_getPackedLightmapCoords_1_.getBlock() instanceof BlockSlab) {
            p_getPackedLightmapCoords_3_ = p_getPackedLightmapCoords_3_.down();
            p_getPackedLightmapCoords_1_ = p_getPackedLightmapCoords_2_.getBlockState(p_getPackedLightmapCoords_3_);
            return p_getPackedLightmapCoords_2_.getCombinedLight(p_getPackedLightmapCoords_3_, p_getPackedLightmapCoords_1_.getLightValue(p_getPackedLightmapCoords_2_, p_getPackedLightmapCoords_3_));
        }
        return i;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        AxisAlignedBB axisalignedbb = p_shouldSideBeRendered_1_.getBoundingBox(p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_);
        switch (p_shouldSideBeRendered_4_) {
            case DOWN: {
                if (!(axisalignedbb.minY > 0.0)) break;
                return true;
            }
            case UP: {
                if (!(axisalignedbb.maxY < 1.0)) break;
                return true;
            }
            case NORTH: {
                if (!(axisalignedbb.minZ > 0.0)) break;
                return true;
            }
            case SOUTH: {
                if (!(axisalignedbb.maxZ < 1.0)) break;
                return true;
            }
            case WEST: {
                if (!(axisalignedbb.minX > 0.0)) break;
                return true;
            }
            case EAST: {
                if (!(axisalignedbb.maxX < 1.0)) break;
                return true;
            }
        }
        return !p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_)).doesSideBlockRendering(p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_), p_shouldSideBeRendered_4_.getOpposite());
    }

    public boolean isBlockSolid(IBlockAccess p_isBlockSolid_1_, BlockPos p_isBlockSolid_2_, EnumFacing p_isBlockSolid_3_) {
        return p_isBlockSolid_1_.getBlockState(p_isBlockSolid_2_).getMaterial().isSolid();
    }

    @Deprecated
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        Block.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, p_addCollisionBoxToList_1_.getCollisionBoundingBox(p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_));
    }

    protected static void addCollisionBoxToList(BlockPos p_addCollisionBoxToList_0_, AxisAlignedBB p_addCollisionBoxToList_1_, List<AxisAlignedBB> p_addCollisionBoxToList_2_, AxisAlignedBB p_addCollisionBoxToList_3_) {
        AxisAlignedBB axisalignedbb;
        if (p_addCollisionBoxToList_3_ != NULL_AABB && p_addCollisionBoxToList_1_.intersectsWith(axisalignedbb = p_addCollisionBoxToList_3_.offset(p_addCollisionBoxToList_0_))) {
            p_addCollisionBoxToList_2_.add(axisalignedbb);
        }
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return p_getCollisionBoundingBox_1_.getBoundingBox(p_getCollisionBoundingBox_2_, p_getCollisionBoundingBox_3_);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBox(IBlockState p_getSelectedBoundingBox_1_, World p_getSelectedBoundingBox_2_, BlockPos p_getSelectedBoundingBox_3_) {
        return p_getSelectedBoundingBox_1_.getBoundingBox(p_getSelectedBoundingBox_2_, p_getSelectedBoundingBox_3_).offset(p_getSelectedBoundingBox_3_);
    }

    @Deprecated
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return true;
    }

    public boolean canCollideCheck(IBlockState p_canCollideCheck_1_, boolean p_canCollideCheck_2_) {
        return this.isCollidable();
    }

    public boolean isCollidable() {
        return true;
    }

    public void randomTick(World p_randomTick_1_, BlockPos p_randomTick_2_, IBlockState p_randomTick_3_, Random p_randomTick_4_) {
        this.updateTick(p_randomTick_1_, p_randomTick_2_, p_randomTick_3_, p_randomTick_4_);
    }

    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
    }

    public void onBlockDestroyedByPlayer(World p_onBlockDestroyedByPlayer_1_, BlockPos p_onBlockDestroyedByPlayer_2_, IBlockState p_onBlockDestroyedByPlayer_3_) {
    }

    @Deprecated
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
    }

    public int tickRate(World p_tickRate_1_) {
        return 10;
    }

    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
    }

    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        if (this.hasTileEntity(p_breakBlock_3_) && !(this instanceof BlockContainer)) {
            p_breakBlock_1_.removeTileEntity(p_breakBlock_2_);
        }
    }

    public int quantityDropped(Random p_quantityDropped_1_) {
        return 1;
    }

    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Item.getItemFromBlock(this);
    }

    @Deprecated
    public float getPlayerRelativeBlockHardness(IBlockState p_getPlayerRelativeBlockHardness_1_, EntityPlayer p_getPlayerRelativeBlockHardness_2_, World p_getPlayerRelativeBlockHardness_3_, BlockPos p_getPlayerRelativeBlockHardness_4_) {
        return ForgeHooks.blockStrength(p_getPlayerRelativeBlockHardness_1_, p_getPlayerRelativeBlockHardness_2_, p_getPlayerRelativeBlockHardness_3_, p_getPlayerRelativeBlockHardness_4_);
    }

    public final void dropBlockAsItem(World p_dropBlockAsItem_1_, BlockPos p_dropBlockAsItem_2_, IBlockState p_dropBlockAsItem_3_, int p_dropBlockAsItem_4_) {
        this.dropBlockAsItemWithChance(p_dropBlockAsItem_1_, p_dropBlockAsItem_2_, p_dropBlockAsItem_3_, 1.0f, p_dropBlockAsItem_4_);
    }

    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        if (!p_dropBlockAsItemWithChance_1_.isRemote && !p_dropBlockAsItemWithChance_1_.restoringBlockSnapshots) {
            List<ItemStack> items = this.getDrops(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_5_);
            p_dropBlockAsItemWithChance_4_ = ForgeEventFactory.fireBlockHarvesting(items, p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_5_, p_dropBlockAsItemWithChance_4_, false, this.harvesters.get());
            for (ItemStack item : items) {
                if (!(p_dropBlockAsItemWithChance_1_.rand.nextFloat() <= p_dropBlockAsItemWithChance_4_)) continue;
                Block.spawnAsEntity(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, item);
            }
        }
    }

    public static void spawnAsEntity(World p_spawnAsEntity_0_, BlockPos p_spawnAsEntity_1_, ItemStack p_spawnAsEntity_2_) {
        if (!p_spawnAsEntity_0_.isRemote && !p_spawnAsEntity_2_.isEmpty() && p_spawnAsEntity_0_.getGameRules().getBoolean("doTileDrops") && !p_spawnAsEntity_0_.restoringBlockSnapshots) {
            if (captureDrops.get().booleanValue()) {
                capturedDrops.get().add(p_spawnAsEntity_2_);
                return;
            }
            float f = 0.5f;
            double d0 = (double)(p_spawnAsEntity_0_.rand.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(p_spawnAsEntity_0_.rand.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(p_spawnAsEntity_0_.rand.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(p_spawnAsEntity_0_, (double)p_spawnAsEntity_1_.getX() + d0, (double)p_spawnAsEntity_1_.getY() + d1, (double)p_spawnAsEntity_1_.getZ() + d2, p_spawnAsEntity_2_);
            entityitem.setDefaultPickupDelay();
            p_spawnAsEntity_0_.spawnEntity(entityitem);
        }
    }

    public void dropXpOnBlockBreak(World p_dropXpOnBlockBreak_1_, BlockPos p_dropXpOnBlockBreak_2_, int p_dropXpOnBlockBreak_3_) {
        if (!p_dropXpOnBlockBreak_1_.isRemote && p_dropXpOnBlockBreak_1_.getGameRules().getBoolean("doTileDrops")) {
            while (p_dropXpOnBlockBreak_3_ > 0) {
                int i = EntityXPOrb.getXPSplit(p_dropXpOnBlockBreak_3_);
                p_dropXpOnBlockBreak_3_ -= i;
                p_dropXpOnBlockBreak_1_.spawnEntity(new EntityXPOrb(p_dropXpOnBlockBreak_1_, (double)p_dropXpOnBlockBreak_2_.getX() + 0.5, (double)p_dropXpOnBlockBreak_2_.getY() + 0.5, (double)p_dropXpOnBlockBreak_2_.getZ() + 0.5, i));
            }
        }
    }

    public int damageDropped(IBlockState p_damageDropped_1_) {
        return 0;
    }

    public float getExplosionResistance(Entity p_getExplosionResistance_1_) {
        return this.blockResistance / 5.0f;
    }

    @Deprecated
    @Nullable
    public RayTraceResult collisionRayTrace(IBlockState p_collisionRayTrace_1_, World p_collisionRayTrace_2_, BlockPos p_collisionRayTrace_3_, Vec3d p_collisionRayTrace_4_, Vec3d p_collisionRayTrace_5_) {
        return this.rayTrace(p_collisionRayTrace_3_, p_collisionRayTrace_4_, p_collisionRayTrace_5_, p_collisionRayTrace_1_.getBoundingBox(p_collisionRayTrace_2_, p_collisionRayTrace_3_));
    }

    @Nullable
    protected RayTraceResult rayTrace(BlockPos p_rayTrace_1_, Vec3d p_rayTrace_2_, Vec3d p_rayTrace_3_, AxisAlignedBB p_rayTrace_4_) {
        Vec3d vec3d1;
        Vec3d vec3d = p_rayTrace_2_.subtract(p_rayTrace_1_.getX(), p_rayTrace_1_.getY(), p_rayTrace_1_.getZ());
        RayTraceResult raytraceresult = p_rayTrace_4_.calculateIntercept(vec3d, vec3d1 = p_rayTrace_3_.subtract(p_rayTrace_1_.getX(), p_rayTrace_1_.getY(), p_rayTrace_1_.getZ()));
        return raytraceresult == null ? null : new RayTraceResult(raytraceresult.hitVec.addVector(p_rayTrace_1_.getX(), p_rayTrace_1_.getY(), p_rayTrace_1_.getZ()), raytraceresult.sideHit, p_rayTrace_1_);
    }

    public void onBlockDestroyedByExplosion(World p_onBlockDestroyedByExplosion_1_, BlockPos p_onBlockDestroyedByExplosion_2_, Explosion p_onBlockDestroyedByExplosion_3_) {
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.SOLID;
    }

    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_) {
        return this.canPlaceBlockAt(p_canPlaceBlockOnSide_1_, p_canPlaceBlockOnSide_2_);
    }

    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_).getBlock().isReplaceable(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_);
    }

    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        return false;
    }

    public void onEntityWalk(World p_onEntityWalk_1_, BlockPos p_onEntityWalk_2_, Entity p_onEntityWalk_3_) {
    }

    @Deprecated
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getStateFromMeta(p_getStateForPlacement_7_);
    }

    public void onBlockClicked(World p_onBlockClicked_1_, BlockPos p_onBlockClicked_2_, EntityPlayer p_onBlockClicked_3_) {
    }

    public Vec3d modifyAcceleration(World p_modifyAcceleration_1_, BlockPos p_modifyAcceleration_2_, Entity p_modifyAcceleration_3_, Vec3d p_modifyAcceleration_4_) {
        return p_modifyAcceleration_4_;
    }

    @Deprecated
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return 0;
    }

    @Deprecated
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return false;
    }

    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
    }

    @Deprecated
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return 0;
    }

    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        p_harvestBlock_2_.addStat(StatList.getBlockStats(this));
        p_harvestBlock_2_.addExhaustion(0.005f);
        if (this.canSilkHarvest(p_harvestBlock_1_, p_harvestBlock_3_, p_harvestBlock_4_, p_harvestBlock_2_) && EnchantmentHelper.getEnchantmentLevel(Enchantments.SILK_TOUCH, p_harvestBlock_6_) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.getSilkTouchDrop(p_harvestBlock_4_);
            if (!itemstack.isEmpty()) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, p_harvestBlock_1_, p_harvestBlock_3_, p_harvestBlock_4_, 0, 1.0f, true, p_harvestBlock_2_);
            for (ItemStack item : items) {
                Block.spawnAsEntity(p_harvestBlock_1_, p_harvestBlock_3_, item);
            }
        } else {
            this.harvesters.set(p_harvestBlock_2_);
            int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.FORTUNE, p_harvestBlock_6_);
            this.dropBlockAsItem(p_harvestBlock_1_, p_harvestBlock_3_, p_harvestBlock_4_, i);
            this.harvesters.set(null);
        }
    }

    @Deprecated
    protected boolean canSilkHarvest() {
        return this.getDefaultState().isFullCube() && !this.hasTileEntity(this.silk_check_state.get());
    }

    protected ItemStack getSilkTouchDrop(IBlockState p_getSilkTouchDrop_1_) {
        Item item = Item.getItemFromBlock(this);
        int i = 0;
        if (item.getHasSubtypes()) {
            i = this.getMetaFromState(p_getSilkTouchDrop_1_);
        }
        return new ItemStack(item, 1, i);
    }

    public int quantityDroppedWithBonus(int p_quantityDroppedWithBonus_1_, Random p_quantityDroppedWithBonus_2_) {
        return this.quantityDropped(p_quantityDroppedWithBonus_2_);
    }

    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
    }

    public boolean canSpawnInBlock() {
        return !this.blockMaterial.isSolid() && !this.blockMaterial.isLiquid();
    }

    public Block setUnlocalizedName(String p_setUnlocalizedName_1_) {
        this.unlocalizedName = p_setUnlocalizedName_1_;
        return this;
    }

    public String getLocalizedName() {
        return I18n.translateToLocal(this.getUnlocalizedName() + ".name");
    }

    public String getUnlocalizedName() {
        return "tile." + this.unlocalizedName;
    }

    @Deprecated
    public boolean eventReceived(IBlockState p_eventReceived_1_, World p_eventReceived_2_, BlockPos p_eventReceived_3_, int p_eventReceived_4_, int p_eventReceived_5_) {
        return false;
    }

    public boolean getEnableStats() {
        return this.enableStats;
    }

    protected Block disableStats() {
        this.enableStats = false;
        return this;
    }

    @Deprecated
    public EnumPushReaction getMobilityFlag(IBlockState p_getMobilityFlag_1_) {
        return this.blockMaterial.getMobilityFlag();
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public float getAmbientOcclusionLightValue(IBlockState p_getAmbientOcclusionLightValue_1_) {
        return p_getAmbientOcclusionLightValue_1_.isBlockNormalCube() ? 0.2f : 1.0f;
    }

    public void onFallenUpon(World p_onFallenUpon_1_, BlockPos p_onFallenUpon_2_, Entity p_onFallenUpon_3_, float p_onFallenUpon_4_) {
        p_onFallenUpon_3_.fall(p_onFallenUpon_4_, 1.0f);
    }

    public void onLanded(World p_onLanded_1_, Entity p_onLanded_2_) {
        p_onLanded_2_.motionY = 0.0;
    }

    @Deprecated
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Item.getItemFromBlock(this), 1, this.damageDropped(p_getItem_3_));
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_));
    }

    public Block setCreativeTab(CreativeTabs p_setCreativeTab_1_) {
        this.displayOnCreativeTab = p_setCreativeTab_1_;
        return this;
    }

    public void onBlockHarvested(World p_onBlockHarvested_1_, BlockPos p_onBlockHarvested_2_, IBlockState p_onBlockHarvested_3_, EntityPlayer p_onBlockHarvested_4_) {
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs getCreativeTabToDisplayOn() {
        return this.displayOnCreativeTab;
    }

    public void fillWithRain(World p_fillWithRain_1_, BlockPos p_fillWithRain_2_) {
    }

    public boolean requiresUpdates() {
        return true;
    }

    public boolean canDropFromExplosion(Explosion p_canDropFromExplosion_1_) {
        return true;
    }

    public boolean isAssociatedBlock(Block p_isAssociatedBlock_1_) {
        return this == p_isAssociatedBlock_1_;
    }

    public static boolean isEqualTo(Block p_isEqualTo_0_, Block p_isEqualTo_1_) {
        return p_isEqualTo_0_ != null && p_isEqualTo_1_ != null ? (p_isEqualTo_0_ == p_isEqualTo_1_ ? true : p_isEqualTo_0_.isAssociatedBlock(p_isEqualTo_1_)) : false;
    }

    @Deprecated
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return false;
    }

    @Deprecated
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        return 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer(this, new IProperty[0]);
    }

    public BlockStateContainer getBlockState() {
        return this.blockState;
    }

    protected final void setDefaultState(IBlockState p_setDefaultState_1_) {
        this.defaultBlockState = p_setDefaultState_1_;
    }

    public final IBlockState getDefaultState() {
        return this.defaultBlockState;
    }

    public EnumOffsetType getOffsetType() {
        return EnumOffsetType.NONE;
    }

    @Deprecated
    public Vec3d getOffset(IBlockState p_getOffset_1_, IBlockAccess p_getOffset_2_, BlockPos p_getOffset_3_) {
        EnumOffsetType block$enumoffsettype = this.getOffsetType();
        if (block$enumoffsettype == EnumOffsetType.NONE) {
            return Vec3d.ZERO;
        }
        long i = MathHelper.getCoordinateRandom(p_getOffset_3_.getX(), 0, p_getOffset_3_.getZ());
        return new Vec3d(((double)((float)(i >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5, block$enumoffsettype == EnumOffsetType.XYZ ? ((double)((float)(i >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(i >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5);
    }

    @Deprecated
    public SoundType getSoundType() {
        return this.blockSoundType;
    }

    public String toString() {
        return "Block{" + REGISTRY.getNameForObject(this) + "}";
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
    }

    public int getLightValue(IBlockState p_getLightValue_1_, IBlockAccess p_getLightValue_2_, BlockPos p_getLightValue_3_) {
        IBlockState other = p_getLightValue_2_.getBlockState(p_getLightValue_3_);
        if (other.getBlock() != this) {
            return other.getLightValue(p_getLightValue_2_, p_getLightValue_3_);
        }
        return p_getLightValue_1_.getLightValue();
    }

    public boolean isLadder(IBlockState p_isLadder_1_, IBlockAccess p_isLadder_2_, BlockPos p_isLadder_3_, EntityLivingBase p_isLadder_4_) {
        return false;
    }

    public boolean isNormalCube(IBlockState p_isNormalCube_1_, IBlockAccess p_isNormalCube_2_, BlockPos p_isNormalCube_3_) {
        return p_isNormalCube_1_.isNormalCube();
    }

    public boolean doesSideBlockRendering(IBlockState p_doesSideBlockRendering_1_, IBlockAccess p_doesSideBlockRendering_2_, BlockPos p_doesSideBlockRendering_3_, EnumFacing p_doesSideBlockRendering_4_) {
        return p_doesSideBlockRendering_1_.isOpaqueCube();
    }

    public boolean isSideSolid(IBlockState p_isSideSolid_1_, IBlockAccess p_isSideSolid_2_, BlockPos p_isSideSolid_3_, EnumFacing p_isSideSolid_4_) {
        if (p_isSideSolid_1_.isFullyOpaque() && p_isSideSolid_4_ == EnumFacing.UP) {
            return true;
        }
        if (this instanceof BlockSlab) {
            IBlockState state = this.getActualState(p_isSideSolid_1_, p_isSideSolid_2_, p_isSideSolid_3_);
            return p_isSideSolid_1_.isFullBlock() || state.getValue(BlockSlab.HALF) == BlockSlab.EnumBlockHalf.TOP && p_isSideSolid_4_ == EnumFacing.UP || state.getValue(BlockSlab.HALF) == BlockSlab.EnumBlockHalf.BOTTOM && p_isSideSolid_4_ == EnumFacing.DOWN;
        }
        if (this instanceof BlockFarmland) {
            return p_isSideSolid_4_ != EnumFacing.DOWN && p_isSideSolid_4_ != EnumFacing.UP;
        }
        if (this instanceof BlockStairs) {
            IBlockState state = this.getActualState(p_isSideSolid_1_, p_isSideSolid_2_, p_isSideSolid_3_);
            boolean flipped = state.getValue(BlockStairs.HALF) == BlockStairs.EnumHalf.TOP;
            BlockStairs.EnumShape shape = state.getValue(BlockStairs.SHAPE);
            EnumFacing facing = state.getValue(BlockStairs.FACING);
            if (p_isSideSolid_4_ == EnumFacing.UP) {
                return flipped;
            }
            if (p_isSideSolid_4_ == EnumFacing.DOWN) {
                return !flipped;
            }
            if (facing == p_isSideSolid_4_) {
                return true;
            }
            if (flipped) {
                if (shape == BlockStairs.EnumShape.INNER_LEFT) {
                    return p_isSideSolid_4_ == facing.rotateYCCW();
                }
                if (shape == BlockStairs.EnumShape.INNER_RIGHT) {
                    return p_isSideSolid_4_ == facing.rotateY();
                }
            } else {
                if (shape == BlockStairs.EnumShape.INNER_LEFT) {
                    return p_isSideSolid_4_ == facing.rotateY();
                }
                if (shape == BlockStairs.EnumShape.INNER_RIGHT) {
                    return p_isSideSolid_4_ == facing.rotateYCCW();
                }
            }
            return false;
        }
        if (this instanceof BlockSnow) {
            IBlockState state = this.getActualState(p_isSideSolid_1_, p_isSideSolid_2_, p_isSideSolid_3_);
            return state.getValue(BlockSnow.LAYERS) >= 8;
        }
        if (this instanceof BlockHopper && p_isSideSolid_4_ == EnumFacing.UP) {
            return true;
        }
        if (this instanceof BlockCompressedPowered) {
            return true;
        }
        return this.isNormalCube(p_isSideSolid_1_, p_isSideSolid_2_, p_isSideSolid_3_);
    }

    public boolean isBurning(IBlockAccess p_isBurning_1_, BlockPos p_isBurning_2_) {
        return false;
    }

    public boolean isAir(IBlockState p_isAir_1_, IBlockAccess p_isAir_2_, BlockPos p_isAir_3_) {
        return p_isAir_1_.getMaterial() == Material.AIR;
    }

    public boolean canHarvestBlock(IBlockAccess p_canHarvestBlock_1_, BlockPos p_canHarvestBlock_2_, EntityPlayer p_canHarvestBlock_3_) {
        return ForgeHooks.canHarvestBlock(this, p_canHarvestBlock_3_, p_canHarvestBlock_1_, p_canHarvestBlock_2_);
    }

    public boolean removedByPlayer(IBlockState p_removedByPlayer_1_, World p_removedByPlayer_2_, BlockPos p_removedByPlayer_3_, EntityPlayer p_removedByPlayer_4_, boolean p_removedByPlayer_5_) {
        this.onBlockHarvested(p_removedByPlayer_2_, p_removedByPlayer_3_, p_removedByPlayer_1_, p_removedByPlayer_4_);
        return p_removedByPlayer_2_.setBlockState(p_removedByPlayer_3_, Blocks.AIR.getDefaultState(), p_removedByPlayer_2_.isRemote ? 11 : 3);
    }

    public int getFlammability(IBlockAccess p_getFlammability_1_, BlockPos p_getFlammability_2_, EnumFacing p_getFlammability_3_) {
        return Blocks.FIRE.getFlammability(this);
    }

    public boolean isFlammable(IBlockAccess p_isFlammable_1_, BlockPos p_isFlammable_2_, EnumFacing p_isFlammable_3_) {
        return this.getFlammability(p_isFlammable_1_, p_isFlammable_2_, p_isFlammable_3_) > 0;
    }

    public int getFireSpreadSpeed(IBlockAccess p_getFireSpreadSpeed_1_, BlockPos p_getFireSpreadSpeed_2_, EnumFacing p_getFireSpreadSpeed_3_) {
        return Blocks.FIRE.getEncouragement(this);
    }

    public boolean isFireSource(World p_isFireSource_1_, BlockPos p_isFireSource_2_, EnumFacing p_isFireSource_3_) {
        if (this == Blocks.NETHERRACK && p_isFireSource_3_ == EnumFacing.UP) {
            return true;
        }
        return p_isFireSource_1_.provider instanceof WorldProviderEnd && this == Blocks.BEDROCK && p_isFireSource_3_ == EnumFacing.UP;
    }

    public boolean hasTileEntity(IBlockState p_hasTileEntity_1_) {
        return this.isTileProvider;
    }

    @Nullable
    public TileEntity createTileEntity(World p_createTileEntity_1_, IBlockState p_createTileEntity_2_) {
        if (this.isTileProvider) {
            return ((ITileEntityProvider)((Object)this)).createNewTileEntity(p_createTileEntity_1_, this.getMetaFromState(p_createTileEntity_2_));
        }
        return null;
    }

    public int quantityDropped(IBlockState p_quantityDropped_1_, int p_quantityDropped_2_, Random p_quantityDropped_3_) {
        return this.quantityDroppedWithBonus(p_quantityDropped_2_, p_quantityDropped_3_);
    }

    public List<ItemStack> getDrops(IBlockAccess p_getDrops_1_, BlockPos p_getDrops_2_, IBlockState p_getDrops_3_, int p_getDrops_4_) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = p_getDrops_1_ instanceof World ? ((World)p_getDrops_1_).rand : RANDOM;
        int count = this.quantityDropped(p_getDrops_3_, p_getDrops_4_, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.getItemDropped(p_getDrops_3_, rand, p_getDrops_4_);
            if (item == Items.AIR) continue;
            ret.add(new ItemStack(item, 1, this.damageDropped(p_getDrops_3_)));
        }
        return ret;
    }

    public boolean canSilkHarvest(World p_canSilkHarvest_1_, BlockPos p_canSilkHarvest_2_, IBlockState p_canSilkHarvest_3_, EntityPlayer p_canSilkHarvest_4_) {
        this.silk_check_state.set(p_canSilkHarvest_3_);
        boolean ret = this.canSilkHarvest();
        this.silk_check_state.set(null);
        return ret;
    }

    public boolean canCreatureSpawn(IBlockState p_canCreatureSpawn_1_, IBlockAccess p_canCreatureSpawn_2_, BlockPos p_canCreatureSpawn_3_, EntityLiving.SpawnPlacementType p_canCreatureSpawn_4_) {
        return this.isSideSolid(p_canCreatureSpawn_1_, p_canCreatureSpawn_2_, p_canCreatureSpawn_3_, EnumFacing.UP);
    }

    public boolean isBed(IBlockState p_isBed_1_, IBlockAccess p_isBed_2_, BlockPos p_isBed_3_, Entity p_isBed_4_) {
        return this == Blocks.BED;
    }

    @Nullable
    public BlockPos getBedSpawnPosition(IBlockState p_getBedSpawnPosition_1_, IBlockAccess p_getBedSpawnPosition_2_, BlockPos p_getBedSpawnPosition_3_, EntityPlayer p_getBedSpawnPosition_4_) {
        if (p_getBedSpawnPosition_2_ instanceof World) {
            return BlockBed.getSafeExitLocation((World)p_getBedSpawnPosition_2_, p_getBedSpawnPosition_3_, 0);
        }
        return null;
    }

    public void setBedOccupied(IBlockAccess p_setBedOccupied_1_, BlockPos p_setBedOccupied_2_, EntityPlayer p_setBedOccupied_3_, boolean p_setBedOccupied_4_) {
        if (p_setBedOccupied_1_ instanceof World) {
            IBlockState state = p_setBedOccupied_1_.getBlockState(p_setBedOccupied_2_);
            state = state.getBlock().getActualState(state, p_setBedOccupied_1_, p_setBedOccupied_2_);
            state = state.withProperty(BlockBed.OCCUPIED, p_setBedOccupied_4_);
            ((World)p_setBedOccupied_1_).setBlockState(p_setBedOccupied_2_, state, 4);
        }
    }

    public EnumFacing getBedDirection(IBlockState p_getBedDirection_1_, IBlockAccess p_getBedDirection_2_, BlockPos p_getBedDirection_3_) {
        return this.getActualState(p_getBedDirection_1_, p_getBedDirection_2_, p_getBedDirection_3_).getValue(BlockHorizontal.FACING);
    }

    public boolean isBedFoot(IBlockAccess p_isBedFoot_1_, BlockPos p_isBedFoot_2_) {
        return this.getActualState(p_isBedFoot_1_.getBlockState(p_isBedFoot_2_), p_isBedFoot_1_, p_isBedFoot_2_).getValue(BlockBed.PART) == BlockBed.EnumPartType.FOOT;
    }

    public void beginLeavesDecay(IBlockState p_beginLeavesDecay_1_, World p_beginLeavesDecay_2_, BlockPos p_beginLeavesDecay_3_) {
    }

    public boolean canSustainLeaves(IBlockState p_canSustainLeaves_1_, IBlockAccess p_canSustainLeaves_2_, BlockPos p_canSustainLeaves_3_) {
        return false;
    }

    public boolean isLeaves(IBlockState p_isLeaves_1_, IBlockAccess p_isLeaves_2_, BlockPos p_isLeaves_3_) {
        return p_isLeaves_1_.getMaterial() == Material.LEAVES;
    }

    public boolean canBeReplacedByLeaves(IBlockState p_canBeReplacedByLeaves_1_, IBlockAccess p_canBeReplacedByLeaves_2_, BlockPos p_canBeReplacedByLeaves_3_) {
        return this.isAir(p_canBeReplacedByLeaves_1_, p_canBeReplacedByLeaves_2_, p_canBeReplacedByLeaves_3_) || this.isLeaves(p_canBeReplacedByLeaves_1_, p_canBeReplacedByLeaves_2_, p_canBeReplacedByLeaves_3_);
    }

    public boolean isWood(IBlockAccess p_isWood_1_, BlockPos p_isWood_2_) {
        return false;
    }

    public boolean isReplaceableOreGen(IBlockState p_isReplaceableOreGen_1_, IBlockAccess p_isReplaceableOreGen_2_, BlockPos p_isReplaceableOreGen_3_, Predicate<IBlockState> p_isReplaceableOreGen_4_) {
        return p_isReplaceableOreGen_4_.apply((Object)p_isReplaceableOreGen_1_);
    }

    public float getExplosionResistance(World p_getExplosionResistance_1_, BlockPos p_getExplosionResistance_2_, Entity p_getExplosionResistance_3_, Explosion p_getExplosionResistance_4_) {
        return this.getExplosionResistance(p_getExplosionResistance_3_);
    }

    public void onBlockExploded(World p_onBlockExploded_1_, BlockPos p_onBlockExploded_2_, Explosion p_onBlockExploded_3_) {
        p_onBlockExploded_1_.setBlockToAir(p_onBlockExploded_2_);
        this.onBlockDestroyedByExplosion(p_onBlockExploded_1_, p_onBlockExploded_2_, p_onBlockExploded_3_);
    }

    public boolean canConnectRedstone(IBlockState p_canConnectRedstone_1_, IBlockAccess p_canConnectRedstone_2_, BlockPos p_canConnectRedstone_3_, EnumFacing p_canConnectRedstone_4_) {
        return p_canConnectRedstone_1_.canProvidePower() && p_canConnectRedstone_4_ != null;
    }

    public boolean canPlaceTorchOnTop(IBlockState p_canPlaceTorchOnTop_1_, IBlockAccess p_canPlaceTorchOnTop_2_, BlockPos p_canPlaceTorchOnTop_3_) {
        if (p_canPlaceTorchOnTop_1_.isSideSolid(p_canPlaceTorchOnTop_2_, p_canPlaceTorchOnTop_3_, EnumFacing.UP)) {
            return true;
        }
        return this instanceof BlockFence || this == Blocks.GLASS || this == Blocks.COBBLESTONE_WALL || this == Blocks.STAINED_GLASS;
    }

    public ItemStack getPickBlock(IBlockState p_getPickBlock_1_, RayTraceResult p_getPickBlock_2_, World p_getPickBlock_3_, BlockPos p_getPickBlock_4_, EntityPlayer p_getPickBlock_5_) {
        return this.getItem(p_getPickBlock_3_, p_getPickBlock_4_, p_getPickBlock_1_);
    }

    public boolean isFoliage(IBlockAccess p_isFoliage_1_, BlockPos p_isFoliage_2_) {
        return false;
    }

    public boolean addLandingEffects(IBlockState p_addLandingEffects_1_, WorldServer p_addLandingEffects_2_, BlockPos p_addLandingEffects_3_, IBlockState p_addLandingEffects_4_, EntityLivingBase p_addLandingEffects_5_, int p_addLandingEffects_6_) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState p_addHitEffects_1_, World p_addHitEffects_2_, RayTraceResult p_addHitEffects_3_, ParticleManager p_addHitEffects_4_) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World p_addDestroyEffects_1_, BlockPos p_addDestroyEffects_2_, ParticleManager p_addDestroyEffects_3_) {
        return false;
    }

    public boolean canSustainPlant(IBlockState p_canSustainPlant_1_, IBlockAccess p_canSustainPlant_2_, BlockPos p_canSustainPlant_3_, EnumFacing p_canSustainPlant_4_, IPlantable p_canSustainPlant_5_) {
        IBlockState plant = p_canSustainPlant_5_.getPlant(p_canSustainPlant_2_, p_canSustainPlant_3_.offset(p_canSustainPlant_4_));
        EnumPlantType plantType = p_canSustainPlant_5_.getPlantType(p_canSustainPlant_2_, p_canSustainPlant_3_.offset(p_canSustainPlant_4_));
        if (plant.getBlock() == Blocks.CACTUS) {
            return this == Blocks.CACTUS || this == Blocks.SAND;
        }
        if (plant.getBlock() == Blocks.REEDS && this == Blocks.REEDS) {
            return true;
        }
        if (p_canSustainPlant_5_ instanceof BlockBush && ((BlockBush)p_canSustainPlant_5_).canSustainBush(p_canSustainPlant_1_)) {
            return true;
        }
        switch (plantType) {
            case Desert: {
                return this == Blocks.SAND || this == Blocks.HARDENED_CLAY || this == Blocks.STAINED_HARDENED_CLAY;
            }
            case Nether: {
                return this == Blocks.SOUL_SAND;
            }
            case Crop: {
                return this == Blocks.FARMLAND;
            }
            case Cave: {
                return p_canSustainPlant_1_.isSideSolid(p_canSustainPlant_2_, p_canSustainPlant_3_, EnumFacing.UP);
            }
            case Plains: {
                return this == Blocks.GRASS || this == Blocks.DIRT || this == Blocks.FARMLAND;
            }
            case Water: {
                return p_canSustainPlant_1_.getMaterial() == Material.WATER && p_canSustainPlant_1_.getValue(BlockLiquid.LEVEL) == 0;
            }
            case Beach: {
                boolean isBeach = this == Blocks.GRASS || this == Blocks.DIRT || this == Blocks.SAND;
                boolean hasWater = p_canSustainPlant_2_.getBlockState(p_canSustainPlant_3_.east()).getMaterial() == Material.WATER || p_canSustainPlant_2_.getBlockState(p_canSustainPlant_3_.west()).getMaterial() == Material.WATER || p_canSustainPlant_2_.getBlockState(p_canSustainPlant_3_.north()).getMaterial() == Material.WATER || p_canSustainPlant_2_.getBlockState(p_canSustainPlant_3_.south()).getMaterial() == Material.WATER;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    public void onPlantGrow(IBlockState p_onPlantGrow_1_, World p_onPlantGrow_2_, BlockPos p_onPlantGrow_3_, BlockPos p_onPlantGrow_4_) {
        if (this == Blocks.GRASS || this == Blocks.FARMLAND) {
            p_onPlantGrow_2_.setBlockState(p_onPlantGrow_3_, Blocks.DIRT.getDefaultState(), 2);
        }
    }

    public boolean isFertile(World p_isFertile_1_, BlockPos p_isFertile_2_) {
        if (this == Blocks.FARMLAND) {
            return p_isFertile_1_.getBlockState(p_isFertile_2_).getValue(BlockFarmland.MOISTURE) > 0;
        }
        return false;
    }

    public int getLightOpacity(IBlockState p_getLightOpacity_1_, IBlockAccess p_getLightOpacity_2_, BlockPos p_getLightOpacity_3_) {
        return p_getLightOpacity_1_.getLightOpacity();
    }

    public boolean canEntityDestroy(IBlockState p_canEntityDestroy_1_, IBlockAccess p_canEntityDestroy_2_, BlockPos p_canEntityDestroy_3_, Entity p_canEntityDestroy_4_) {
        if (p_canEntityDestroy_4_ instanceof EntityDragon) {
            return this != Blocks.BARRIER && this != Blocks.OBSIDIAN && this != Blocks.END_STONE && this != Blocks.BEDROCK && this != Blocks.END_PORTAL && this != Blocks.END_PORTAL_FRAME && this != Blocks.COMMAND_BLOCK && this != Blocks.REPEATING_COMMAND_BLOCK && this != Blocks.CHAIN_COMMAND_BLOCK && this != Blocks.IRON_BARS && this != Blocks.END_GATEWAY;
        }
        if (p_canEntityDestroy_4_ instanceof EntityWither || p_canEntityDestroy_4_ instanceof EntityWitherSkull) {
            return EntityWither.canDestroyBlock(this);
        }
        return true;
    }

    public boolean isBeaconBase(IBlockAccess p_isBeaconBase_1_, BlockPos p_isBeaconBase_2_, BlockPos p_isBeaconBase_3_) {
        return this == Blocks.EMERALD_BLOCK || this == Blocks.GOLD_BLOCK || this == Blocks.DIAMOND_BLOCK || this == Blocks.IRON_BLOCK;
    }

    public boolean rotateBlock(World p_rotateBlock_1_, BlockPos p_rotateBlock_2_, EnumFacing p_rotateBlock_3_) {
        IBlockState state = p_rotateBlock_1_.getBlockState(p_rotateBlock_2_);
        for (IProperty prop : state.getProperties().keySet()) {
            if (!prop.getName().equals("facing") && !prop.getName().equals("rotation")) continue;
            p_rotateBlock_1_.setBlockState(p_rotateBlock_2_, state.cycleProperty(prop));
            return true;
        }
        return false;
    }

    @Nullable
    public EnumFacing[] getValidRotations(World p_getValidRotations_1_, BlockPos p_getValidRotations_2_) {
        IBlockState state = p_getValidRotations_1_.getBlockState(p_getValidRotations_2_);
        for (IProperty prop : state.getProperties().keySet()) {
            if (!prop.getName().equals("facing") || prop.getValueClass() != EnumFacing.class) continue;
            Collection<EnumFacing> values = prop.getAllowedValues();
            return values.toArray(new EnumFacing[values.size()]);
        }
        return null;
    }

    public float getEnchantPowerBonus(World p_getEnchantPowerBonus_1_, BlockPos p_getEnchantPowerBonus_2_) {
        return this == Blocks.BOOKSHELF ? 1.0f : 0.0f;
    }

    public boolean recolorBlock(World p_recolorBlock_1_, BlockPos p_recolorBlock_2_, EnumFacing p_recolorBlock_3_, EnumDyeColor p_recolorBlock_4_) {
        IBlockState state = p_recolorBlock_1_.getBlockState(p_recolorBlock_2_);
        for (IProperty prop : state.getProperties().keySet()) {
            EnumDyeColor current;
            if (!prop.getName().equals("color") || prop.getValueClass() != EnumDyeColor.class || (current = (EnumDyeColor)state.getValue(prop)) == p_recolorBlock_4_) continue;
            p_recolorBlock_1_.setBlockState(p_recolorBlock_2_, state.withProperty(prop, p_recolorBlock_4_));
            return true;
        }
        return false;
    }

    public int getExpDrop(IBlockState p_getExpDrop_1_, IBlockAccess p_getExpDrop_2_, BlockPos p_getExpDrop_3_, int p_getExpDrop_4_) {
        return 0;
    }

    public void onNeighborChange(IBlockAccess p_onNeighborChange_1_, BlockPos p_onNeighborChange_2_, BlockPos p_onNeighborChange_3_) {
    }

    public void observedNeighborChange(IBlockState p_observedNeighborChange_1_, World p_observedNeighborChange_2_, BlockPos p_observedNeighborChange_3_, Block p_observedNeighborChange_4_, BlockPos p_observedNeighborChange_5_) {
    }

    public boolean shouldCheckWeakPower(IBlockState p_shouldCheckWeakPower_1_, IBlockAccess p_shouldCheckWeakPower_2_, BlockPos p_shouldCheckWeakPower_3_, EnumFacing p_shouldCheckWeakPower_4_) {
        return p_shouldCheckWeakPower_1_.isNormalCube();
    }

    public boolean getWeakChanges(IBlockAccess p_getWeakChanges_1_, BlockPos p_getWeakChanges_2_) {
        return false;
    }

    public void setHarvestLevel(String p_setHarvestLevel_1_, int p_setHarvestLevel_2_) {
        UnmodifiableIterator itr = this.getBlockState().getValidStates().iterator();
        while (itr.hasNext()) {
            this.setHarvestLevel(p_setHarvestLevel_1_, p_setHarvestLevel_2_, (IBlockState)itr.next());
        }
    }

    public void setHarvestLevel(String p_setHarvestLevel_1_, int p_setHarvestLevel_2_, IBlockState p_setHarvestLevel_3_) {
        int idx = this.getMetaFromState(p_setHarvestLevel_3_);
        this.harvestTool[idx] = p_setHarvestLevel_1_;
        this.harvestLevel[idx] = p_setHarvestLevel_2_;
    }

    @Nullable
    public String getHarvestTool(IBlockState p_getHarvestTool_1_) {
        return this.harvestTool[this.getMetaFromState(p_getHarvestTool_1_)];
    }

    public int getHarvestLevel(IBlockState p_getHarvestLevel_1_) {
        return this.harvestLevel[this.getMetaFromState(p_getHarvestLevel_1_)];
    }

    public boolean isToolEffective(String p_isToolEffective_1_, IBlockState p_isToolEffective_2_) {
        if ("pickaxe".equals(p_isToolEffective_1_) && (this == Blocks.REDSTONE_ORE || this == Blocks.LIT_REDSTONE_ORE || this == Blocks.OBSIDIAN)) {
            return false;
        }
        return p_isToolEffective_1_ != null && p_isToolEffective_1_.equals(this.getHarvestTool(p_isToolEffective_2_));
    }

    public IBlockState getExtendedState(IBlockState p_getExtendedState_1_, IBlockAccess p_getExtendedState_2_, BlockPos p_getExtendedState_3_) {
        return p_getExtendedState_1_;
    }

    @Nullable
    public Boolean isEntityInsideMaterial(IBlockAccess p_isEntityInsideMaterial_1_, BlockPos p_isEntityInsideMaterial_2_, IBlockState p_isEntityInsideMaterial_3_, Entity p_isEntityInsideMaterial_4_, double p_isEntityInsideMaterial_5_, Material p_isEntityInsideMaterial_7_, boolean p_isEntityInsideMaterial_8_) {
        return null;
    }

    @Nullable
    public Boolean isAABBInsideMaterial(World p_isAABBInsideMaterial_1_, BlockPos p_isAABBInsideMaterial_2_, AxisAlignedBB p_isAABBInsideMaterial_3_, Material p_isAABBInsideMaterial_4_) {
        return null;
    }

    public boolean canRenderInLayer(IBlockState p_canRenderInLayer_1_, BlockRenderLayer p_canRenderInLayer_2_) {
        return this.getBlockLayer() == p_canRenderInLayer_2_;
    }

    protected List<ItemStack> captureDrops(boolean p_captureDrops_1_) {
        if (p_captureDrops_1_) {
            captureDrops.set(true);
            capturedDrops.get().clear();
            return Collections.emptyList();
        }
        captureDrops.set(false);
        return capturedDrops.get();
    }

    public SoundType getSoundType(IBlockState p_getSoundType_1_, World p_getSoundType_2_, BlockPos p_getSoundType_3_, Entity p_getSoundType_4_) {
        return this.getSoundType();
    }

    @Nullable
    public float[] getBeaconColorMultiplier(IBlockState p_getBeaconColorMultiplier_1_, World p_getBeaconColorMultiplier_2_, BlockPos p_getBeaconColorMultiplier_3_, BlockPos p_getBeaconColorMultiplier_4_) {
        return null;
    }

    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_, EnumHand p_getStateForPlacement_9_) {
        return this.getStateForPlacement(p_getStateForPlacement_1_, p_getStateForPlacement_2_, p_getStateForPlacement_3_, p_getStateForPlacement_4_, p_getStateForPlacement_5_, p_getStateForPlacement_6_, p_getStateForPlacement_7_, p_getStateForPlacement_8_);
    }

    public boolean canBeConnectedTo(IBlockAccess p_canBeConnectedTo_1_, BlockPos p_canBeConnectedTo_2_, EnumFacing p_canBeConnectedTo_3_) {
        return false;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState p_getAiPathNodeType_1_, IBlockAccess p_getAiPathNodeType_2_, BlockPos p_getAiPathNodeType_3_) {
        return this.isBurning(p_getAiPathNodeType_2_, p_getAiPathNodeType_3_) ? PathNodeType.DAMAGE_FIRE : null;
    }

    public static void registerBlocks() {
        Block.registerBlock(0, AIR_ID, new BlockAir().setUnlocalizedName("air"));
        Block.registerBlock(1, "stone", new BlockStone().setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("stone"));
        Block.registerBlock(2, "grass", new BlockGrass().setHardness(0.6f).setSoundType(SoundType.PLANT).setUnlocalizedName("grass"));
        Block.registerBlock(3, "dirt", new BlockDirt().setHardness(0.5f).setSoundType(SoundType.GROUND).setUnlocalizedName("dirt"));
        Block block = new Block(Material.ROCK).setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("stonebrick").setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
        Block.registerBlock(4, "cobblestone", block);
        Block block1 = new BlockPlanks().setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("wood");
        Block.registerBlock(5, "planks", block1);
        Block.registerBlock(6, "sapling", new BlockSapling().setHardness(0.0f).setSoundType(SoundType.PLANT).setUnlocalizedName("sapling"));
        Block.registerBlock(7, "bedrock", new BlockEmptyDrops(Material.ROCK).setBlockUnbreakable().setResistance(6000000.0f).setSoundType(SoundType.STONE).setUnlocalizedName("bedrock").disableStats().setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(8, "flowing_water", new BlockDynamicLiquid(Material.WATER).setHardness(100.0f).setLightOpacity(3).setUnlocalizedName("water").disableStats());
        Block.registerBlock(9, "water", new BlockStaticLiquid(Material.WATER).setHardness(100.0f).setLightOpacity(3).setUnlocalizedName("water").disableStats());
        Block.registerBlock(10, "flowing_lava", new BlockDynamicLiquid(Material.LAVA).setHardness(100.0f).setLightLevel(1.0f).setUnlocalizedName("lava").disableStats());
        Block.registerBlock(11, "lava", new BlockStaticLiquid(Material.LAVA).setHardness(100.0f).setLightLevel(1.0f).setUnlocalizedName("lava").disableStats());
        Block.registerBlock(12, "sand", new BlockSand().setHardness(0.5f).setSoundType(SoundType.SAND).setUnlocalizedName("sand"));
        Block.registerBlock(13, "gravel", new BlockGravel().setHardness(0.6f).setSoundType(SoundType.GROUND).setUnlocalizedName("gravel"));
        Block.registerBlock(14, "gold_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("oreGold"));
        Block.registerBlock(15, "iron_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("oreIron"));
        Block.registerBlock(16, "coal_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("oreCoal"));
        Block.registerBlock(17, "log", new BlockOldLog().setUnlocalizedName("log"));
        Block.registerBlock(18, "leaves", new BlockOldLeaf().setUnlocalizedName("leaves"));
        Block.registerBlock(19, "sponge", new BlockSponge().setHardness(0.6f).setSoundType(SoundType.PLANT).setUnlocalizedName("sponge"));
        Block.registerBlock(20, "glass", new BlockGlass(Material.GLASS, false).setHardness(0.3f).setSoundType(SoundType.GLASS).setUnlocalizedName("glass"));
        Block.registerBlock(21, "lapis_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("oreLapis"));
        Block.registerBlock(22, "lapis_block", new Block(Material.IRON, MapColor.LAPIS).setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("blockLapis").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(23, "dispenser", new BlockDispenser().setHardness(3.5f).setSoundType(SoundType.STONE).setUnlocalizedName("dispenser"));
        Block block2 = new BlockSandStone().setSoundType(SoundType.STONE).setHardness(0.8f).setUnlocalizedName("sandStone");
        Block.registerBlock(24, "sandstone", block2);
        Block.registerBlock(25, "noteblock", new BlockNote().setSoundType(SoundType.WOOD).setHardness(0.8f).setUnlocalizedName("musicBlock"));
        Block.registerBlock(26, "bed", new BlockBed().setSoundType(SoundType.WOOD).setHardness(0.2f).setUnlocalizedName("bed").disableStats());
        Block.registerBlock(27, "golden_rail", new BlockRailPowered().setHardness(0.7f).setSoundType(SoundType.METAL).setUnlocalizedName("goldenRail"));
        Block.registerBlock(28, "detector_rail", new BlockRailDetector().setHardness(0.7f).setSoundType(SoundType.METAL).setUnlocalizedName("detectorRail"));
        Block.registerBlock(29, "sticky_piston", new BlockPistonBase(true).setUnlocalizedName("pistonStickyBase"));
        Block.registerBlock(30, "web", new BlockWeb().setLightOpacity(1).setHardness(4.0f).setUnlocalizedName("web"));
        Block.registerBlock(31, "tallgrass", new BlockTallGrass().setHardness(0.0f).setSoundType(SoundType.PLANT).setUnlocalizedName("tallgrass"));
        Block.registerBlock(32, "deadbush", new BlockDeadBush().setHardness(0.0f).setSoundType(SoundType.PLANT).setUnlocalizedName("deadbush"));
        Block.registerBlock(33, "piston", new BlockPistonBase(false).setUnlocalizedName("pistonBase"));
        Block.registerBlock(34, "piston_head", new BlockPistonExtension().setUnlocalizedName("pistonBase"));
        Block.registerBlock(35, "wool", new BlockColored(Material.CLOTH).setHardness(0.8f).setSoundType(SoundType.CLOTH).setUnlocalizedName("cloth"));
        Block.registerBlock(36, "piston_extension", (Block)new BlockPistonMoving());
        Block.registerBlock(37, "yellow_flower", new BlockYellowFlower().setHardness(0.0f).setSoundType(SoundType.PLANT).setUnlocalizedName("flower1"));
        Block.registerBlock(38, "red_flower", new BlockRedFlower().setHardness(0.0f).setSoundType(SoundType.PLANT).setUnlocalizedName("flower2"));
        Block block3 = new BlockMushroom().setHardness(0.0f).setSoundType(SoundType.PLANT).setLightLevel(0.125f).setUnlocalizedName("mushroom");
        Block.registerBlock(39, "brown_mushroom", block3);
        Block block4 = new BlockMushroom().setHardness(0.0f).setSoundType(SoundType.PLANT).setUnlocalizedName("mushroom");
        Block.registerBlock(40, "red_mushroom", block4);
        Block.registerBlock(41, "gold_block", new Block(Material.IRON, MapColor.GOLD).setHardness(3.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setUnlocalizedName("blockGold").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(42, "iron_block", new Block(Material.IRON, MapColor.IRON).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setUnlocalizedName("blockIron").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(43, "double_stone_slab", new BlockDoubleStoneSlab().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("stoneSlab"));
        Block.registerBlock(44, "stone_slab", new BlockHalfStoneSlab().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("stoneSlab"));
        Block block5 = new Block(Material.ROCK, MapColor.RED).setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("brick").setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
        Block.registerBlock(45, "brick_block", block5);
        Block.registerBlock(46, "tnt", new BlockTNT().setHardness(0.0f).setSoundType(SoundType.PLANT).setUnlocalizedName("tnt"));
        Block.registerBlock(47, "bookshelf", new BlockBookshelf().setHardness(1.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("bookshelf"));
        Block.registerBlock(48, "mossy_cobblestone", new Block(Material.ROCK).setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("stoneMoss").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(49, "obsidian", new BlockObsidian().setHardness(50.0f).setResistance(2000.0f).setSoundType(SoundType.STONE).setUnlocalizedName("obsidian"));
        Block.registerBlock(50, "torch", new BlockTorch().setHardness(0.0f).setLightLevel(0.9375f).setSoundType(SoundType.WOOD).setUnlocalizedName("torch"));
        Block.registerBlock(51, "fire", new BlockFire().setHardness(0.0f).setLightLevel(1.0f).setSoundType(SoundType.CLOTH).setUnlocalizedName("fire").disableStats());
        Block.registerBlock(52, "mob_spawner", new BlockMobSpawner().setHardness(5.0f).setSoundType(SoundType.METAL).setUnlocalizedName("mobSpawner").disableStats());
        Block.registerBlock(53, "oak_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.OAK)).setUnlocalizedName("stairsWood"));
        Block.registerBlock(54, "chest", new BlockChest(BlockChest.Type.BASIC).setHardness(2.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("chest"));
        Block.registerBlock(55, "redstone_wire", new BlockRedstoneWire().setHardness(0.0f).setSoundType(SoundType.STONE).setUnlocalizedName("redstoneDust").disableStats());
        Block.registerBlock(56, "diamond_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("oreDiamond"));
        Block.registerBlock(57, "diamond_block", new Block(Material.IRON, MapColor.DIAMOND).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setUnlocalizedName("blockDiamond").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(58, "crafting_table", new BlockWorkbench().setHardness(2.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("workbench"));
        Block.registerBlock(59, "wheat", new BlockCrops().setUnlocalizedName("crops"));
        Block block6 = new BlockFarmland().setHardness(0.6f).setSoundType(SoundType.GROUND).setUnlocalizedName("farmland");
        Block.registerBlock(60, "farmland", block6);
        Block.registerBlock(61, "furnace", new BlockFurnace(false).setHardness(3.5f).setSoundType(SoundType.STONE).setUnlocalizedName("furnace").setCreativeTab(CreativeTabs.DECORATIONS));
        Block.registerBlock(62, "lit_furnace", new BlockFurnace(true).setHardness(3.5f).setSoundType(SoundType.STONE).setLightLevel(0.875f).setUnlocalizedName("furnace"));
        Block.registerBlock(63, "standing_sign", new BlockStandingSign().setHardness(1.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("sign").disableStats());
        Block.registerBlock(64, "wooden_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("doorOak").disableStats());
        Block.registerBlock(65, "ladder", new BlockLadder().setHardness(0.4f).setSoundType(SoundType.LADDER).setUnlocalizedName("ladder"));
        Block.registerBlock(66, "rail", new BlockRail().setHardness(0.7f).setSoundType(SoundType.METAL).setUnlocalizedName("rail"));
        Block.registerBlock(67, "stone_stairs", new BlockStairs(block.getDefaultState()).setUnlocalizedName("stairsStone"));
        Block.registerBlock(68, "wall_sign", new BlockWallSign().setHardness(1.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("sign").disableStats());
        Block.registerBlock(69, "lever", new BlockLever().setHardness(0.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("lever"));
        Block.registerBlock(70, "stone_pressure_plate", new BlockPressurePlate(Material.ROCK, BlockPressurePlate.Sensitivity.MOBS).setHardness(0.5f).setSoundType(SoundType.STONE).setUnlocalizedName("pressurePlateStone"));
        Block.registerBlock(71, "iron_door", new BlockDoor(Material.IRON).setHardness(5.0f).setSoundType(SoundType.METAL).setUnlocalizedName("doorIron").disableStats());
        Block.registerBlock(72, "wooden_pressure_plate", new BlockPressurePlate(Material.WOOD, BlockPressurePlate.Sensitivity.EVERYTHING).setHardness(0.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("pressurePlateWood"));
        Block.registerBlock(73, "redstone_ore", new BlockRedstoneOre(false).setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("oreRedstone").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(74, "lit_redstone_ore", new BlockRedstoneOre(true).setLightLevel(0.625f).setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("oreRedstone"));
        Block.registerBlock(75, "unlit_redstone_torch", new BlockRedstoneTorch(false).setHardness(0.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("notGate"));
        Block.registerBlock(76, "redstone_torch", new BlockRedstoneTorch(true).setHardness(0.0f).setLightLevel(0.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("notGate").setCreativeTab(CreativeTabs.REDSTONE));
        Block.registerBlock(77, "stone_button", new BlockButtonStone().setHardness(0.5f).setSoundType(SoundType.STONE).setUnlocalizedName("button"));
        Block.registerBlock(78, "snow_layer", new BlockSnow().setHardness(0.1f).setSoundType(SoundType.SNOW).setUnlocalizedName("snow").setLightOpacity(0));
        Block.registerBlock(79, "ice", new BlockIce().setHardness(0.5f).setLightOpacity(3).setSoundType(SoundType.GLASS).setUnlocalizedName("ice"));
        Block.registerBlock(80, "snow", new BlockSnowBlock().setHardness(0.2f).setSoundType(SoundType.SNOW).setUnlocalizedName("snow"));
        Block.registerBlock(81, "cactus", new BlockCactus().setHardness(0.4f).setSoundType(SoundType.CLOTH).setUnlocalizedName("cactus"));
        Block.registerBlock(82, "clay", new BlockClay().setHardness(0.6f).setSoundType(SoundType.GROUND).setUnlocalizedName("clay"));
        Block.registerBlock(83, "reeds", new BlockReed().setHardness(0.0f).setSoundType(SoundType.PLANT).setUnlocalizedName("reeds").disableStats());
        Block.registerBlock(84, "jukebox", new BlockJukebox().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("jukebox"));
        Block.registerBlock(85, "fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.OAK.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("fence"));
        Block block7 = new BlockPumpkin().setHardness(1.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("pumpkin");
        Block.registerBlock(86, "pumpkin", block7);
        Block.registerBlock(87, "netherrack", new BlockNetherrack().setHardness(0.4f).setSoundType(SoundType.STONE).setUnlocalizedName("hellrock"));
        Block.registerBlock(88, "soul_sand", new BlockSoulSand().setHardness(0.5f).setSoundType(SoundType.SAND).setUnlocalizedName("hellsand"));
        Block.registerBlock(89, "glowstone", new BlockGlowstone(Material.GLASS).setHardness(0.3f).setSoundType(SoundType.GLASS).setLightLevel(1.0f).setUnlocalizedName("lightgem"));
        Block.registerBlock(90, "portal", new BlockPortal().setHardness(-1.0f).setSoundType(SoundType.GLASS).setLightLevel(0.75f).setUnlocalizedName("portal"));
        Block.registerBlock(91, "lit_pumpkin", new BlockPumpkin().setHardness(1.0f).setSoundType(SoundType.WOOD).setLightLevel(1.0f).setUnlocalizedName("litpumpkin"));
        Block.registerBlock(92, "cake", new BlockCake().setHardness(0.5f).setSoundType(SoundType.CLOTH).setUnlocalizedName("cake").disableStats());
        Block.registerBlock(93, "unpowered_repeater", new BlockRedstoneRepeater(false).setHardness(0.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("diode").disableStats());
        Block.registerBlock(94, "powered_repeater", new BlockRedstoneRepeater(true).setHardness(0.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("diode").disableStats());
        Block.registerBlock(95, "stained_glass", new BlockStainedGlass(Material.GLASS).setHardness(0.3f).setSoundType(SoundType.GLASS).setUnlocalizedName("stainedGlass"));
        Block.registerBlock(96, "trapdoor", new BlockTrapDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("trapdoor").disableStats());
        Block.registerBlock(97, "monster_egg", new BlockSilverfish().setHardness(0.75f).setUnlocalizedName("monsterStoneEgg"));
        Block block8 = new BlockStoneBrick().setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("stonebricksmooth");
        Block.registerBlock(98, "stonebrick", block8);
        Block.registerBlock(99, "brown_mushroom_block", new BlockHugeMushroom(Material.WOOD, MapColor.DIRT, block3).setHardness(0.2f).setSoundType(SoundType.WOOD).setUnlocalizedName("mushroom"));
        Block.registerBlock(100, "red_mushroom_block", new BlockHugeMushroom(Material.WOOD, MapColor.RED, block4).setHardness(0.2f).setSoundType(SoundType.WOOD).setUnlocalizedName("mushroom"));
        Block.registerBlock(101, "iron_bars", new BlockPane(Material.IRON, true).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setUnlocalizedName("fenceIron"));
        Block.registerBlock(102, "glass_pane", new BlockPane(Material.GLASS, false).setHardness(0.3f).setSoundType(SoundType.GLASS).setUnlocalizedName("thinGlass"));
        Block block9 = new BlockMelon().setHardness(1.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("melon");
        Block.registerBlock(103, "melon_block", block9);
        Block.registerBlock(104, "pumpkin_stem", new BlockStem(block7).setHardness(0.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("pumpkinStem"));
        Block.registerBlock(105, "melon_stem", new BlockStem(block9).setHardness(0.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("pumpkinStem"));
        Block.registerBlock(106, "vine", new BlockVine().setHardness(0.2f).setSoundType(SoundType.PLANT).setUnlocalizedName("vine"));
        Block.registerBlock(107, "fence_gate", new BlockFenceGate(BlockPlanks.EnumType.OAK).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("fenceGate"));
        Block.registerBlock(108, "brick_stairs", new BlockStairs(block5.getDefaultState()).setUnlocalizedName("stairsBrick"));
        Block.registerBlock(109, "stone_brick_stairs", new BlockStairs(block8.getDefaultState().withProperty(BlockStoneBrick.VARIANT, BlockStoneBrick.EnumType.DEFAULT)).setUnlocalizedName("stairsStoneBrickSmooth"));
        Block.registerBlock(110, "mycelium", new BlockMycelium().setHardness(0.6f).setSoundType(SoundType.PLANT).setUnlocalizedName("mycel"));
        Block.registerBlock(111, "waterlily", new BlockLilyPad().setHardness(0.0f).setSoundType(SoundType.PLANT).setUnlocalizedName("waterlily"));
        Block block10 = new BlockNetherBrick().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("netherBrick").setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
        Block.registerBlock(112, "nether_brick", block10);
        Block.registerBlock(113, "nether_brick_fence", new BlockFence(Material.ROCK, MapColor.NETHERRACK).setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("netherFence"));
        Block.registerBlock(114, "nether_brick_stairs", new BlockStairs(block10.getDefaultState()).setUnlocalizedName("stairsNetherBrick"));
        Block.registerBlock(115, "nether_wart", new BlockNetherWart().setUnlocalizedName("netherStalk"));
        Block.registerBlock(116, "enchanting_table", new BlockEnchantmentTable().setHardness(5.0f).setResistance(2000.0f).setUnlocalizedName("enchantmentTable"));
        Block.registerBlock(117, "brewing_stand", new BlockBrewingStand().setHardness(0.5f).setLightLevel(0.125f).setUnlocalizedName("brewingStand"));
        Block.registerBlock(118, "cauldron", new BlockCauldron().setHardness(2.0f).setUnlocalizedName("cauldron"));
        Block.registerBlock(119, "end_portal", new BlockEndPortal(Material.PORTAL).setHardness(-1.0f).setResistance(6000000.0f));
        Block.registerBlock(120, "end_portal_frame", new BlockEndPortalFrame().setSoundType(SoundType.GLASS).setLightLevel(0.125f).setHardness(-1.0f).setUnlocalizedName("endPortalFrame").setResistance(6000000.0f).setCreativeTab(CreativeTabs.DECORATIONS));
        Block.registerBlock(121, "end_stone", new Block(Material.ROCK, MapColor.SAND).setHardness(3.0f).setResistance(15.0f).setSoundType(SoundType.STONE).setUnlocalizedName("whiteStone").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(122, "dragon_egg", new BlockDragonEgg().setHardness(3.0f).setResistance(15.0f).setSoundType(SoundType.STONE).setLightLevel(0.125f).setUnlocalizedName("dragonEgg"));
        Block.registerBlock(123, "redstone_lamp", new BlockRedstoneLight(false).setHardness(0.3f).setSoundType(SoundType.GLASS).setUnlocalizedName("redstoneLight").setCreativeTab(CreativeTabs.REDSTONE));
        Block.registerBlock(124, "lit_redstone_lamp", new BlockRedstoneLight(true).setHardness(0.3f).setSoundType(SoundType.GLASS).setUnlocalizedName("redstoneLight"));
        Block.registerBlock(125, "double_wooden_slab", new BlockDoubleWoodSlab().setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("woodSlab"));
        Block.registerBlock(126, "wooden_slab", new BlockHalfWoodSlab().setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("woodSlab"));
        Block.registerBlock(127, "cocoa", new BlockCocoa().setHardness(0.2f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("cocoa"));
        Block.registerBlock(128, "sandstone_stairs", new BlockStairs(block2.getDefaultState().withProperty(BlockSandStone.TYPE, BlockSandStone.EnumType.SMOOTH)).setUnlocalizedName("stairsSandStone"));
        Block.registerBlock(129, "emerald_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("oreEmerald"));
        Block.registerBlock(130, "ender_chest", new BlockEnderChest().setHardness(22.5f).setResistance(1000.0f).setSoundType(SoundType.STONE).setUnlocalizedName("enderChest").setLightLevel(0.5f));
        Block.registerBlock(131, "tripwire_hook", new BlockTripWireHook().setUnlocalizedName("tripWireSource"));
        Block.registerBlock(132, "tripwire", new BlockTripWire().setUnlocalizedName("tripWire"));
        Block.registerBlock(133, "emerald_block", new Block(Material.IRON, MapColor.EMERALD).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setUnlocalizedName("blockEmerald").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(134, "spruce_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.SPRUCE)).setUnlocalizedName("stairsWoodSpruce"));
        Block.registerBlock(135, "birch_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.BIRCH)).setUnlocalizedName("stairsWoodBirch"));
        Block.registerBlock(136, "jungle_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.JUNGLE)).setUnlocalizedName("stairsWoodJungle"));
        Block.registerBlock(137, "command_block", new BlockCommandBlock(MapColor.BROWN).setBlockUnbreakable().setResistance(6000000.0f).setUnlocalizedName("commandBlock"));
        Block.registerBlock(138, "beacon", new BlockBeacon().setUnlocalizedName("beacon").setLightLevel(1.0f));
        Block.registerBlock(139, "cobblestone_wall", new BlockWall(block).setUnlocalizedName("cobbleWall"));
        Block.registerBlock(140, "flower_pot", new BlockFlowerPot().setHardness(0.0f).setSoundType(SoundType.STONE).setUnlocalizedName("flowerPot"));
        Block.registerBlock(141, "carrots", new BlockCarrot().setUnlocalizedName("carrots"));
        Block.registerBlock(142, "potatoes", new BlockPotato().setUnlocalizedName("potatoes"));
        Block.registerBlock(143, "wooden_button", new BlockButtonWood().setHardness(0.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("button"));
        Block.registerBlock(144, "skull", new BlockSkull().setHardness(1.0f).setSoundType(SoundType.STONE).setUnlocalizedName("skull"));
        Block.registerBlock(145, "anvil", new BlockAnvil().setHardness(5.0f).setSoundType(SoundType.ANVIL).setResistance(2000.0f).setUnlocalizedName("anvil"));
        Block.registerBlock(146, "trapped_chest", new BlockChest(BlockChest.Type.TRAP).setHardness(2.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("chestTrap"));
        Block.registerBlock(147, "light_weighted_pressure_plate", new BlockPressurePlateWeighted(Material.IRON, 15, MapColor.GOLD).setHardness(0.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("weightedPlate_light"));
        Block.registerBlock(148, "heavy_weighted_pressure_plate", new BlockPressurePlateWeighted(Material.IRON, 150).setHardness(0.5f).setSoundType(SoundType.WOOD).setUnlocalizedName("weightedPlate_heavy"));
        Block.registerBlock(149, "unpowered_comparator", new BlockRedstoneComparator(false).setHardness(0.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("comparator").disableStats());
        Block.registerBlock(150, "powered_comparator", new BlockRedstoneComparator(true).setHardness(0.0f).setLightLevel(0.625f).setSoundType(SoundType.WOOD).setUnlocalizedName("comparator").disableStats());
        Block.registerBlock(151, "daylight_detector", (Block)new BlockDaylightDetector(false));
        Block.registerBlock(152, "redstone_block", new BlockCompressedPowered(Material.IRON, MapColor.TNT).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setUnlocalizedName("blockRedstone").setCreativeTab(CreativeTabs.REDSTONE));
        Block.registerBlock(153, "quartz_ore", new BlockOre(MapColor.NETHERRACK).setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setUnlocalizedName("netherquartz"));
        Block.registerBlock(154, "hopper", new BlockHopper().setHardness(3.0f).setResistance(8.0f).setSoundType(SoundType.METAL).setUnlocalizedName("hopper"));
        Block block11 = new BlockQuartz().setSoundType(SoundType.STONE).setHardness(0.8f).setUnlocalizedName("quartzBlock");
        Block.registerBlock(155, "quartz_block", block11);
        Block.registerBlock(156, "quartz_stairs", new BlockStairs(block11.getDefaultState().withProperty(BlockQuartz.VARIANT, BlockQuartz.EnumType.DEFAULT)).setUnlocalizedName("stairsQuartz"));
        Block.registerBlock(157, "activator_rail", new BlockRailPowered().setHardness(0.7f).setSoundType(SoundType.METAL).setUnlocalizedName("activatorRail"));
        Block.registerBlock(158, "dropper", new BlockDropper().setHardness(3.5f).setSoundType(SoundType.STONE).setUnlocalizedName("dropper"));
        Block.registerBlock(159, "stained_hardened_clay", new BlockColored(Material.ROCK).setHardness(1.25f).setResistance(7.0f).setSoundType(SoundType.STONE).setUnlocalizedName("clayHardenedStained"));
        Block.registerBlock(160, "stained_glass_pane", new BlockStainedGlassPane().setHardness(0.3f).setSoundType(SoundType.GLASS).setUnlocalizedName("thinStainedGlass"));
        Block.registerBlock(161, "leaves2", new BlockNewLeaf().setUnlocalizedName("leaves"));
        Block.registerBlock(162, "log2", new BlockNewLog().setUnlocalizedName("log"));
        Block.registerBlock(163, "acacia_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.ACACIA)).setUnlocalizedName("stairsWoodAcacia"));
        Block.registerBlock(164, "dark_oak_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.DARK_OAK)).setUnlocalizedName("stairsWoodDarkOak"));
        Block.registerBlock(165, "slime", new BlockSlime().setUnlocalizedName("slime").setSoundType(SoundType.SLIME));
        Block.registerBlock(166, "barrier", new BlockBarrier().setUnlocalizedName("barrier"));
        Block.registerBlock(167, "iron_trapdoor", new BlockTrapDoor(Material.IRON).setHardness(5.0f).setSoundType(SoundType.METAL).setUnlocalizedName("ironTrapdoor").disableStats());
        Block.registerBlock(168, "prismarine", new BlockPrismarine().setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("prismarine"));
        Block.registerBlock(169, "sea_lantern", new BlockSeaLantern(Material.GLASS).setHardness(0.3f).setSoundType(SoundType.GLASS).setLightLevel(1.0f).setUnlocalizedName("seaLantern"));
        Block.registerBlock(170, "hay_block", new BlockHay().setHardness(0.5f).setSoundType(SoundType.PLANT).setUnlocalizedName("hayBlock").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(171, "carpet", new BlockCarpet().setHardness(0.1f).setSoundType(SoundType.CLOTH).setUnlocalizedName("woolCarpet").setLightOpacity(0));
        Block.registerBlock(172, "hardened_clay", new BlockHardenedClay().setHardness(1.25f).setResistance(7.0f).setSoundType(SoundType.STONE).setUnlocalizedName("clayHardened"));
        Block.registerBlock(173, "coal_block", new Block(Material.ROCK, MapColor.BLACK).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("blockCoal").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(174, "packed_ice", new BlockPackedIce().setHardness(0.5f).setSoundType(SoundType.GLASS).setUnlocalizedName("icePacked"));
        Block.registerBlock(175, "double_plant", (Block)new BlockDoublePlant());
        Block.registerBlock(176, "standing_banner", new BlockBanner.BlockBannerStanding().setHardness(1.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("banner").disableStats());
        Block.registerBlock(177, "wall_banner", new BlockBanner.BlockBannerHanging().setHardness(1.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("banner").disableStats());
        Block.registerBlock(178, "daylight_detector_inverted", (Block)new BlockDaylightDetector(true));
        Block block12 = new BlockRedSandstone().setSoundType(SoundType.STONE).setHardness(0.8f).setUnlocalizedName("redSandStone");
        Block.registerBlock(179, "red_sandstone", block12);
        Block.registerBlock(180, "red_sandstone_stairs", new BlockStairs(block12.getDefaultState().withProperty(BlockRedSandstone.TYPE, BlockRedSandstone.EnumType.SMOOTH)).setUnlocalizedName("stairsRedSandStone"));
        Block.registerBlock(181, "double_stone_slab2", new BlockDoubleStoneSlabNew().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("stoneSlab2"));
        Block.registerBlock(182, "stone_slab2", new BlockHalfStoneSlabNew().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("stoneSlab2"));
        Block.registerBlock(183, "spruce_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.SPRUCE).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("spruceFenceGate"));
        Block.registerBlock(184, "birch_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.BIRCH).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("birchFenceGate"));
        Block.registerBlock(185, "jungle_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.JUNGLE).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("jungleFenceGate"));
        Block.registerBlock(186, "dark_oak_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.DARK_OAK).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("darkOakFenceGate"));
        Block.registerBlock(187, "acacia_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.ACACIA).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("acaciaFenceGate"));
        Block.registerBlock(188, "spruce_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.SPRUCE.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("spruceFence"));
        Block.registerBlock(189, "birch_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.BIRCH.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("birchFence"));
        Block.registerBlock(190, "jungle_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.JUNGLE.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("jungleFence"));
        Block.registerBlock(191, "dark_oak_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.DARK_OAK.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("darkOakFence"));
        Block.registerBlock(192, "acacia_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.ACACIA.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("acaciaFence"));
        Block.registerBlock(193, "spruce_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("doorSpruce").disableStats());
        Block.registerBlock(194, "birch_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("doorBirch").disableStats());
        Block.registerBlock(195, "jungle_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("doorJungle").disableStats());
        Block.registerBlock(196, "acacia_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("doorAcacia").disableStats());
        Block.registerBlock(197, "dark_oak_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("doorDarkOak").disableStats());
        Block.registerBlock(198, "end_rod", new BlockEndRod().setHardness(0.0f).setLightLevel(0.9375f).setSoundType(SoundType.WOOD).setUnlocalizedName("endRod"));
        Block.registerBlock(199, "chorus_plant", new BlockChorusPlant().setHardness(0.4f).setSoundType(SoundType.WOOD).setUnlocalizedName("chorusPlant"));
        Block.registerBlock(200, "chorus_flower", new BlockChorusFlower().setHardness(0.4f).setSoundType(SoundType.WOOD).setUnlocalizedName("chorusFlower"));
        Block block13 = new Block(Material.ROCK, MapColor.MAGENTA).setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setCreativeTab(CreativeTabs.BUILDING_BLOCKS).setUnlocalizedName("purpurBlock");
        Block.registerBlock(201, "purpur_block", block13);
        Block.registerBlock(202, "purpur_pillar", new BlockRotatedPillar(Material.ROCK, MapColor.MAGENTA).setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setCreativeTab(CreativeTabs.BUILDING_BLOCKS).setUnlocalizedName("purpurPillar"));
        Block.registerBlock(203, "purpur_stairs", new BlockStairs(block13.getDefaultState()).setUnlocalizedName("stairsPurpur"));
        Block.registerBlock(204, "purpur_double_slab", new BlockPurpurSlab.Double().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("purpurSlab"));
        Block.registerBlock(205, "purpur_slab", new BlockPurpurSlab.Half().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("purpurSlab"));
        Block.registerBlock(206, "end_bricks", new Block(Material.ROCK, MapColor.SAND).setSoundType(SoundType.STONE).setHardness(0.8f).setCreativeTab(CreativeTabs.BUILDING_BLOCKS).setUnlocalizedName("endBricks"));
        Block.registerBlock(207, "beetroots", new BlockBeetroot().setUnlocalizedName("beetroots"));
        Block block14 = new BlockGrassPath().setHardness(0.65f).setSoundType(SoundType.PLANT).setUnlocalizedName("grassPath").disableStats();
        Block.registerBlock(208, "grass_path", block14);
        Block.registerBlock(209, "end_gateway", new BlockEndGateway(Material.PORTAL).setHardness(-1.0f).setResistance(6000000.0f));
        Block.registerBlock(210, "repeating_command_block", new BlockCommandBlock(MapColor.PURPLE).setBlockUnbreakable().setResistance(6000000.0f).setUnlocalizedName("repeatingCommandBlock"));
        Block.registerBlock(211, "chain_command_block", new BlockCommandBlock(MapColor.GREEN).setBlockUnbreakable().setResistance(6000000.0f).setUnlocalizedName("chainCommandBlock"));
        Block.registerBlock(212, "frosted_ice", new BlockFrostedIce().setHardness(0.5f).setLightOpacity(3).setSoundType(SoundType.GLASS).setUnlocalizedName("frostedIce"));
        Block.registerBlock(213, "magma", new BlockMagma().setHardness(0.5f).setSoundType(SoundType.STONE).setUnlocalizedName("magma"));
        Block.registerBlock(214, "nether_wart_block", new Block(Material.GRASS, MapColor.RED).setCreativeTab(CreativeTabs.BUILDING_BLOCKS).setHardness(1.0f).setSoundType(SoundType.WOOD).setUnlocalizedName("netherWartBlock"));
        Block.registerBlock(215, "red_nether_brick", new BlockNetherBrick().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setUnlocalizedName("redNetherBrick").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(216, "bone_block", new BlockBone().setUnlocalizedName("boneBlock"));
        Block.registerBlock(217, "structure_void", new BlockStructureVoid().setUnlocalizedName("structureVoid"));
        Block.registerBlock(218, "observer", new BlockObserver().setHardness(3.0f).setUnlocalizedName("observer"));
        Block.registerBlock(219, "white_shulker_box", new BlockShulkerBox(EnumDyeColor.WHITE).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxWhite"));
        Block.registerBlock(220, "orange_shulker_box", new BlockShulkerBox(EnumDyeColor.ORANGE).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxOrange"));
        Block.registerBlock(221, "magenta_shulker_box", new BlockShulkerBox(EnumDyeColor.MAGENTA).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxMagenta"));
        Block.registerBlock(222, "light_blue_shulker_box", new BlockShulkerBox(EnumDyeColor.LIGHT_BLUE).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxLightBlue"));
        Block.registerBlock(223, "yellow_shulker_box", new BlockShulkerBox(EnumDyeColor.YELLOW).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxYellow"));
        Block.registerBlock(224, "lime_shulker_box", new BlockShulkerBox(EnumDyeColor.LIME).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxLime"));
        Block.registerBlock(225, "pink_shulker_box", new BlockShulkerBox(EnumDyeColor.PINK).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxPink"));
        Block.registerBlock(226, "gray_shulker_box", new BlockShulkerBox(EnumDyeColor.GRAY).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxGray"));
        Block.registerBlock(227, "silver_shulker_box", new BlockShulkerBox(EnumDyeColor.SILVER).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxSilver"));
        Block.registerBlock(228, "cyan_shulker_box", new BlockShulkerBox(EnumDyeColor.CYAN).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxCyan"));
        Block.registerBlock(229, "purple_shulker_box", new BlockShulkerBox(EnumDyeColor.PURPLE).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxPurple"));
        Block.registerBlock(230, "blue_shulker_box", new BlockShulkerBox(EnumDyeColor.BLUE).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxBlue"));
        Block.registerBlock(231, "brown_shulker_box", new BlockShulkerBox(EnumDyeColor.BROWN).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxBrown"));
        Block.registerBlock(232, "green_shulker_box", new BlockShulkerBox(EnumDyeColor.GREEN).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxGreen"));
        Block.registerBlock(233, "red_shulker_box", new BlockShulkerBox(EnumDyeColor.RED).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxRed"));
        Block.registerBlock(234, "black_shulker_box", new BlockShulkerBox(EnumDyeColor.BLACK).setHardness(2.0f).setSoundType(SoundType.STONE).setUnlocalizedName("shulkerBoxBlack"));
        Block.registerBlock(255, "structure_block", new BlockStructure().setBlockUnbreakable().setResistance(6000000.0f).setUnlocalizedName("structureBlock"));
        REGISTRY.validateKey();
        for (Block block15 : REGISTRY) {
            boolean flag5;
            if (block15.blockMaterial == Material.AIR) {
                block15.useNeighborBrightness = false;
                continue;
            }
            boolean flag = false;
            boolean flag1 = block15 instanceof BlockStairs;
            boolean flag2 = block15 instanceof BlockSlab;
            boolean flag3 = block15 == block6 || block15 == block14;
            boolean flag4 = block15.translucent;
            boolean bl = flag5 = block15.lightOpacity == 0;
            if (flag1 || flag2 || flag3 || flag4 || flag5) {
                flag = true;
            }
            block15.useNeighborBrightness = flag;
        }
        HashSet set = Sets.newHashSet((Object[])new Block[]{REGISTRY.getObject(new ResourceLocation("tripwire"))});
        for (Block block16 : REGISTRY) {
            if (!set.contains(block16)) continue;
            for (int i = 0; i < 15; ++i) {
                int j = REGISTRY.getIDForObject(block16) << 4 | i;
                BLOCK_STATE_IDS.put(block16.getStateFromMeta(i), j);
            }
        }
    }

    private static void registerBlock(int p_registerBlock_0_, ResourceLocation p_registerBlock_1_, Block p_registerBlock_2_) {
        REGISTRY.register(p_registerBlock_0_, p_registerBlock_1_, p_registerBlock_2_);
    }

    private static void registerBlock(int p_registerBlock_0_, String p_registerBlock_1_, Block p_registerBlock_2_) {
        Block.registerBlock(p_registerBlock_0_, new ResourceLocation(p_registerBlock_1_), p_registerBlock_2_);
    }

    public static enum EnumOffsetType {
        NONE,
        XZ,
        XYZ;

    }
}

