/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockAnvil
extends BlockFalling {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    public static final PropertyInteger DAMAGE = PropertyInteger.create("damage", 0, 2);
    protected static final AxisAlignedBB X_AXIS_AABB = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 1.0, 0.875);
    protected static final AxisAlignedBB Z_AXIS_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 1.0, 1.0);
    protected static final Logger LOGGER = LogManager.getLogger();

    protected BlockAnvil() {
        super(Material.ANVIL);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(DAMAGE, 0));
        this.setLightOpacity(0);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        EnumFacing lvt_9_1_ = p_getStateForPlacement_8_.getHorizontalFacing().rotateY();
        try {
            return super.getStateForPlacement(p_getStateForPlacement_1_, p_getStateForPlacement_2_, p_getStateForPlacement_3_, p_getStateForPlacement_4_, p_getStateForPlacement_5_, p_getStateForPlacement_6_, p_getStateForPlacement_7_, p_getStateForPlacement_8_).withProperty(FACING, lvt_9_1_).withProperty(DAMAGE, p_getStateForPlacement_7_ >> 2);
        }
        catch (IllegalArgumentException lvt_10_1_) {
            if (!p_getStateForPlacement_1_.isRemote) {
                LOGGER.warn(String.format("Invalid damage property for anvil at %s. Found %d, must be in [0, 1, 2]", p_getStateForPlacement_2_, p_getStateForPlacement_7_ >> 2));
                if (p_getStateForPlacement_8_ instanceof EntityPlayer) {
                    p_getStateForPlacement_8_.sendMessage(new TextComponentTranslation("Invalid damage property. Please pick in [0, 1, 2]", new Object[0]));
                }
            }
            return super.getStateForPlacement(p_getStateForPlacement_1_, p_getStateForPlacement_2_, p_getStateForPlacement_3_, p_getStateForPlacement_4_, p_getStateForPlacement_5_, p_getStateForPlacement_6_, 0, p_getStateForPlacement_8_).withProperty(FACING, lvt_9_1_).withProperty(DAMAGE, 0);
        }
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (!p_onBlockActivated_1_.isRemote) {
            p_onBlockActivated_4_.displayGui(new Anvil(p_onBlockActivated_1_, p_onBlockActivated_2_));
        }
        return true;
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(DAMAGE);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        EnumFacing lvt_4_1_ = p_getBoundingBox_1_.getValue(FACING);
        if (lvt_4_1_.getAxis() == EnumFacing.Axis.X) {
            return X_AXIS_AABB;
        }
        return Z_AXIS_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_));
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, 1));
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, 2));
    }

    @Override
    protected void onStartFalling(EntityFallingBlock p_onStartFalling_1_) {
        p_onStartFalling_1_.setHurtEntities(true);
    }

    @Override
    public void onEndFalling(World p_onEndFalling_1_, BlockPos p_onEndFalling_2_) {
        p_onEndFalling_1_.playEvent(1031, p_onEndFalling_2_, 0);
    }

    @Override
    public void onBroken(World p_onBroken_1_, BlockPos p_onBroken_2_) {
        p_onBroken_1_.playEvent(1029, p_onBroken_2_, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        return true;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getHorizontal(p_getStateFromMeta_1_ & 3)).withProperty(DAMAGE, (p_getStateFromMeta_1_ & 0xF) >> 2);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        lvt_2_1_ |= p_getMetaFromState_1_.getValue(FACING).getHorizontalIndex();
        return lvt_2_1_ |= p_getMetaFromState_1_.getValue(DAMAGE) << 2;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        if (p_withRotation_1_.getBlock() != this) {
            return p_withRotation_1_;
        }
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, DAMAGE);
    }

    public static class Anvil
    implements IInteractionObject {
        private final World world;
        private final BlockPos position;

        public Anvil(World p_i45741_1_, BlockPos p_i45741_2_) {
            this.world = p_i45741_1_;
            this.position = p_i45741_2_;
        }

        @Override
        public String getName() {
            return "anvil";
        }

        @Override
        public boolean hasCustomName() {
            return false;
        }

        @Override
        public ITextComponent getDisplayName() {
            return new TextComponentTranslation(Blocks.ANVIL.getUnlocalizedName() + ".name", new Object[0]);
        }

        @Override
        public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
            return new ContainerRepair(p_createContainer_1_, this.world, this.position, p_createContainer_2_);
        }

        @Override
        public String getGuiID() {
            return "minecraft:anvil";
        }
    }
}

