/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBanner
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    public static final PropertyInteger ROTATION = PropertyInteger.create("rotation", 0, 15);
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    protected BlockBanner() {
        super(Material.WOOD);
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal("item.banner.white.name");
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return true;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean canSpawnInBlock() {
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityBanner();
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.BANNER;
    }

    private ItemStack getTileDataItemStack(World p_getTileDataItemStack_1_, BlockPos p_getTileDataItemStack_2_) {
        TileEntity tileentity = p_getTileDataItemStack_1_.getTileEntity(p_getTileDataItemStack_2_);
        return tileentity instanceof TileEntityBanner ? ((TileEntityBanner)tileentity).getItem() : ItemStack.EMPTY;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        ItemStack itemstack = this.getTileDataItemStack(p_getItem_1_, p_getItem_2_);
        return itemstack.isEmpty() ? new ItemStack(Items.BANNER) : itemstack;
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_4_, p_dropBlockAsItemWithChance_5_);
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return !this.hasInvalidNeighbor(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) && super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_);
    }

    @Override
    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        if (p_harvestBlock_5_ instanceof TileEntityBanner) {
            TileEntityBanner tileentitybanner = (TileEntityBanner)p_harvestBlock_5_;
            ItemStack itemstack = tileentitybanner.getItem();
            BlockBanner.spawnAsEntity(p_harvestBlock_1_, p_harvestBlock_3_, itemstack);
        } else {
            super.harvestBlock(p_harvestBlock_1_, p_harvestBlock_2_, p_harvestBlock_3_, p_harvestBlock_4_, null, p_harvestBlock_6_);
        }
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess p_getDrops_1_, BlockPos p_getDrops_2_, IBlockState p_getDrops_3_, int p_getDrops_4_) {
        TileEntity te = p_getDrops_1_.getTileEntity(p_getDrops_2_);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (te instanceof TileEntityBanner) {
            TileEntityBanner tileentitybanner = (TileEntityBanner)te;
            ItemStack itemstack = tileentitybanner.getItem();
            ret.add(itemstack);
        } else {
            ret.add(new ItemStack(Items.BANNER, 1, 0));
        }
        return ret;
    }

    public static class BlockBannerStanding
    extends BlockBanner {
        public BlockBannerStanding() {
            this.setDefaultState(this.blockState.getBaseState().withProperty(ROTATION, 0));
        }

        @Override
        public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
            return STANDING_AABB;
        }

        @Override
        public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
            return p_withRotation_1_.withProperty(ROTATION, p_withRotation_2_.rotate(p_withRotation_1_.getValue(ROTATION), 16));
        }

        @Override
        public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
            return p_withMirror_1_.withProperty(ROTATION, p_withMirror_2_.mirrorRotation(p_withMirror_1_.getValue(ROTATION), 16));
        }

        @Override
        public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
            if (!p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.down()).getMaterial().isSolid()) {
                this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
                p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
            }
            super.neighborChanged(p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_4_, p_neighborChanged_5_);
        }

        @Override
        public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
            return this.getDefaultState().withProperty(ROTATION, p_getStateFromMeta_1_);
        }

        @Override
        public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
            return p_getMetaFromState_1_.getValue(ROTATION);
        }

        @Override
        protected BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)this, ROTATION);
        }
    }

    public static class BlockBannerHanging
    extends BlockBanner {
        protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 0.78125, 1.0);
        protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.78125, 0.125);
        protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 0.78125, 1.0);
        protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 0.78125, 1.0);

        public BlockBannerHanging() {
            this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH));
        }

        @Override
        public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
            return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
        }

        @Override
        public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
            return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
        }

        @Override
        public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
            switch (p_getBoundingBox_1_.getValue(FACING)) {
                default: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }

        @Override
        public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
            EnumFacing enumfacing = p_neighborChanged_1_.getValue(FACING);
            if (!p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.offset(enumfacing.getOpposite())).getMaterial().isSolid()) {
                this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
                p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
            }
            super.neighborChanged(p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_4_, p_neighborChanged_5_);
        }

        @Override
        public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
            EnumFacing enumfacing = EnumFacing.getFront(p_getStateFromMeta_1_);
            if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
                enumfacing = EnumFacing.NORTH;
            }
            return this.getDefaultState().withProperty(FACING, enumfacing);
        }

        @Override
        public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
            return p_getMetaFromState_1_.getValue(FACING).getIndex();
        }

        @Override
        protected BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)this, FACING);
        }
    }
}

