/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockBasePressurePlate
extends Block {
    protected static final AxisAlignedBB PRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.03125, 0.9375);
    protected static final AxisAlignedBB UNPRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);
    protected static final AxisAlignedBB PRESSURE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);

    protected BlockBasePressurePlate(Material p_i45740_1_) {
        this(p_i45740_1_, p_i45740_1_.getMaterialMapColor());
    }

    protected BlockBasePressurePlate(Material p_i46401_1_, MapColor p_i46401_2_) {
        super(p_i46401_1_, p_i46401_2_);
        this.setCreativeTab(CreativeTabs.REDSTONE);
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        boolean lvt_4_1_;
        boolean bl = lvt_4_1_ = this.getRedstoneStrength(p_getBoundingBox_1_) > 0;
        if (lvt_4_1_) {
            return PRESSED_AABB;
        }
        return UNPRESSED_AABB;
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 20;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return true;
    }

    @Override
    public boolean canSpawnInBlock() {
        return true;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return this.canBePlacedOn(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_.down());
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!this.canBePlacedOn(p_neighborChanged_2_, p_neighborChanged_3_.down())) {
            this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
        }
    }

    private boolean canBePlacedOn(World p_canBePlacedOn_1_, BlockPos p_canBePlacedOn_2_) {
        return p_canBePlacedOn_1_.getBlockState(p_canBePlacedOn_2_).isFullyOpaque() || p_canBePlacedOn_1_.getBlockState(p_canBePlacedOn_2_).getBlock() instanceof BlockFence;
    }

    @Override
    public void randomTick(World p_randomTick_1_, BlockPos p_randomTick_2_, IBlockState p_randomTick_3_, Random p_randomTick_4_) {
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (p_updateTick_1_.isRemote) {
            return;
        }
        int lvt_5_1_ = this.getRedstoneStrength(p_updateTick_3_);
        if (lvt_5_1_ > 0) {
            this.updateState(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, lvt_5_1_);
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        if (p_onEntityCollidedWithBlock_1_.isRemote) {
            return;
        }
        int lvt_5_1_ = this.getRedstoneStrength(p_onEntityCollidedWithBlock_3_);
        if (lvt_5_1_ == 0) {
            this.updateState(p_onEntityCollidedWithBlock_1_, p_onEntityCollidedWithBlock_2_, p_onEntityCollidedWithBlock_3_, lvt_5_1_);
        }
    }

    protected void updateState(World p_updateState_1_, BlockPos p_updateState_2_, IBlockState p_updateState_3_, int p_updateState_4_) {
        boolean lvt_7_1_;
        int lvt_5_1_ = this.computeRedstoneStrength(p_updateState_1_, p_updateState_2_);
        boolean lvt_6_1_ = p_updateState_4_ > 0;
        boolean bl = lvt_7_1_ = lvt_5_1_ > 0;
        if (p_updateState_4_ != lvt_5_1_) {
            p_updateState_3_ = this.setRedstoneStrength(p_updateState_3_, lvt_5_1_);
            p_updateState_1_.setBlockState(p_updateState_2_, p_updateState_3_, 2);
            this.updateNeighbors(p_updateState_1_, p_updateState_2_);
            p_updateState_1_.markBlockRangeForRenderUpdate(p_updateState_2_, p_updateState_2_);
        }
        if (!lvt_7_1_ && lvt_6_1_) {
            this.playClickOffSound(p_updateState_1_, p_updateState_2_);
        } else if (lvt_7_1_ && !lvt_6_1_) {
            this.playClickOnSound(p_updateState_1_, p_updateState_2_);
        }
        if (lvt_7_1_) {
            p_updateState_1_.scheduleUpdate(new BlockPos(p_updateState_2_), this, this.tickRate(p_updateState_1_));
        }
    }

    protected abstract void playClickOnSound(World var1, BlockPos var2);

    protected abstract void playClickOffSound(World var1, BlockPos var2);

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        if (this.getRedstoneStrength(p_breakBlock_3_) > 0) {
            this.updateNeighbors(p_breakBlock_1_, p_breakBlock_2_);
        }
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    protected void updateNeighbors(World p_updateNeighbors_1_, BlockPos p_updateNeighbors_2_) {
        p_updateNeighbors_1_.notifyNeighborsOfStateChange(p_updateNeighbors_2_, this, false);
        p_updateNeighbors_1_.notifyNeighborsOfStateChange(p_updateNeighbors_2_.down(), this, false);
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return this.getRedstoneStrength(p_getWeakPower_1_);
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        if (p_getStrongPower_4_ == EnumFacing.UP) {
            return this.getRedstoneStrength(p_getStrongPower_1_);
        }
        return 0;
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return true;
    }

    @Override
    public EnumPushReaction getMobilityFlag(IBlockState p_getMobilityFlag_1_) {
        return EnumPushReaction.DESTROY;
    }

    protected abstract int computeRedstoneStrength(World var1, BlockPos var2);

    protected abstract int getRedstoneStrength(IBlockState var1);

    protected abstract IBlockState setRedstoneStrength(IBlockState var1, int var2);
}

