/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBeacon
extends BlockContainer {
    public BlockBeacon() {
        super(Material.GLASS, MapColor.DIAMOND);
        this.setHardness(3.0f);
        this.setCreativeTab(CreativeTabs.MISC);
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityBeacon();
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        TileEntity lvt_10_1_ = p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_);
        if (lvt_10_1_ instanceof TileEntityBeacon) {
            p_onBlockActivated_4_.displayGUIChest((TileEntityBeacon)lvt_10_1_);
            p_onBlockActivated_4_.addStat(StatList.BEACON_INTERACTION);
        }
        return true;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        TileEntity lvt_6_1_;
        super.onBlockPlacedBy(p_onBlockPlacedBy_1_, p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_, p_onBlockPlacedBy_4_, p_onBlockPlacedBy_5_);
        if (p_onBlockPlacedBy_5_.hasDisplayName() && (lvt_6_1_ = p_onBlockPlacedBy_1_.getTileEntity(p_onBlockPlacedBy_2_)) instanceof TileEntityBeacon) {
            ((TileEntityBeacon)lvt_6_1_).setName(p_onBlockPlacedBy_5_.getDisplayName());
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        TileEntity lvt_6_1_ = p_neighborChanged_2_.getTileEntity(p_neighborChanged_3_);
        if (lvt_6_1_ instanceof TileEntityBeacon) {
            ((TileEntityBeacon)lvt_6_1_).updateBeacon();
            p_neighborChanged_2_.addBlockEvent(p_neighborChanged_3_, this, 1, 0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public static void updateColorAsync(final World p_updateColorAsync_0_, final BlockPos p_updateColorAsync_1_) {
        HttpUtil.DOWNLOADER_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                BlockPos lvt_3_1_;
                Chunk lvt_1_1_ = p_updateColorAsync_0_.getChunkFromBlockCoords(p_updateColorAsync_1_);
                for (int lvt_2_1_ = p_updateColorAsync_1_.getY() - 1; lvt_2_1_ >= 0 && lvt_1_1_.canSeeSky(lvt_3_1_ = new BlockPos(p_updateColorAsync_1_.getX(), lvt_2_1_, p_updateColorAsync_1_.getZ())); --lvt_2_1_) {
                    IBlockState lvt_4_1_ = p_updateColorAsync_0_.getBlockState(lvt_3_1_);
                    if (lvt_4_1_.getBlock() != Blocks.BEACON) continue;
                    ((WorldServer)p_updateColorAsync_0_).addScheduledTask(new Runnable(){

                        @Override
                        public void run() {
                            TileEntity lvt_1_1_ = p_updateColorAsync_0_.getTileEntity(lvt_3_1_);
                            if (lvt_1_1_ instanceof TileEntityBeacon) {
                                ((TileEntityBeacon)lvt_1_1_).updateBeacon();
                                p_updateColorAsync_0_.addBlockEvent(lvt_3_1_, Blocks.BEACON, 1, 0);
                            }
                        }
                    });
                }
            }
        });
    }
}

