/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBed
extends BlockHorizontal {
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.create("part", EnumPartType.class);
    public static final PropertyBool OCCUPIED = PropertyBool.create("occupied");
    protected static final AxisAlignedBB BED_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);

    public BlockBed() {
        super(Material.CLOTH);
        this.setDefaultState(this.blockState.getBaseState().withProperty(PART, EnumPartType.FOOT).withProperty(OCCUPIED, false));
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        EntityPlayer.SleepResult lvt_10_3_;
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        if (p_onBlockActivated_3_.getValue(PART) != EnumPartType.HEAD && (p_onBlockActivated_3_ = p_onBlockActivated_1_.getBlockState(p_onBlockActivated_2_ = p_onBlockActivated_2_.offset(p_onBlockActivated_3_.getValue(FACING)))).getBlock() != this) {
            return true;
        }
        if (!p_onBlockActivated_1_.provider.canRespawnHere() || p_onBlockActivated_1_.getBiome(p_onBlockActivated_2_) == Biomes.HELL) {
            p_onBlockActivated_1_.setBlockToAir(p_onBlockActivated_2_);
            BlockPos lvt_10_1_ = p_onBlockActivated_2_.offset(p_onBlockActivated_3_.getValue(FACING).getOpposite());
            if (p_onBlockActivated_1_.getBlockState(lvt_10_1_).getBlock() == this) {
                p_onBlockActivated_1_.setBlockToAir(lvt_10_1_);
            }
            p_onBlockActivated_1_.newExplosion(null, (double)p_onBlockActivated_2_.getX() + 0.5, (double)p_onBlockActivated_2_.getY() + 0.5, (double)p_onBlockActivated_2_.getZ() + 0.5, 5.0f, true, true);
            return true;
        }
        if (p_onBlockActivated_3_.getValue(OCCUPIED).booleanValue()) {
            EntityPlayer lvt_10_2_ = this.getPlayerInBed(p_onBlockActivated_1_, p_onBlockActivated_2_);
            if (lvt_10_2_ == null) {
                p_onBlockActivated_3_ = p_onBlockActivated_3_.withProperty(OCCUPIED, false);
                p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_, 4);
            } else {
                p_onBlockActivated_4_.sendStatusMessage(new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                return true;
            }
        }
        if ((lvt_10_3_ = p_onBlockActivated_4_.trySleep(p_onBlockActivated_2_)) == EntityPlayer.SleepResult.OK) {
            p_onBlockActivated_3_ = p_onBlockActivated_3_.withProperty(OCCUPIED, true);
            p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_, 4);
            return true;
        }
        if (lvt_10_3_ == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
            p_onBlockActivated_4_.sendStatusMessage(new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
        } else if (lvt_10_3_ == EntityPlayer.SleepResult.NOT_SAFE) {
            p_onBlockActivated_4_.sendStatusMessage(new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
        } else if (lvt_10_3_ == EntityPlayer.SleepResult.TOO_FAR_AWAY) {
            p_onBlockActivated_4_.sendStatusMessage(new TextComponentTranslation("tile.bed.tooFarAway", new Object[0]), true);
        }
        return true;
    }

    @Nullable
    private EntityPlayer getPlayerInBed(World p_getPlayerInBed_1_, BlockPos p_getPlayerInBed_2_) {
        for (EntityPlayer lvt_4_1_ : p_getPlayerInBed_1_.playerEntities) {
            if (!lvt_4_1_.isPlayerSleeping() || !lvt_4_1_.bedLocation.equals(p_getPlayerInBed_2_)) continue;
            return lvt_4_1_;
        }
        return null;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        EnumFacing lvt_6_1_ = p_neighborChanged_1_.getValue(FACING);
        if (p_neighborChanged_1_.getValue(PART) == EnumPartType.HEAD) {
            if (p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.offset(lvt_6_1_.getOpposite())).getBlock() != this) {
                p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
            }
        } else if (p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.offset(lvt_6_1_)).getBlock() != this) {
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
            if (!p_neighborChanged_2_.isRemote) {
                this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
            }
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        if (p_getItemDropped_1_.getValue(PART) == EnumPartType.HEAD) {
            return Items.AIR;
        }
        return Items.BED;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return BED_AABB;
    }

    @Nullable
    public static BlockPos getSafeExitLocation(World p_getSafeExitLocation_0_, BlockPos p_getSafeExitLocation_1_, int p_getSafeExitLocation_2_) {
        EnumFacing lvt_3_1_ = p_getSafeExitLocation_0_.getBlockState(p_getSafeExitLocation_1_).getValue(FACING);
        int lvt_4_1_ = p_getSafeExitLocation_1_.getX();
        int lvt_5_1_ = p_getSafeExitLocation_1_.getY();
        int lvt_6_1_ = p_getSafeExitLocation_1_.getZ();
        for (int lvt_7_1_ = 0; lvt_7_1_ <= 1; ++lvt_7_1_) {
            int lvt_8_1_ = lvt_4_1_ - lvt_3_1_.getFrontOffsetX() * lvt_7_1_ - 1;
            int lvt_9_1_ = lvt_6_1_ - lvt_3_1_.getFrontOffsetZ() * lvt_7_1_ - 1;
            int lvt_10_1_ = lvt_8_1_ + 2;
            int lvt_11_1_ = lvt_9_1_ + 2;
            for (int lvt_12_1_ = lvt_8_1_; lvt_12_1_ <= lvt_10_1_; ++lvt_12_1_) {
                for (int lvt_13_1_ = lvt_9_1_; lvt_13_1_ <= lvt_11_1_; ++lvt_13_1_) {
                    BlockPos lvt_14_1_ = new BlockPos(lvt_12_1_, lvt_5_1_, lvt_13_1_);
                    if (!BlockBed.hasRoomForPlayer(p_getSafeExitLocation_0_, lvt_14_1_)) continue;
                    if (p_getSafeExitLocation_2_ > 0) {
                        --p_getSafeExitLocation_2_;
                        continue;
                    }
                    return lvt_14_1_;
                }
            }
        }
        return null;
    }

    protected static boolean hasRoomForPlayer(World p_hasRoomForPlayer_0_, BlockPos p_hasRoomForPlayer_1_) {
        return p_hasRoomForPlayer_0_.getBlockState(p_hasRoomForPlayer_1_.down()).isFullyOpaque() && !p_hasRoomForPlayer_0_.getBlockState(p_hasRoomForPlayer_1_).getMaterial().isSolid() && !p_hasRoomForPlayer_0_.getBlockState(p_hasRoomForPlayer_1_.up()).getMaterial().isSolid();
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        if (p_dropBlockAsItemWithChance_3_.getValue(PART) == EnumPartType.FOOT) {
            super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_4_, 0);
        }
    }

    @Override
    public EnumPushReaction getMobilityFlag(IBlockState p_getMobilityFlag_1_) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.BED);
    }

    @Override
    public void onBlockHarvested(World p_onBlockHarvested_1_, BlockPos p_onBlockHarvested_2_, IBlockState p_onBlockHarvested_3_, EntityPlayer p_onBlockHarvested_4_) {
        BlockPos lvt_5_1_;
        if (p_onBlockHarvested_4_.capabilities.isCreativeMode && p_onBlockHarvested_3_.getValue(PART) == EnumPartType.HEAD && p_onBlockHarvested_1_.getBlockState(lvt_5_1_ = p_onBlockHarvested_2_.offset(p_onBlockHarvested_3_.getValue(FACING).getOpposite())).getBlock() == this) {
            p_onBlockHarvested_1_.setBlockToAir(lvt_5_1_);
        }
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        EnumFacing lvt_2_1_ = EnumFacing.getHorizontal(p_getStateFromMeta_1_);
        if ((p_getStateFromMeta_1_ & 8) > 0) {
            return this.getDefaultState().withProperty(PART, EnumPartType.HEAD).withProperty(FACING, lvt_2_1_).withProperty(OCCUPIED, (p_getStateFromMeta_1_ & 4) > 0);
        }
        return this.getDefaultState().withProperty(PART, EnumPartType.FOOT).withProperty(FACING, lvt_2_1_);
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        IBlockState lvt_4_1_;
        if (p_getActualState_1_.getValue(PART) == EnumPartType.FOOT && (lvt_4_1_ = p_getActualState_2_.getBlockState(p_getActualState_3_.offset(p_getActualState_1_.getValue(FACING)))).getBlock() == this) {
            p_getActualState_1_ = p_getActualState_1_.withProperty(OCCUPIED, lvt_4_1_.getValue(OCCUPIED));
        }
        return p_getActualState_1_;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        lvt_2_1_ |= p_getMetaFromState_1_.getValue(FACING).getHorizontalIndex();
        if (p_getMetaFromState_1_.getValue(PART) == EnumPartType.HEAD) {
            lvt_2_1_ |= 8;
            if (p_getMetaFromState_1_.getValue(OCCUPIED).booleanValue()) {
                lvt_2_1_ |= 4;
            }
        }
        return lvt_2_1_;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, PART, OCCUPIED);
    }

    public static enum EnumPartType implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private EnumPartType(String p_i45735_3_) {
            this.name = p_i45735_3_;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

