/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBrewingStand
extends BlockContainer {
    public static final PropertyBool[] HAS_BOTTLE = new PropertyBool[]{PropertyBool.create("has_bottle_0"), PropertyBool.create("has_bottle_1"), PropertyBool.create("has_bottle_2")};
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    protected static final AxisAlignedBB STICK_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 0.875, 0.5625);

    public BlockBrewingStand() {
        super(Material.IRON);
        this.setDefaultState(this.blockState.getBaseState().withProperty(HAS_BOTTLE[0], false).withProperty(HAS_BOTTLE[1], false).withProperty(HAS_BOTTLE[2], false));
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal("item.brewingStand.name");
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityBrewingStand();
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        BlockBrewingStand.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, STICK_AABB);
        BlockBrewingStand.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, BASE_AABB);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return BASE_AABB;
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        TileEntity lvt_10_1_ = p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_);
        if (lvt_10_1_ instanceof TileEntityBrewingStand) {
            p_onBlockActivated_4_.displayGUIChest((TileEntityBrewingStand)lvt_10_1_);
            p_onBlockActivated_4_.addStat(StatList.BREWINGSTAND_INTERACTION);
        }
        return true;
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        TileEntity lvt_6_1_;
        if (p_onBlockPlacedBy_5_.hasDisplayName() && (lvt_6_1_ = p_onBlockPlacedBy_1_.getTileEntity(p_onBlockPlacedBy_2_)) instanceof TileEntityBrewingStand) {
            ((TileEntityBrewingStand)lvt_6_1_).setName(p_onBlockPlacedBy_5_.getDisplayName());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        double lvt_5_1_ = (float)p_randomDisplayTick_3_.getX() + 0.4f + p_randomDisplayTick_4_.nextFloat() * 0.2f;
        double lvt_7_1_ = (float)p_randomDisplayTick_3_.getY() + 0.7f + p_randomDisplayTick_4_.nextFloat() * 0.3f;
        double lvt_9_1_ = (float)p_randomDisplayTick_3_.getZ() + 0.4f + p_randomDisplayTick_4_.nextFloat() * 0.2f;
        p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, lvt_5_1_, lvt_7_1_, lvt_9_1_, 0.0, 0.0, 0.0, new int[0]);
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        TileEntity lvt_4_1_ = p_breakBlock_1_.getTileEntity(p_breakBlock_2_);
        if (lvt_4_1_ instanceof TileEntityBrewingStand) {
            InventoryHelper.dropInventoryItems(p_breakBlock_1_, p_breakBlock_2_, (IInventory)((TileEntityBrewingStand)lvt_4_1_));
        }
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.BREWING_STAND;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.BREWING_STAND);
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        return Container.calcRedstone(p_getComparatorInputOverride_2_.getTileEntity(p_getComparatorInputOverride_3_));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        IBlockState lvt_2_1_ = this.getDefaultState();
        for (int lvt_3_1_ = 0; lvt_3_1_ < 3; ++lvt_3_1_) {
            lvt_2_1_ = lvt_2_1_.withProperty(HAS_BOTTLE[lvt_3_1_], (p_getStateFromMeta_1_ & 1 << lvt_3_1_) > 0);
        }
        return lvt_2_1_;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        for (int lvt_3_1_ = 0; lvt_3_1_ < 3; ++lvt_3_1_) {
            if (!p_getMetaFromState_1_.getValue(HAS_BOTTLE[lvt_3_1_]).booleanValue()) continue;
            lvt_2_1_ |= 1 << lvt_3_1_;
        }
        return lvt_2_1_;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, HAS_BOTTLE[0], HAS_BOTTLE[1], HAS_BOTTLE[2]);
    }
}

