/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBush
extends Block
implements IPlantable {
    protected static final AxisAlignedBB BUSH_AABB = new AxisAlignedBB(0.3f, 0.0, 0.3f, 0.7f, 0.6f, 0.7f);

    protected BlockBush() {
        this(Material.PLANTS);
    }

    protected BlockBush(Material p_i45395_1_) {
        this(p_i45395_1_, p_i45395_1_.getMaterialMapColor());
    }

    protected BlockBush(Material p_i46452_1_, MapColor p_i46452_2_) {
        super(p_i46452_1_, p_i46452_2_);
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        IBlockState soil = p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down());
        return super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) && soil.getBlock().canSustainPlant(soil, p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_.down(), EnumFacing.UP, this);
    }

    protected boolean canSustainBush(IBlockState p_canSustainBush_1_) {
        return p_canSustainBush_1_.getBlock() == Blocks.GRASS || p_canSustainBush_1_.getBlock() == Blocks.DIRT || p_canSustainBush_1_.getBlock() == Blocks.FARMLAND;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        super.neighborChanged(p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_4_, p_neighborChanged_5_);
        this.checkAndDropBlock(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        this.checkAndDropBlock(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_);
    }

    protected void checkAndDropBlock(World p_checkAndDropBlock_1_, BlockPos p_checkAndDropBlock_2_, IBlockState p_checkAndDropBlock_3_) {
        if (!this.canBlockStay(p_checkAndDropBlock_1_, p_checkAndDropBlock_2_, p_checkAndDropBlock_3_)) {
            this.dropBlockAsItem(p_checkAndDropBlock_1_, p_checkAndDropBlock_2_, p_checkAndDropBlock_3_, 0);
            p_checkAndDropBlock_1_.setBlockState(p_checkAndDropBlock_2_, Blocks.AIR.getDefaultState(), 3);
        }
    }

    public boolean canBlockStay(World p_canBlockStay_1_, BlockPos p_canBlockStay_2_, IBlockState p_canBlockStay_3_) {
        if (p_canBlockStay_3_.getBlock() == this) {
            IBlockState soil = p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.down());
            return soil.getBlock().canSustainPlant(soil, p_canBlockStay_1_, p_canBlockStay_2_.down(), EnumFacing.UP, this);
        }
        return this.canSustainBush(p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.down()));
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return BUSH_AABB;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public EnumPlantType getPlantType(IBlockAccess p_getPlantType_1_, BlockPos p_getPlantType_2_) {
        if (this == Blocks.WHEAT) {
            return EnumPlantType.Crop;
        }
        if (this == Blocks.CARROTS) {
            return EnumPlantType.Crop;
        }
        if (this == Blocks.POTATOES) {
            return EnumPlantType.Crop;
        }
        if (this == Blocks.MELON_STEM) {
            return EnumPlantType.Crop;
        }
        if (this == Blocks.PUMPKIN_STEM) {
            return EnumPlantType.Crop;
        }
        if (this == Blocks.DEADBUSH) {
            return EnumPlantType.Desert;
        }
        if (this == Blocks.WATERLILY) {
            return EnumPlantType.Water;
        }
        if (this == Blocks.RED_MUSHROOM) {
            return EnumPlantType.Cave;
        }
        if (this == Blocks.BROWN_MUSHROOM) {
            return EnumPlantType.Cave;
        }
        if (this == Blocks.NETHER_WART) {
            return EnumPlantType.Nether;
        }
        if (this == Blocks.SAPLING) {
            return EnumPlantType.Plains;
        }
        if (this == Blocks.TALLGRASS) {
            return EnumPlantType.Plains;
        }
        if (this == Blocks.DOUBLE_PLANT) {
            return EnumPlantType.Plains;
        }
        if (this == Blocks.RED_FLOWER) {
            return EnumPlantType.Plains;
        }
        if (this == Blocks.YELLOW_FLOWER) {
            return EnumPlantType.Plains;
        }
        return EnumPlantType.Plains;
    }

    @Override
    public IBlockState getPlant(IBlockAccess p_getPlant_1_, BlockPos p_getPlant_2_) {
        IBlockState state = p_getPlant_1_.getBlockState(p_getPlant_2_);
        if (state.getBlock() != this) {
            return this.getDefaultState();
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }
}

