/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockButton
extends BlockDirectional {
    public static final PropertyBool POWERED = PropertyBool.create("powered");
    protected static final AxisAlignedBB AABB_DOWN_OFF = new AxisAlignedBB(0.3125, 0.875, 0.375, 0.6875, 1.0, 0.625);
    protected static final AxisAlignedBB AABB_UP_OFF = new AxisAlignedBB(0.3125, 0.0, 0.375, 0.6875, 0.125, 0.625);
    protected static final AxisAlignedBB AABB_NORTH_OFF = new AxisAlignedBB(0.3125, 0.375, 0.875, 0.6875, 0.625, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH_OFF = new AxisAlignedBB(0.3125, 0.375, 0.0, 0.6875, 0.625, 0.125);
    protected static final AxisAlignedBB AABB_WEST_OFF = new AxisAlignedBB(0.875, 0.375, 0.3125, 1.0, 0.625, 0.6875);
    protected static final AxisAlignedBB AABB_EAST_OFF = new AxisAlignedBB(0.0, 0.375, 0.3125, 0.125, 0.625, 0.6875);
    protected static final AxisAlignedBB AABB_DOWN_ON = new AxisAlignedBB(0.3125, 0.9375, 0.375, 0.6875, 1.0, 0.625);
    protected static final AxisAlignedBB AABB_UP_ON = new AxisAlignedBB(0.3125, 0.0, 0.375, 0.6875, 0.0625, 0.625);
    protected static final AxisAlignedBB AABB_NORTH_ON = new AxisAlignedBB(0.3125, 0.375, 0.9375, 0.6875, 0.625, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH_ON = new AxisAlignedBB(0.3125, 0.375, 0.0, 0.6875, 0.625, 0.0625);
    protected static final AxisAlignedBB AABB_WEST_ON = new AxisAlignedBB(0.9375, 0.375, 0.3125, 1.0, 0.625, 0.6875);
    protected static final AxisAlignedBB AABB_EAST_ON = new AxisAlignedBB(0.0, 0.375, 0.3125, 0.0625, 0.625, 0.6875);
    private final boolean wooden;

    protected BlockButton(boolean p_i45396_1_) {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(POWERED, false));
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.REDSTONE);
        this.wooden = p_i45396_1_;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return this.wooden ? 30 : 20;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_) {
        return BlockButton.canPlaceBlock(p_canPlaceBlockOnSide_1_, p_canPlaceBlockOnSide_2_, p_canPlaceBlockOnSide_3_.getOpposite());
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockButton.canPlaceBlock(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World p_canPlaceBlock_0_, BlockPos p_canPlaceBlock_1_, EnumFacing p_canPlaceBlock_2_) {
        BlockPos blockpos = p_canPlaceBlock_1_.offset(p_canPlaceBlock_2_);
        return p_canPlaceBlock_0_.getBlockState(blockpos).isSideSolid(p_canPlaceBlock_0_, blockpos, p_canPlaceBlock_2_.getOpposite());
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return BlockButton.canPlaceBlock(p_getStateForPlacement_1_, p_getStateForPlacement_2_, p_getStateForPlacement_3_.getOpposite()) ? this.getDefaultState().withProperty(FACING, p_getStateForPlacement_3_).withProperty(POWERED, false) : this.getDefaultState().withProperty(FACING, EnumFacing.DOWN).withProperty(POWERED, false);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (this.checkForDrop(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_) && !BlockButton.canPlaceBlock(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_.getValue(FACING).getOpposite())) {
            this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
        }
    }

    private boolean checkForDrop(World p_checkForDrop_1_, BlockPos p_checkForDrop_2_, IBlockState p_checkForDrop_3_) {
        if (this.canPlaceBlockAt(p_checkForDrop_1_, p_checkForDrop_2_)) {
            return true;
        }
        this.dropBlockAsItem(p_checkForDrop_1_, p_checkForDrop_2_, p_checkForDrop_3_, 0);
        p_checkForDrop_1_.setBlockToAir(p_checkForDrop_2_);
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        EnumFacing enumfacing = p_getBoundingBox_1_.getValue(FACING);
        boolean flag = p_getBoundingBox_1_.getValue(POWERED);
        switch (enumfacing) {
            case EAST: {
                return flag ? AABB_EAST_ON : AABB_EAST_OFF;
            }
            case WEST: {
                return flag ? AABB_WEST_ON : AABB_WEST_OFF;
            }
            case SOUTH: {
                return flag ? AABB_SOUTH_ON : AABB_SOUTH_OFF;
            }
            default: {
                return flag ? AABB_NORTH_ON : AABB_NORTH_OFF;
            }
            case UP: {
                return flag ? AABB_UP_ON : AABB_UP_OFF;
            }
            case DOWN: 
        }
        return flag ? AABB_DOWN_ON : AABB_DOWN_OFF;
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_3_.getValue(POWERED).booleanValue()) {
            return true;
        }
        p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_.withProperty(POWERED, true), 3);
        p_onBlockActivated_1_.markBlockRangeForRenderUpdate(p_onBlockActivated_2_, p_onBlockActivated_2_);
        this.playClickSound(p_onBlockActivated_4_, p_onBlockActivated_1_, p_onBlockActivated_2_);
        this.notifyNeighbors(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_.getValue(FACING));
        p_onBlockActivated_1_.scheduleUpdate(p_onBlockActivated_2_, this, this.tickRate(p_onBlockActivated_1_));
        return true;
    }

    protected abstract void playClickSound(EntityPlayer var1, World var2, BlockPos var3);

    protected abstract void playReleaseSound(World var1, BlockPos var2);

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        if (p_breakBlock_3_.getValue(POWERED).booleanValue()) {
            this.notifyNeighbors(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_.getValue(FACING));
        }
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return p_getWeakPower_1_.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return p_getStrongPower_1_.getValue(POWERED) == false ? 0 : (p_getStrongPower_1_.getValue(FACING) == p_getStrongPower_4_ ? 15 : 0);
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return true;
    }

    @Override
    public void randomTick(World p_randomTick_1_, BlockPos p_randomTick_2_, IBlockState p_randomTick_3_, Random p_randomTick_4_) {
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!p_updateTick_1_.isRemote && p_updateTick_3_.getValue(POWERED).booleanValue()) {
            if (this.wooden) {
                this.checkPressed(p_updateTick_3_, p_updateTick_1_, p_updateTick_2_);
            } else {
                p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(POWERED, false));
                this.notifyNeighbors(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_.getValue(FACING));
                this.playReleaseSound(p_updateTick_1_, p_updateTick_2_);
                p_updateTick_1_.markBlockRangeForRenderUpdate(p_updateTick_2_, p_updateTick_2_);
            }
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        if (!p_onEntityCollidedWithBlock_1_.isRemote && this.wooden && !p_onEntityCollidedWithBlock_3_.getValue(POWERED).booleanValue()) {
            this.checkPressed(p_onEntityCollidedWithBlock_3_, p_onEntityCollidedWithBlock_1_, p_onEntityCollidedWithBlock_2_);
        }
    }

    private void checkPressed(IBlockState p_checkPressed_1_, World p_checkPressed_2_, BlockPos p_checkPressed_3_) {
        List<EntityArrow> list = p_checkPressed_2_.getEntitiesWithinAABB(EntityArrow.class, p_checkPressed_1_.getBoundingBox(p_checkPressed_2_, p_checkPressed_3_).offset(p_checkPressed_3_));
        boolean flag = !list.isEmpty();
        boolean flag1 = p_checkPressed_1_.getValue(POWERED);
        if (flag && !flag1) {
            p_checkPressed_2_.setBlockState(p_checkPressed_3_, p_checkPressed_1_.withProperty(POWERED, true));
            this.notifyNeighbors(p_checkPressed_2_, p_checkPressed_3_, p_checkPressed_1_.getValue(FACING));
            p_checkPressed_2_.markBlockRangeForRenderUpdate(p_checkPressed_3_, p_checkPressed_3_);
            this.playClickSound(null, p_checkPressed_2_, p_checkPressed_3_);
        }
        if (!flag && flag1) {
            p_checkPressed_2_.setBlockState(p_checkPressed_3_, p_checkPressed_1_.withProperty(POWERED, false));
            this.notifyNeighbors(p_checkPressed_2_, p_checkPressed_3_, p_checkPressed_1_.getValue(FACING));
            p_checkPressed_2_.markBlockRangeForRenderUpdate(p_checkPressed_3_, p_checkPressed_3_);
            this.playReleaseSound(p_checkPressed_2_, p_checkPressed_3_);
        }
        if (flag) {
            p_checkPressed_2_.scheduleUpdate(new BlockPos(p_checkPressed_3_), this, this.tickRate(p_checkPressed_2_));
        }
    }

    private void notifyNeighbors(World p_notifyNeighbors_1_, BlockPos p_notifyNeighbors_2_, EnumFacing p_notifyNeighbors_3_) {
        p_notifyNeighbors_1_.notifyNeighborsOfStateChange(p_notifyNeighbors_2_, this, false);
        p_notifyNeighbors_1_.notifyNeighborsOfStateChange(p_notifyNeighbors_2_.offset(p_notifyNeighbors_3_.getOpposite()), this, false);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        EnumFacing enumfacing;
        switch (p_getStateFromMeta_1_ & 7) {
            case 0: {
                enumfacing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.getDefaultState().withProperty(FACING, enumfacing).withProperty(POWERED, (p_getStateFromMeta_1_ & 8) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i;
        switch (p_getMetaFromState_1_.getValue(FACING)) {
            case EAST: {
                i = 1;
                break;
            }
            case WEST: {
                i = 2;
                break;
            }
            case SOUTH: {
                i = 3;
                break;
            }
            case NORTH: {
                i = 4;
                break;
            }
            default: {
                i = 5;
                break;
            }
            case DOWN: {
                i = 0;
            }
        }
        if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, POWERED);
    }
}

