/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCactus
extends Block
implements IPlantable {
    public static final PropertyInteger AGE = PropertyInteger.create("age", 0, 15);
    protected static final AxisAlignedBB CACTUS_COLLISION_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
    protected static final AxisAlignedBB CACTUS_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    protected BlockCactus() {
        super(Material.CACTUS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(AGE, 0));
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        BlockPos blockpos = p_updateTick_2_.up();
        if (p_updateTick_1_.isAirBlock(blockpos)) {
            int i = 1;
            while (p_updateTick_1_.getBlockState(p_updateTick_2_.down(i)).getBlock() == this) {
                ++i;
            }
            if (i < 3) {
                int j = p_updateTick_3_.getValue(AGE);
                if (ForgeHooks.onCropsGrowPre(p_updateTick_1_, blockpos, p_updateTick_3_, true)) {
                    if (j == 15) {
                        p_updateTick_1_.setBlockState(blockpos, this.getDefaultState());
                        IBlockState iblockstate = p_updateTick_3_.withProperty(AGE, 0);
                        p_updateTick_1_.setBlockState(p_updateTick_2_, iblockstate, 4);
                        iblockstate.neighborChanged(p_updateTick_1_, blockpos, this, p_updateTick_2_);
                    } else {
                        p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(AGE, j + 1), 4);
                    }
                    ForgeHooks.onCropsGrowPost(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_1_.getBlockState(p_updateTick_2_));
                }
            }
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return CACTUS_COLLISION_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBox(IBlockState p_getSelectedBoundingBox_1_, World p_getSelectedBoundingBox_2_, BlockPos p_getSelectedBoundingBox_3_) {
        return CACTUS_AABB.offset(p_getSelectedBoundingBox_3_);
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) ? this.canBlockStay(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) : false;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!this.canBlockStay(p_neighborChanged_2_, p_neighborChanged_3_)) {
            p_neighborChanged_2_.destroyBlock(p_neighborChanged_3_, true);
        }
    }

    public boolean canBlockStay(World p_canBlockStay_1_, BlockPos p_canBlockStay_2_) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            Material material = p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.offset(enumfacing)).getMaterial();
            if (!material.isSolid() && material != Material.LAVA) continue;
            return false;
        }
        IBlockState state = p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.down());
        return state.getBlock().canSustainPlant(state, p_canBlockStay_1_, p_canBlockStay_2_.down(), EnumFacing.UP, this) && !p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.up()).getMaterial().isLiquid();
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        p_onEntityCollidedWithBlock_4_.attackEntityFrom(DamageSource.CACTUS, 1.0f);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(AGE, p_getStateFromMeta_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(AGE);
    }

    @Override
    public EnumPlantType getPlantType(IBlockAccess p_getPlantType_1_, BlockPos p_getPlantType_2_) {
        return EnumPlantType.Desert;
    }

    @Override
    public IBlockState getPlant(IBlockAccess p_getPlant_1_, BlockPos p_getPlant_2_) {
        return this.getDefaultState();
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AGE);
    }
}

