/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCauldron
extends Block {
    public static final PropertyInteger LEVEL = PropertyInteger.create("level", 0, 3);
    protected static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public BlockCauldron() {
        super(Material.IRON, MapColor.STONE);
        this.setDefaultState(this.blockState.getBaseState().withProperty(LEVEL, 0));
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        BlockCauldron.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_LEGS);
        BlockCauldron.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_WALL_WEST);
        BlockCauldron.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_WALL_NORTH);
        BlockCauldron.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_WALL_EAST);
        BlockCauldron.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_WALL_SOUTH);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return FULL_BLOCK_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        int lvt_5_1_ = p_onEntityCollidedWithBlock_3_.getValue(LEVEL);
        float lvt_6_1_ = (float)p_onEntityCollidedWithBlock_2_.getY() + (6.0f + (float)(3 * lvt_5_1_)) / 16.0f;
        if (!p_onEntityCollidedWithBlock_1_.isRemote && p_onEntityCollidedWithBlock_4_.isBurning() && lvt_5_1_ > 0 && p_onEntityCollidedWithBlock_4_.getEntityBoundingBox().minY <= (double)lvt_6_1_) {
            p_onEntityCollidedWithBlock_4_.extinguish();
            this.setWaterLevel(p_onEntityCollidedWithBlock_1_, p_onEntityCollidedWithBlock_2_, p_onEntityCollidedWithBlock_3_, lvt_5_1_ - 1);
        }
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        ItemArmor lvt_13_3_;
        ItemStack lvt_10_1_ = p_onBlockActivated_4_.getHeldItem(p_onBlockActivated_5_);
        if (lvt_10_1_.isEmpty()) {
            return true;
        }
        int lvt_11_1_ = p_onBlockActivated_3_.getValue(LEVEL);
        Item lvt_12_1_ = lvt_10_1_.getItem();
        if (lvt_12_1_ == Items.WATER_BUCKET) {
            if (lvt_11_1_ < 3 && !p_onBlockActivated_1_.isRemote) {
                if (!p_onBlockActivated_4_.capabilities.isCreativeMode) {
                    p_onBlockActivated_4_.setHeldItem(p_onBlockActivated_5_, new ItemStack(Items.BUCKET));
                }
                p_onBlockActivated_4_.addStat(StatList.CAULDRON_FILLED);
                this.setWaterLevel(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_, 3);
                p_onBlockActivated_1_.playSound(null, p_onBlockActivated_2_, SoundEvents.ITEM_BUCKET_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (lvt_12_1_ == Items.BUCKET) {
            if (lvt_11_1_ == 3 && !p_onBlockActivated_1_.isRemote) {
                if (!p_onBlockActivated_4_.capabilities.isCreativeMode) {
                    lvt_10_1_.shrink(1);
                    if (lvt_10_1_.isEmpty()) {
                        p_onBlockActivated_4_.setHeldItem(p_onBlockActivated_5_, new ItemStack(Items.WATER_BUCKET));
                    } else if (!p_onBlockActivated_4_.inventory.addItemStackToInventory(new ItemStack(Items.WATER_BUCKET))) {
                        p_onBlockActivated_4_.dropItem(new ItemStack(Items.WATER_BUCKET), false);
                    }
                }
                p_onBlockActivated_4_.addStat(StatList.CAULDRON_USED);
                this.setWaterLevel(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_, 0);
                p_onBlockActivated_1_.playSound(null, p_onBlockActivated_2_, SoundEvents.ITEM_BUCKET_FILL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (lvt_12_1_ == Items.GLASS_BOTTLE) {
            if (lvt_11_1_ > 0 && !p_onBlockActivated_1_.isRemote) {
                if (!p_onBlockActivated_4_.capabilities.isCreativeMode) {
                    ItemStack lvt_13_1_ = PotionUtils.addPotionToItemStack(new ItemStack(Items.POTIONITEM), PotionTypes.WATER);
                    p_onBlockActivated_4_.addStat(StatList.CAULDRON_USED);
                    lvt_10_1_.shrink(1);
                    if (lvt_10_1_.isEmpty()) {
                        p_onBlockActivated_4_.setHeldItem(p_onBlockActivated_5_, lvt_13_1_);
                    } else if (!p_onBlockActivated_4_.inventory.addItemStackToInventory(lvt_13_1_)) {
                        p_onBlockActivated_4_.dropItem(lvt_13_1_, false);
                    } else if (p_onBlockActivated_4_ instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)p_onBlockActivated_4_).sendContainerToPlayer(p_onBlockActivated_4_.inventoryContainer);
                    }
                }
                p_onBlockActivated_1_.playSound(null, p_onBlockActivated_2_, SoundEvents.ITEM_BOTTLE_FILL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.setWaterLevel(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_, lvt_11_1_ - 1);
            }
            return true;
        }
        if (lvt_12_1_ == Items.POTIONITEM && PotionUtils.getPotionFromItem(lvt_10_1_) == PotionTypes.WATER) {
            if (lvt_11_1_ < 3 && !p_onBlockActivated_1_.isRemote) {
                if (!p_onBlockActivated_4_.capabilities.isCreativeMode) {
                    ItemStack lvt_13_2_ = new ItemStack(Items.GLASS_BOTTLE);
                    p_onBlockActivated_4_.addStat(StatList.CAULDRON_USED);
                    p_onBlockActivated_4_.setHeldItem(p_onBlockActivated_5_, lvt_13_2_);
                    if (p_onBlockActivated_4_ instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)p_onBlockActivated_4_).sendContainerToPlayer(p_onBlockActivated_4_.inventoryContainer);
                    }
                }
                p_onBlockActivated_1_.playSound(null, p_onBlockActivated_2_, SoundEvents.ITEM_BOTTLE_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.setWaterLevel(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_, lvt_11_1_ + 1);
            }
            return true;
        }
        if (lvt_11_1_ > 0 && lvt_12_1_ instanceof ItemArmor && (lvt_13_3_ = (ItemArmor)lvt_12_1_).getArmorMaterial() == ItemArmor.ArmorMaterial.LEATHER && lvt_13_3_.hasColor(lvt_10_1_) && !p_onBlockActivated_1_.isRemote) {
            lvt_13_3_.removeColor(lvt_10_1_);
            this.setWaterLevel(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_, lvt_11_1_ - 1);
            p_onBlockActivated_4_.addStat(StatList.ARMOR_CLEANED);
            return true;
        }
        if (lvt_11_1_ > 0 && lvt_12_1_ instanceof ItemBanner) {
            if (TileEntityBanner.getPatterns(lvt_10_1_) > 0 && !p_onBlockActivated_1_.isRemote) {
                ItemStack lvt_13_4_ = lvt_10_1_.copy();
                lvt_13_4_.setCount(1);
                TileEntityBanner.removeBannerData(lvt_13_4_);
                p_onBlockActivated_4_.addStat(StatList.BANNER_CLEANED);
                if (!p_onBlockActivated_4_.capabilities.isCreativeMode) {
                    lvt_10_1_.shrink(1);
                    this.setWaterLevel(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_, lvt_11_1_ - 1);
                }
                if (lvt_10_1_.isEmpty()) {
                    p_onBlockActivated_4_.setHeldItem(p_onBlockActivated_5_, lvt_13_4_);
                } else if (!p_onBlockActivated_4_.inventory.addItemStackToInventory(lvt_13_4_)) {
                    p_onBlockActivated_4_.dropItem(lvt_13_4_, false);
                } else if (p_onBlockActivated_4_ instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)p_onBlockActivated_4_).sendContainerToPlayer(p_onBlockActivated_4_.inventoryContainer);
                }
            }
            return true;
        }
        return false;
    }

    public void setWaterLevel(World p_setWaterLevel_1_, BlockPos p_setWaterLevel_2_, IBlockState p_setWaterLevel_3_, int p_setWaterLevel_4_) {
        p_setWaterLevel_1_.setBlockState(p_setWaterLevel_2_, p_setWaterLevel_3_.withProperty(LEVEL, MathHelper.clamp(p_setWaterLevel_4_, 0, 3)), 2);
        p_setWaterLevel_1_.updateComparatorOutputLevel(p_setWaterLevel_2_, this);
    }

    @Override
    public void fillWithRain(World p_fillWithRain_1_, BlockPos p_fillWithRain_2_) {
        if (p_fillWithRain_1_.rand.nextInt(20) != 1) {
            return;
        }
        float lvt_3_1_ = p_fillWithRain_1_.getBiome(p_fillWithRain_2_).getFloatTemperature(p_fillWithRain_2_);
        if (p_fillWithRain_1_.getBiomeProvider().getTemperatureAtHeight(lvt_3_1_, p_fillWithRain_2_.getY()) < 0.15f) {
            return;
        }
        IBlockState lvt_4_1_ = p_fillWithRain_1_.getBlockState(p_fillWithRain_2_);
        if (lvt_4_1_.getValue(LEVEL) < 3) {
            p_fillWithRain_1_.setBlockState(p_fillWithRain_2_, lvt_4_1_.cycleProperty(LEVEL), 2);
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.CAULDRON;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.CAULDRON);
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        return p_getComparatorInputOverride_1_.getValue(LEVEL);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(LEVEL, p_getStateFromMeta_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(LEVEL);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, LEVEL);
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return true;
    }
}

