/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockChest
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    protected static final AxisAlignedBB NORTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.875, 0.9375);
    protected static final AxisAlignedBB SOUTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 1.0);
    protected static final AxisAlignedBB WEST_CHEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    protected static final AxisAlignedBB EAST_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 0.875, 0.9375);
    protected static final AxisAlignedBB NOT_CONNECTED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    public final Type chestType;

    protected BlockChest(Type p_i46689_1_) {
        super(Material.WOOD);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH));
        this.chestType = p_i46689_1_;
        this.setCreativeTab(p_i46689_1_ == Type.TRAP ? CreativeTabs.REDSTONE : CreativeTabs.DECORATIONS);
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomBreakingProgress(IBlockState p_hasCustomBreakingProgress_1_) {
        return true;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return p_getBoundingBox_2_.getBlockState(p_getBoundingBox_3_.north()).getBlock() == this ? NORTH_CHEST_AABB : (p_getBoundingBox_2_.getBlockState(p_getBoundingBox_3_.south()).getBlock() == this ? SOUTH_CHEST_AABB : (p_getBoundingBox_2_.getBlockState(p_getBoundingBox_3_.west()).getBlock() == this ? WEST_CHEST_AABB : (p_getBoundingBox_2_.getBlockState(p_getBoundingBox_3_.east()).getBlock() == this ? EAST_CHEST_AABB : NOT_CONNECTED_AABB)));
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        this.checkForSurroundingChests(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = p_onBlockAdded_2_.offset(enumfacing);
            IBlockState iblockstate = p_onBlockAdded_1_.getBlockState(blockpos);
            if (iblockstate.getBlock() != this) continue;
            this.checkForSurroundingChests(p_onBlockAdded_1_, blockpos, iblockstate);
        }
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(FACING, p_getStateForPlacement_8_.getHorizontalFacing());
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        TileEntity tileentity;
        boolean flag3;
        EnumFacing enumfacing = EnumFacing.getHorizontal(MathHelper.floor((double)(p_onBlockPlacedBy_4_.rotationYaw * 4.0f / 360.0f) + 0.5) & 3).getOpposite();
        p_onBlockPlacedBy_3_ = p_onBlockPlacedBy_3_.withProperty(FACING, enumfacing);
        BlockPos blockpos = p_onBlockPlacedBy_2_.north();
        BlockPos blockpos1 = p_onBlockPlacedBy_2_.south();
        BlockPos blockpos2 = p_onBlockPlacedBy_2_.west();
        BlockPos blockpos3 = p_onBlockPlacedBy_2_.east();
        boolean flag = this == p_onBlockPlacedBy_1_.getBlockState(blockpos).getBlock();
        boolean flag1 = this == p_onBlockPlacedBy_1_.getBlockState(blockpos1).getBlock();
        boolean flag2 = this == p_onBlockPlacedBy_1_.getBlockState(blockpos2).getBlock();
        boolean bl = flag3 = this == p_onBlockPlacedBy_1_.getBlockState(blockpos3).getBlock();
        if (!(flag || flag1 || flag2 || flag3)) {
            p_onBlockPlacedBy_1_.setBlockState(p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_, 3);
        } else if (enumfacing.getAxis() != EnumFacing.Axis.X || !flag && !flag1) {
            if (enumfacing.getAxis() == EnumFacing.Axis.Z && (flag2 || flag3)) {
                if (flag2) {
                    p_onBlockPlacedBy_1_.setBlockState(blockpos2, p_onBlockPlacedBy_3_, 3);
                } else {
                    p_onBlockPlacedBy_1_.setBlockState(blockpos3, p_onBlockPlacedBy_3_, 3);
                }
                p_onBlockPlacedBy_1_.setBlockState(p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_, 3);
            }
        } else {
            if (flag) {
                p_onBlockPlacedBy_1_.setBlockState(blockpos, p_onBlockPlacedBy_3_, 3);
            } else {
                p_onBlockPlacedBy_1_.setBlockState(blockpos1, p_onBlockPlacedBy_3_, 3);
            }
            p_onBlockPlacedBy_1_.setBlockState(p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_, 3);
        }
        if (p_onBlockPlacedBy_5_.hasDisplayName() && (tileentity = p_onBlockPlacedBy_1_.getTileEntity(p_onBlockPlacedBy_2_)) instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).setCustomName(p_onBlockPlacedBy_5_.getDisplayName());
        }
    }

    public IBlockState checkForSurroundingChests(World p_checkForSurroundingChests_1_, BlockPos p_checkForSurroundingChests_2_, IBlockState p_checkForSurroundingChests_3_) {
        if (p_checkForSurroundingChests_1_.isRemote) {
            return p_checkForSurroundingChests_3_;
        }
        IBlockState iblockstate = p_checkForSurroundingChests_1_.getBlockState(p_checkForSurroundingChests_2_.north());
        IBlockState iblockstate1 = p_checkForSurroundingChests_1_.getBlockState(p_checkForSurroundingChests_2_.south());
        IBlockState iblockstate2 = p_checkForSurroundingChests_1_.getBlockState(p_checkForSurroundingChests_2_.west());
        IBlockState iblockstate3 = p_checkForSurroundingChests_1_.getBlockState(p_checkForSurroundingChests_2_.east());
        EnumFacing enumfacing = p_checkForSurroundingChests_3_.getValue(FACING);
        if (iblockstate.getBlock() != this && iblockstate1.getBlock() != this) {
            boolean flag = iblockstate.isFullBlock();
            boolean flag1 = iblockstate1.isFullBlock();
            if (iblockstate2.getBlock() == this || iblockstate3.getBlock() == this) {
                BlockPos blockpos1 = iblockstate2.getBlock() == this ? p_checkForSurroundingChests_2_.west() : p_checkForSurroundingChests_2_.east();
                IBlockState iblockstate7 = p_checkForSurroundingChests_1_.getBlockState(blockpos1.north());
                IBlockState iblockstate6 = p_checkForSurroundingChests_1_.getBlockState(blockpos1.south());
                enumfacing = EnumFacing.SOUTH;
                EnumFacing enumfacing2 = iblockstate2.getBlock() == this ? iblockstate2.getValue(FACING) : iblockstate3.getValue(FACING);
                if (enumfacing2 == EnumFacing.NORTH) {
                    enumfacing = EnumFacing.NORTH;
                }
                if ((flag || iblockstate7.isFullBlock()) && !flag1 && !iblockstate6.isFullBlock()) {
                    enumfacing = EnumFacing.SOUTH;
                }
                if ((flag1 || iblockstate6.isFullBlock()) && !flag && !iblockstate7.isFullBlock()) {
                    enumfacing = EnumFacing.NORTH;
                }
            }
        } else {
            BlockPos blockpos = iblockstate.getBlock() == this ? p_checkForSurroundingChests_2_.north() : p_checkForSurroundingChests_2_.south();
            IBlockState iblockstate4 = p_checkForSurroundingChests_1_.getBlockState(blockpos.west());
            IBlockState iblockstate5 = p_checkForSurroundingChests_1_.getBlockState(blockpos.east());
            enumfacing = EnumFacing.EAST;
            EnumFacing enumfacing1 = iblockstate.getBlock() == this ? iblockstate.getValue(FACING) : iblockstate1.getValue(FACING);
            if (enumfacing1 == EnumFacing.WEST) {
                enumfacing = EnumFacing.WEST;
            }
            if ((iblockstate2.isFullBlock() || iblockstate4.isFullBlock()) && !iblockstate3.isFullBlock() && !iblockstate5.isFullBlock()) {
                enumfacing = EnumFacing.EAST;
            }
            if ((iblockstate3.isFullBlock() || iblockstate5.isFullBlock()) && !iblockstate2.isFullBlock() && !iblockstate4.isFullBlock()) {
                enumfacing = EnumFacing.WEST;
            }
        }
        p_checkForSurroundingChests_3_ = p_checkForSurroundingChests_3_.withProperty(FACING, enumfacing);
        p_checkForSurroundingChests_1_.setBlockState(p_checkForSurroundingChests_2_, p_checkForSurroundingChests_3_, 3);
        return p_checkForSurroundingChests_3_;
    }

    public IBlockState correctFacing(World p_correctFacing_1_, BlockPos p_correctFacing_2_, IBlockState p_correctFacing_3_) {
        EnumFacing enumfacing = null;
        for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = p_correctFacing_1_.getBlockState(p_correctFacing_2_.offset(enumfacing1));
            if (iblockstate.getBlock() == this) {
                return p_correctFacing_3_;
            }
            if (!iblockstate.isFullBlock()) continue;
            if (enumfacing != null) {
                enumfacing = null;
                break;
            }
            enumfacing = enumfacing1;
        }
        if (enumfacing != null) {
            return p_correctFacing_3_.withProperty(FACING, enumfacing.getOpposite());
        }
        EnumFacing enumfacing2 = p_correctFacing_3_.getValue(FACING);
        if (p_correctFacing_1_.getBlockState(p_correctFacing_2_.offset(enumfacing2)).isFullBlock()) {
            enumfacing2 = enumfacing2.getOpposite();
        }
        if (p_correctFacing_1_.getBlockState(p_correctFacing_2_.offset(enumfacing2)).isFullBlock()) {
            enumfacing2 = enumfacing2.rotateY();
        }
        if (p_correctFacing_1_.getBlockState(p_correctFacing_2_.offset(enumfacing2)).isFullBlock()) {
            enumfacing2 = enumfacing2.getOpposite();
        }
        return p_correctFacing_3_.withProperty(FACING, enumfacing2);
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        int i = 0;
        BlockPos blockpos = p_canPlaceBlockAt_2_.west();
        BlockPos blockpos1 = p_canPlaceBlockAt_2_.east();
        BlockPos blockpos2 = p_canPlaceBlockAt_2_.north();
        BlockPos blockpos3 = p_canPlaceBlockAt_2_.south();
        if (p_canPlaceBlockAt_1_.getBlockState(blockpos).getBlock() == this) {
            if (this.isDoubleChest(p_canPlaceBlockAt_1_, blockpos)) {
                return false;
            }
            ++i;
        }
        if (p_canPlaceBlockAt_1_.getBlockState(blockpos1).getBlock() == this) {
            if (this.isDoubleChest(p_canPlaceBlockAt_1_, blockpos1)) {
                return false;
            }
            ++i;
        }
        if (p_canPlaceBlockAt_1_.getBlockState(blockpos2).getBlock() == this) {
            if (this.isDoubleChest(p_canPlaceBlockAt_1_, blockpos2)) {
                return false;
            }
            ++i;
        }
        if (p_canPlaceBlockAt_1_.getBlockState(blockpos3).getBlock() == this) {
            if (this.isDoubleChest(p_canPlaceBlockAt_1_, blockpos3)) {
                return false;
            }
            ++i;
        }
        return i <= 1;
    }

    private boolean isDoubleChest(World p_isDoubleChest_1_, BlockPos p_isDoubleChest_2_) {
        if (p_isDoubleChest_1_.getBlockState(p_isDoubleChest_2_).getBlock() != this) {
            return false;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (p_isDoubleChest_1_.getBlockState(p_isDoubleChest_2_.offset(enumfacing)).getBlock() != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        super.neighborChanged(p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_4_, p_neighborChanged_5_);
        TileEntity tileentity = p_neighborChanged_2_.getTileEntity(p_neighborChanged_3_);
        if (tileentity instanceof TileEntityChest) {
            tileentity.updateContainingBlockInfo();
        }
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        TileEntity tileentity = p_breakBlock_1_.getTileEntity(p_breakBlock_2_);
        if (tileentity instanceof IInventory) {
            InventoryHelper.dropInventoryItems(p_breakBlock_1_, p_breakBlock_2_, (IInventory)((Object)tileentity));
            p_breakBlock_1_.updateComparatorOutputLevel(p_breakBlock_2_, this);
        }
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        ILockableContainer ilockablecontainer = this.getLockableContainer(p_onBlockActivated_1_, p_onBlockActivated_2_);
        if (ilockablecontainer != null) {
            p_onBlockActivated_4_.displayGUIChest(ilockablecontainer);
            if (this.chestType == Type.BASIC) {
                p_onBlockActivated_4_.addStat(StatList.CHEST_OPENED);
            } else if (this.chestType == Type.TRAP) {
                p_onBlockActivated_4_.addStat(StatList.TRAPPED_CHEST_TRIGGERED);
            }
        }
        return true;
    }

    @Nullable
    public ILockableContainer getLockableContainer(World p_getLockableContainer_1_, BlockPos p_getLockableContainer_2_) {
        return this.getContainer(p_getLockableContainer_1_, p_getLockableContainer_2_, false);
    }

    @Nullable
    public ILockableContainer getContainer(World p_getContainer_1_, BlockPos p_getContainer_2_, boolean p_getContainer_3_) {
        TileEntity tileentity = p_getContainer_1_.getTileEntity(p_getContainer_2_);
        if (!(tileentity instanceof TileEntityChest)) {
            return null;
        }
        ILockableContainer ilockablecontainer = (TileEntityChest)tileentity;
        if (!p_getContainer_3_ && this.isBlocked(p_getContainer_1_, p_getContainer_2_)) {
            return null;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = p_getContainer_2_.offset(enumfacing);
            Block block = p_getContainer_1_.getBlockState(blockpos).getBlock();
            if (block != this) continue;
            if (this.isBlocked(p_getContainer_1_, blockpos)) {
                return null;
            }
            TileEntity tileentity1 = p_getContainer_1_.getTileEntity(blockpos);
            if (!(tileentity1 instanceof TileEntityChest)) continue;
            if (enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH) {
                ilockablecontainer = new InventoryLargeChest("container.chestDouble", ilockablecontainer, (TileEntityChest)tileentity1);
                continue;
            }
            ilockablecontainer = new InventoryLargeChest("container.chestDouble", (TileEntityChest)tileentity1, ilockablecontainer);
        }
        return ilockablecontainer;
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityChest();
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return this.chestType == Type.TRAP;
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        if (!p_getWeakPower_1_.canProvidePower()) {
            return 0;
        }
        int i = 0;
        TileEntity tileentity = p_getWeakPower_2_.getTileEntity(p_getWeakPower_3_);
        if (tileentity instanceof TileEntityChest) {
            i = ((TileEntityChest)tileentity).numPlayersUsing;
        }
        return MathHelper.clamp(i, 0, 15);
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return p_getStrongPower_4_ == EnumFacing.UP ? p_getStrongPower_1_.getWeakPower(p_getStrongPower_2_, p_getStrongPower_3_, p_getStrongPower_4_) : 0;
    }

    private boolean isBlocked(World p_isBlocked_1_, BlockPos p_isBlocked_2_) {
        return this.isBelowSolidBlock(p_isBlocked_1_, p_isBlocked_2_) || this.isOcelotSittingOnChest(p_isBlocked_1_, p_isBlocked_2_);
    }

    private boolean isBelowSolidBlock(World p_isBelowSolidBlock_1_, BlockPos p_isBelowSolidBlock_2_) {
        return p_isBelowSolidBlock_1_.getBlockState(p_isBelowSolidBlock_2_.up()).isSideSolid(p_isBelowSolidBlock_1_, p_isBelowSolidBlock_2_.up(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World p_isOcelotSittingOnChest_1_, BlockPos p_isOcelotSittingOnChest_2_) {
        for (Entity entity : p_isOcelotSittingOnChest_1_.getEntitiesWithinAABB(EntityOcelot.class, new AxisAlignedBB(p_isOcelotSittingOnChest_2_.getX(), p_isOcelotSittingOnChest_2_.getY() + 1, p_isOcelotSittingOnChest_2_.getZ(), p_isOcelotSittingOnChest_2_.getX() + 1, p_isOcelotSittingOnChest_2_.getY() + 2, p_isOcelotSittingOnChest_2_.getZ() + 1))) {
            EntityOcelot entityocelot = (EntityOcelot)entity;
            if (!entityocelot.isSitting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        return Container.calcRedstoneFromInventory(this.getLockableContainer(p_getComparatorInputOverride_2_, p_getComparatorInputOverride_3_));
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        EnumFacing enumfacing = EnumFacing.getFront(p_getStateFromMeta_1_);
        if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty(FACING, enumfacing);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(FACING).getIndex();
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING);
    }

    public static enum Type {
        BASIC,
        TRAP;

    }
}

