/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockChorusFlower
extends Block {
    public static final PropertyInteger AGE = PropertyInteger.create("age", 0, 5);

    protected BlockChorusFlower() {
        super(Material.PLANTS, MapColor.PURPLE);
        this.setDefaultState(this.blockState.getBaseState().withProperty(AGE, 0));
        this.setCreativeTab(CreativeTabs.DECORATIONS);
        this.setTickRandomly(true);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.AIR;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!this.canSurvive(p_updateTick_1_, p_updateTick_2_)) {
            p_updateTick_1_.destroyBlock(p_updateTick_2_, true);
        } else {
            int i;
            BlockPos blockpos = p_updateTick_2_.up();
            if (p_updateTick_1_.isAirBlock(blockpos) && blockpos.getY() < 256 && (i = p_updateTick_3_.getValue(AGE).intValue()) < 5 && ForgeHooks.onCropsGrowPre(p_updateTick_1_, blockpos, p_updateTick_3_, p_updateTick_4_.nextInt(1) == 0)) {
                boolean flag = false;
                boolean flag1 = false;
                IBlockState iblockstate = p_updateTick_1_.getBlockState(p_updateTick_2_.down());
                Block block = iblockstate.getBlock();
                if (block == Blocks.END_STONE) {
                    flag = true;
                } else if (block == Blocks.CHORUS_PLANT) {
                    int j = 1;
                    for (int k = 0; k < 4; ++k) {
                        Block block1 = p_updateTick_1_.getBlockState(p_updateTick_2_.down(j + 1)).getBlock();
                        if (block1 != Blocks.CHORUS_PLANT) {
                            if (block1 != Blocks.END_STONE) break;
                            flag1 = true;
                            break;
                        }
                        ++j;
                    }
                    int i1 = 4;
                    if (flag1) {
                        ++i1;
                    }
                    if (j < 2 || p_updateTick_4_.nextInt(i1) >= j) {
                        flag = true;
                    }
                } else if (iblockstate.getMaterial() == Material.AIR) {
                    flag = true;
                }
                if (flag && BlockChorusFlower.areAllNeighborsEmpty(p_updateTick_1_, blockpos, null) && p_updateTick_1_.isAirBlock(p_updateTick_2_.up(2))) {
                    p_updateTick_1_.setBlockState(p_updateTick_2_, Blocks.CHORUS_PLANT.getDefaultState(), 2);
                    this.placeGrownFlower(p_updateTick_1_, blockpos, i);
                } else if (i < 4) {
                    int l = p_updateTick_4_.nextInt(4);
                    boolean flag2 = false;
                    if (flag1) {
                        ++l;
                    }
                    for (int j1 = 0; j1 < l; ++j1) {
                        EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.random(p_updateTick_4_);
                        BlockPos blockpos1 = p_updateTick_2_.offset(enumfacing);
                        if (!p_updateTick_1_.isAirBlock(blockpos1) || !p_updateTick_1_.isAirBlock(blockpos1.down()) || !BlockChorusFlower.areAllNeighborsEmpty(p_updateTick_1_, blockpos1, enumfacing.getOpposite())) continue;
                        this.placeGrownFlower(p_updateTick_1_, blockpos1, i + 1);
                        flag2 = true;
                    }
                    if (flag2) {
                        p_updateTick_1_.setBlockState(p_updateTick_2_, Blocks.CHORUS_PLANT.getDefaultState(), 2);
                    } else {
                        this.placeDeadFlower(p_updateTick_1_, p_updateTick_2_);
                    }
                } else if (i == 4) {
                    this.placeDeadFlower(p_updateTick_1_, p_updateTick_2_);
                }
                ForgeHooks.onCropsGrowPost(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_1_.getBlockState(p_updateTick_2_));
            }
        }
    }

    private void placeGrownFlower(World p_placeGrownFlower_1_, BlockPos p_placeGrownFlower_2_, int p_placeGrownFlower_3_) {
        p_placeGrownFlower_1_.setBlockState(p_placeGrownFlower_2_, this.getDefaultState().withProperty(AGE, p_placeGrownFlower_3_), 2);
        p_placeGrownFlower_1_.playEvent(1033, p_placeGrownFlower_2_, 0);
    }

    private void placeDeadFlower(World p_placeDeadFlower_1_, BlockPos p_placeDeadFlower_2_) {
        p_placeDeadFlower_1_.setBlockState(p_placeDeadFlower_2_, this.getDefaultState().withProperty(AGE, 5), 2);
        p_placeDeadFlower_1_.playEvent(1034, p_placeDeadFlower_2_, 0);
    }

    private static boolean areAllNeighborsEmpty(World p_areAllNeighborsEmpty_0_, BlockPos p_areAllNeighborsEmpty_1_, EnumFacing p_areAllNeighborsEmpty_2_) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (enumfacing == p_areAllNeighborsEmpty_2_ || p_areAllNeighborsEmpty_0_.isAirBlock(p_areAllNeighborsEmpty_1_.offset(enumfacing))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) && this.canSurvive(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!this.canSurvive(p_neighborChanged_2_, p_neighborChanged_3_)) {
            p_neighborChanged_2_.scheduleUpdate(p_neighborChanged_3_, this, 1);
        }
    }

    public boolean canSurvive(World p_canSurvive_1_, BlockPos p_canSurvive_2_) {
        IBlockState iblockstate = p_canSurvive_1_.getBlockState(p_canSurvive_2_.down());
        Block block = iblockstate.getBlock();
        if (block != Blocks.CHORUS_PLANT && block != Blocks.END_STONE) {
            if (iblockstate.getMaterial() == Material.AIR) {
                int i = 0;
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    IBlockState iblockstate1 = p_canSurvive_1_.getBlockState(p_canSurvive_2_.offset(enumfacing));
                    Block block1 = iblockstate1.getBlock();
                    if (block1 == Blocks.CHORUS_PLANT) {
                        ++i;
                        continue;
                    }
                    if (iblockstate1.getMaterial() == Material.AIR) continue;
                    return false;
                }
                return i == 1;
            }
            return false;
        }
        return true;
    }

    @Override
    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        super.harvestBlock(p_harvestBlock_1_, p_harvestBlock_2_, p_harvestBlock_3_, p_harvestBlock_4_, p_harvestBlock_5_, p_harvestBlock_6_);
        BlockChorusFlower.spawnAsEntity(p_harvestBlock_1_, p_harvestBlock_3_, new ItemStack(Item.getItemFromBlock(this)));
    }

    @Override
    protected ItemStack getSilkTouchDrop(IBlockState p_getSilkTouchDrop_1_) {
        return ItemStack.EMPTY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(AGE, p_getStateFromMeta_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(AGE);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AGE);
    }

    public static void generatePlant(World p_generatePlant_0_, BlockPos p_generatePlant_1_, Random p_generatePlant_2_, int p_generatePlant_3_) {
        p_generatePlant_0_.setBlockState(p_generatePlant_1_, Blocks.CHORUS_PLANT.getDefaultState(), 2);
        BlockChorusFlower.growTreeRecursive(p_generatePlant_0_, p_generatePlant_1_, p_generatePlant_2_, p_generatePlant_1_, p_generatePlant_3_, 0);
    }

    private static void growTreeRecursive(World p_growTreeRecursive_0_, BlockPos p_growTreeRecursive_1_, Random p_growTreeRecursive_2_, BlockPos p_growTreeRecursive_3_, int p_growTreeRecursive_4_, int p_growTreeRecursive_5_) {
        int i = p_growTreeRecursive_2_.nextInt(4) + 1;
        if (p_growTreeRecursive_5_ == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockpos = p_growTreeRecursive_1_.up(j + 1);
            if (!BlockChorusFlower.areAllNeighborsEmpty(p_growTreeRecursive_0_, blockpos, null)) {
                return;
            }
            p_growTreeRecursive_0_.setBlockState(blockpos, Blocks.CHORUS_PLANT.getDefaultState(), 2);
        }
        boolean flag = false;
        if (p_growTreeRecursive_5_ < 4) {
            int l = p_growTreeRecursive_2_.nextInt(4);
            if (p_growTreeRecursive_5_ == 0) {
                ++l;
            }
            for (int k = 0; k < l; ++k) {
                EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.random(p_growTreeRecursive_2_);
                BlockPos blockpos1 = p_growTreeRecursive_1_.up(i).offset(enumfacing);
                if (Math.abs(blockpos1.getX() - p_growTreeRecursive_3_.getX()) >= p_growTreeRecursive_4_ || Math.abs(blockpos1.getZ() - p_growTreeRecursive_3_.getZ()) >= p_growTreeRecursive_4_ || !p_growTreeRecursive_0_.isAirBlock(blockpos1) || !p_growTreeRecursive_0_.isAirBlock(blockpos1.down()) || !BlockChorusFlower.areAllNeighborsEmpty(p_growTreeRecursive_0_, blockpos1, enumfacing.getOpposite())) continue;
                flag = true;
                p_growTreeRecursive_0_.setBlockState(blockpos1, Blocks.CHORUS_PLANT.getDefaultState(), 2);
                BlockChorusFlower.growTreeRecursive(p_growTreeRecursive_0_, blockpos1, p_growTreeRecursive_2_, p_growTreeRecursive_3_, p_growTreeRecursive_4_, p_growTreeRecursive_5_ + 1);
            }
        }
        if (!flag) {
            p_growTreeRecursive_0_.setBlockState(p_growTreeRecursive_1_.up(i), Blocks.CHORUS_FLOWER.getDefaultState().withProperty(AGE, 5), 2);
        }
    }
}

