/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockChorusPlant
extends Block {
    public static final PropertyBool NORTH = PropertyBool.create("north");
    public static final PropertyBool EAST = PropertyBool.create("east");
    public static final PropertyBool SOUTH = PropertyBool.create("south");
    public static final PropertyBool WEST = PropertyBool.create("west");
    public static final PropertyBool UP = PropertyBool.create("up");
    public static final PropertyBool DOWN = PropertyBool.create("down");

    protected BlockChorusPlant() {
        super(Material.PLANTS, MapColor.PURPLE);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false).withProperty(UP, false).withProperty(DOWN, false));
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        Block lvt_4_1_ = p_getActualState_2_.getBlockState(p_getActualState_3_.down()).getBlock();
        Block lvt_5_1_ = p_getActualState_2_.getBlockState(p_getActualState_3_.up()).getBlock();
        Block lvt_6_1_ = p_getActualState_2_.getBlockState(p_getActualState_3_.north()).getBlock();
        Block lvt_7_1_ = p_getActualState_2_.getBlockState(p_getActualState_3_.east()).getBlock();
        Block lvt_8_1_ = p_getActualState_2_.getBlockState(p_getActualState_3_.south()).getBlock();
        Block lvt_9_1_ = p_getActualState_2_.getBlockState(p_getActualState_3_.west()).getBlock();
        return p_getActualState_1_.withProperty(DOWN, lvt_4_1_ == this || lvt_4_1_ == Blocks.CHORUS_FLOWER || lvt_4_1_ == Blocks.END_STONE).withProperty(UP, lvt_5_1_ == this || lvt_5_1_ == Blocks.CHORUS_FLOWER).withProperty(NORTH, lvt_6_1_ == this || lvt_6_1_ == Blocks.CHORUS_FLOWER).withProperty(EAST, lvt_7_1_ == this || lvt_7_1_ == Blocks.CHORUS_FLOWER).withProperty(SOUTH, lvt_8_1_ == this || lvt_8_1_ == Blocks.CHORUS_FLOWER).withProperty(WEST, lvt_9_1_ == this || lvt_9_1_ == Blocks.CHORUS_FLOWER);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        p_getBoundingBox_1_ = p_getBoundingBox_1_.getActualState(p_getBoundingBox_2_, p_getBoundingBox_3_);
        float lvt_4_1_ = 0.1875f;
        float lvt_5_1_ = p_getBoundingBox_1_.getValue(WEST) != false ? 0.0f : 0.1875f;
        float lvt_6_1_ = p_getBoundingBox_1_.getValue(DOWN) != false ? 0.0f : 0.1875f;
        float lvt_7_1_ = p_getBoundingBox_1_.getValue(NORTH) != false ? 0.0f : 0.1875f;
        float lvt_8_1_ = p_getBoundingBox_1_.getValue(EAST) != false ? 1.0f : 0.8125f;
        float lvt_9_1_ = p_getBoundingBox_1_.getValue(UP) != false ? 1.0f : 0.8125f;
        float lvt_10_1_ = p_getBoundingBox_1_.getValue(SOUTH) != false ? 1.0f : 0.8125f;
        return new AxisAlignedBB(lvt_5_1_, lvt_6_1_, lvt_7_1_, lvt_8_1_, lvt_9_1_, lvt_10_1_);
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        if (!p_addCollisionBoxToList_7_) {
            p_addCollisionBoxToList_1_ = p_addCollisionBoxToList_1_.getActualState(p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_);
        }
        float lvt_8_1_ = 0.1875f;
        float lvt_9_1_ = 0.8125f;
        BlockChorusPlant.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125));
        if (p_addCollisionBoxToList_1_.getValue(WEST).booleanValue()) {
            BlockChorusPlant.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.1875, 0.8125, 0.8125));
        }
        if (p_addCollisionBoxToList_1_.getValue(EAST).booleanValue()) {
            BlockChorusPlant.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, new AxisAlignedBB(0.8125, 0.1875, 0.1875, 1.0, 0.8125, 0.8125));
        }
        if (p_addCollisionBoxToList_1_.getValue(UP).booleanValue()) {
            BlockChorusPlant.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, new AxisAlignedBB(0.1875, 0.8125, 0.1875, 0.8125, 1.0, 0.8125));
        }
        if (p_addCollisionBoxToList_1_.getValue(DOWN).booleanValue()) {
            BlockChorusPlant.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.1875, 0.8125));
        }
        if (p_addCollisionBoxToList_1_.getValue(NORTH).booleanValue()) {
            BlockChorusPlant.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.1875));
        }
        if (p_addCollisionBoxToList_1_.getValue(SOUTH).booleanValue()) {
            BlockChorusPlant.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, new AxisAlignedBB(0.1875, 0.1875, 0.8125, 0.8125, 0.8125, 1.0));
        }
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return 0;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!this.canSurviveAt(p_updateTick_1_, p_updateTick_2_)) {
            p_updateTick_1_.destroyBlock(p_updateTick_2_, true);
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.CHORUS_FRUIT;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return p_quantityDropped_1_.nextInt(2);
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        if (super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_)) {
            return this.canSurviveAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_);
        }
        return false;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!this.canSurviveAt(p_neighborChanged_2_, p_neighborChanged_3_)) {
            p_neighborChanged_2_.scheduleUpdate(p_neighborChanged_3_, this, 1);
        }
    }

    public boolean canSurviveAt(World p_canSurviveAt_1_, BlockPos p_canSurviveAt_2_) {
        boolean lvt_3_1_ = p_canSurviveAt_1_.isAirBlock(p_canSurviveAt_2_.up());
        boolean lvt_4_1_ = p_canSurviveAt_1_.isAirBlock(p_canSurviveAt_2_.down());
        for (EnumFacing lvt_6_1_ : EnumFacing.Plane.HORIZONTAL) {
            BlockPos lvt_7_1_ = p_canSurviveAt_2_.offset(lvt_6_1_);
            Block lvt_8_1_ = p_canSurviveAt_1_.getBlockState(lvt_7_1_).getBlock();
            if (lvt_8_1_ != this) continue;
            if (!lvt_3_1_ && !lvt_4_1_) {
                return false;
            }
            Block lvt_9_1_ = p_canSurviveAt_1_.getBlockState(lvt_7_1_.down()).getBlock();
            if (lvt_9_1_ != this && lvt_9_1_ != Blocks.END_STONE) continue;
            return true;
        }
        Block lvt_5_1_ = p_canSurviveAt_1_.getBlockState(p_canSurviveAt_2_.down()).getBlock();
        return lvt_5_1_ == this || lvt_5_1_ == Blocks.END_STONE;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, NORTH, EAST, SOUTH, WEST, UP, DOWN);
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        Block lvt_5_1_ = p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_)).getBlock();
        return lvt_5_1_ != this && lvt_5_1_ != Blocks.CHORUS_FLOWER && (p_shouldSideBeRendered_4_ != EnumFacing.DOWN || lvt_5_1_ != Blocks.END_STONE);
    }
}

