/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockCommandBlock
extends BlockContainer {
    public static final PropertyDirection FACING = BlockDirectional.FACING;
    public static final PropertyBool CONDITIONAL = PropertyBool.create("conditional");

    public BlockCommandBlock(MapColor p_i46688_1_) {
        super(Material.IRON, p_i46688_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(CONDITIONAL, false));
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        TileEntityCommandBlock lvt_3_1_ = new TileEntityCommandBlock();
        lvt_3_1_.setAuto(this == Blocks.CHAIN_COMMAND_BLOCK);
        return lvt_3_1_;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (p_neighborChanged_2_.isRemote) {
            return;
        }
        TileEntity lvt_6_1_ = p_neighborChanged_2_.getTileEntity(p_neighborChanged_3_);
        if (!(lvt_6_1_ instanceof TileEntityCommandBlock)) {
            return;
        }
        TileEntityCommandBlock lvt_7_1_ = (TileEntityCommandBlock)lvt_6_1_;
        boolean lvt_8_1_ = p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_);
        boolean lvt_9_1_ = lvt_7_1_.isPowered();
        boolean lvt_10_1_ = lvt_7_1_.isAuto();
        if (lvt_8_1_ && !lvt_9_1_) {
            lvt_7_1_.setPowered(true);
            if (lvt_7_1_.getMode() != TileEntityCommandBlock.Mode.SEQUENCE && !lvt_10_1_) {
                boolean lvt_11_1_ = !lvt_7_1_.isConditional() || this.isNextToSuccessfulCommandBlock(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
                lvt_7_1_.setConditionMet(lvt_11_1_);
                p_neighborChanged_2_.scheduleUpdate(p_neighborChanged_3_, this, this.tickRate(p_neighborChanged_2_));
                if (lvt_11_1_) {
                    this.propagateUpdate(p_neighborChanged_2_, p_neighborChanged_3_);
                }
            }
        } else if (!lvt_8_1_ && lvt_9_1_) {
            lvt_7_1_.setPowered(false);
        }
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (p_updateTick_1_.isRemote) {
            return;
        }
        TileEntity lvt_5_1_ = p_updateTick_1_.getTileEntity(p_updateTick_2_);
        if (lvt_5_1_ instanceof TileEntityCommandBlock) {
            TileEntityCommandBlock lvt_6_1_ = (TileEntityCommandBlock)lvt_5_1_;
            CommandBlockBaseLogic lvt_7_1_ = lvt_6_1_.getCommandBlockLogic();
            boolean lvt_8_1_ = !StringUtils.isNullOrEmpty(lvt_7_1_.getCommand());
            TileEntityCommandBlock.Mode lvt_9_1_ = lvt_6_1_.getMode();
            boolean lvt_10_1_ = !lvt_6_1_.isConditional() || this.isNextToSuccessfulCommandBlock(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_);
            boolean lvt_11_1_ = lvt_6_1_.isConditionMet();
            boolean lvt_12_1_ = false;
            if (lvt_9_1_ != TileEntityCommandBlock.Mode.SEQUENCE && lvt_11_1_ && lvt_8_1_) {
                lvt_7_1_.trigger(p_updateTick_1_);
                lvt_12_1_ = true;
            }
            if (lvt_6_1_.isPowered() || lvt_6_1_.isAuto()) {
                if (lvt_9_1_ == TileEntityCommandBlock.Mode.SEQUENCE && lvt_10_1_ && lvt_8_1_) {
                    lvt_7_1_.trigger(p_updateTick_1_);
                    lvt_12_1_ = true;
                }
                if (lvt_9_1_ == TileEntityCommandBlock.Mode.AUTO) {
                    p_updateTick_1_.scheduleUpdate(p_updateTick_2_, this, this.tickRate(p_updateTick_1_));
                    if (lvt_10_1_) {
                        this.propagateUpdate(p_updateTick_1_, p_updateTick_2_);
                    }
                }
            }
            if (!lvt_12_1_) {
                lvt_7_1_.setSuccessCount(0);
            }
            lvt_6_1_.setConditionMet(lvt_10_1_);
            p_updateTick_1_.updateComparatorOutputLevel(p_updateTick_2_, this);
        }
    }

    public boolean isNextToSuccessfulCommandBlock(World p_isNextToSuccessfulCommandBlock_1_, BlockPos p_isNextToSuccessfulCommandBlock_2_, IBlockState p_isNextToSuccessfulCommandBlock_3_) {
        EnumFacing lvt_4_1_ = p_isNextToSuccessfulCommandBlock_3_.getValue(FACING);
        TileEntity lvt_5_1_ = p_isNextToSuccessfulCommandBlock_1_.getTileEntity(p_isNextToSuccessfulCommandBlock_2_.offset(lvt_4_1_.getOpposite()));
        return lvt_5_1_ instanceof TileEntityCommandBlock && ((TileEntityCommandBlock)lvt_5_1_).getCommandBlockLogic().getSuccessCount() > 0;
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 1;
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        TileEntity lvt_10_1_ = p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_);
        if (lvt_10_1_ instanceof TileEntityCommandBlock && p_onBlockActivated_4_.canUseCommandBlock()) {
            p_onBlockActivated_4_.displayGuiCommandBlock((TileEntityCommandBlock)lvt_10_1_);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        TileEntity lvt_4_1_ = p_getComparatorInputOverride_2_.getTileEntity(p_getComparatorInputOverride_3_);
        if (lvt_4_1_ instanceof TileEntityCommandBlock) {
            return ((TileEntityCommandBlock)lvt_4_1_).getCommandBlockLogic().getSuccessCount();
        }
        return 0;
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        TileEntity lvt_6_1_ = p_onBlockPlacedBy_1_.getTileEntity(p_onBlockPlacedBy_2_);
        if (!(lvt_6_1_ instanceof TileEntityCommandBlock)) {
            return;
        }
        TileEntityCommandBlock lvt_7_1_ = (TileEntityCommandBlock)lvt_6_1_;
        CommandBlockBaseLogic lvt_8_1_ = lvt_7_1_.getCommandBlockLogic();
        if (p_onBlockPlacedBy_5_.hasDisplayName()) {
            lvt_8_1_.setName(p_onBlockPlacedBy_5_.getDisplayName());
        }
        if (!p_onBlockPlacedBy_1_.isRemote) {
            NBTTagCompound lvt_9_1_ = p_onBlockPlacedBy_5_.getTagCompound();
            if (lvt_9_1_ == null || !lvt_9_1_.hasKey("BlockEntityTag", 10)) {
                lvt_8_1_.setTrackOutput(p_onBlockPlacedBy_1_.getGameRules().getBoolean("sendCommandFeedback"));
                lvt_7_1_.setAuto(this == Blocks.CHAIN_COMMAND_BLOCK);
            }
            if (lvt_7_1_.getMode() == TileEntityCommandBlock.Mode.SEQUENCE) {
                boolean lvt_10_1_ = p_onBlockPlacedBy_1_.isBlockPowered(p_onBlockPlacedBy_2_);
                lvt_7_1_.setPowered(lvt_10_1_);
            }
        }
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getFront(p_getStateFromMeta_1_ & 7)).withProperty(CONDITIONAL, (p_getStateFromMeta_1_ & 8) != 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(FACING).getIndex() | (p_getMetaFromState_1_.getValue(CONDITIONAL) != false ? 8 : 0);
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, CONDITIONAL);
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getDirectionFromEntityLiving(p_getStateForPlacement_2_, p_getStateForPlacement_8_)).withProperty(CONDITIONAL, false);
    }

    public void propagateUpdate(World p_propagateUpdate_1_, BlockPos p_propagateUpdate_2_) {
        IBlockState lvt_7_1_;
        Block lvt_8_1_;
        TileEntityCommandBlock lvt_6_1_;
        IBlockState lvt_3_1_ = p_propagateUpdate_1_.getBlockState(p_propagateUpdate_2_);
        if (lvt_3_1_.getBlock() != Blocks.COMMAND_BLOCK && lvt_3_1_.getBlock() != Blocks.REPEATING_COMMAND_BLOCK) {
            return;
        }
        BlockPos.MutableBlockPos lvt_4_1_ = new BlockPos.MutableBlockPos(p_propagateUpdate_2_);
        lvt_4_1_.move(lvt_3_1_.getValue(FACING));
        TileEntity lvt_5_1_ = p_propagateUpdate_1_.getTileEntity(lvt_4_1_);
        while (lvt_5_1_ instanceof TileEntityCommandBlock && (lvt_6_1_ = (TileEntityCommandBlock)lvt_5_1_).getMode() == TileEntityCommandBlock.Mode.SEQUENCE && (lvt_8_1_ = (lvt_7_1_ = p_propagateUpdate_1_.getBlockState(lvt_4_1_)).getBlock()) == Blocks.CHAIN_COMMAND_BLOCK && !p_propagateUpdate_1_.isUpdateScheduled(lvt_4_1_, lvt_8_1_)) {
            p_propagateUpdate_1_.scheduleUpdate(new BlockPos(lvt_4_1_), lvt_8_1_, this.tickRate(p_propagateUpdate_1_));
            lvt_4_1_.move(lvt_7_1_.getValue(FACING));
            lvt_5_1_ = p_propagateUpdate_1_.getTileEntity(lvt_4_1_);
        }
    }
}

